<?php 
/**
* REGISTRO C405: REDUÇÃO Z (CÓDIGO 02 e 2D).
* Este registro deve ser apresentado com as informações da Redução Z de cada equipamento em funcionamento na
* data das operações de venda à qual se refere a redução. Inclui todos os documentos fiscais totalizados na Redução Z,
* inclusive as operações de venda realizadas durante o período de tolerância do Equipamento ECF.
* Nível hierárquico - 4
* Ocorrência - 1:1
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C410 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C410.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C410';
	
	/**
	* Valor total do PIS.
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais	
	* @position 02
	* @required true
	*/
	protected $vl_pis;
	
	/**
	* Valor total da COFINS.
	* @name $vl_cofins
	* @size undefined
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $vl_cofins;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>