<?php 
/**
* REGISTRO C490: REGISTRO ANALÍTICO DO MOVIMENTO DIÁRIO (CÓDIGO 02 e 2D).
* Este registro tem por objetivo representar a escrituração dos documentos fiscais emitidos por ECF e totalizados pela combinação de CST, CFOP e Alíquota.
* Validação do Registro: não podem ser informados dois ou mais registros com a mesma combinação de valores
* dos campos CST_ICMS, CFOP e ALIQ_ICMS. A combinação CST_ICMS, CFOP e ALIQ_ICMS deve existir no respectivo registro de itens do C470, quando este registro for exigido.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C490 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C490.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C490';
	
	/**
	* Código da Situação Tributária, conforme a Tabela indicada no item 4.3.1
	* @name $cst_icms
	* @size 3
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cst_icms;
	
	/**
	* Código Fiscal de Operação e Prestação.
	* @name $cfop
	* @size 4
	* @type numeric
	* @position 03
	* @required true
	*/
	protected $cfop;
	
	/**
	*
	* Alíquota do ICMS
	* $name $aliq_icms
	* @size 6
	* @type decimal 2 casas decimais
	* @position 04
	* @required true
	*/
	protected $aliq_icms;

	/**
	* Valor da operação correspondente à combinação de CST_ICMS, CFOP, e alíquota do ICMS, incluídas as despesas acessórias e acréscimos
	* $name $vl_opr
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 05
	* @required true
	*/
	protected $vl_opr;

	/**
	* Valor acumulado da base de cálculo do ICMS, referente à combinação de CST_ICMS, CFOP, e alíquota do ICMS.
	* @name $vl_bc_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required true	
	*/
	protected $vl_bc_icms;

	/**
	* Valor acumulado do ICMS, referente à combinação de CST_ICMS, CFOP e alíquota do ICMS.
	* @name $vl_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_icms;


	/**
	* Código da observação do lançamento fiscal (campo 02 do Registro 0460)
	* @name $cod_obs
	* @size 6
	* @type string
	* @position 08
	* @required true
	*/
	protected $cod_obs;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>