<?php 
/**
* REGISTRO D001: ABERTURA DO BLOCO D
* Este registro deve ser gerado para abertura do bloco D e indica se há informações sobre prestações ou contratações
* de serviços de comunicação, transporte interestadual e intermunicipal, com o devido suporte do correspondente documento fiscal.
* Validação do Registro: registro obrigatório e único. Se o campo IND_MOV tiver valor igual a 1 (um), só devem ser
* informados este registro de abertura e o registro D990, que é o registro de fechamento do Bloco D.
* Nível hierárquico - 1
* Ocorrência - um por arquivo
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_D001 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo D001.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='D001';
	
	/**
	* Indicador de movimento:
	* 	0- Bloco com dados informados;
	* 	1- Bloco sem dados informados
	* @name $ind_mov
	* @size 1
	* @type string	
	* @position 02
	* @required true
	*/
	protected $ind_mov;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>