<?php 
/**
* REGISTRO E100: PERÍODO DA APURAÇÃO DO ICMS.
* Este registro tem por objetivo informar o(s) período(s) de apuração do ICMS. Os períodos informados devem
* abranger todo o intervalo da escrituração fiscal, sem sobreposição ou omissão de datas ou períodos.
* Não podem ser informados dois ou mais registros com a mesma combinação de valores dos campos 02 (DT_INI),
* 03 (DT_FIN). Não devem existir lacunas ou sobreposições de datas nos períodos de apuração informados nestes registros, em comparação com as datas informadas no registro 0000.
* Nível hierárquico – 2
* Ocorrência – 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E100 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E100.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E100';
	
	/**
	* Data inicial a que a apuração se refere
	* @name $dt_ini
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_ini;
	
	/**
	* Data final a que a apuração se refere
	* @name $dt_end
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 03
	* @required true	
	*/
	protected $dt_end;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>