<?php 
/**
* REGISTRO E300: PERÍODO DE APURAÇÃO DO FUNDO DE COMBATE À POBREZA E DO ICMS DIFERENCIAL DE ALÍQUOTA – UF ORIGEM/DESTINO EC 87/15
* Este registro tem por objetivo informar o(s) período(s) de apuração do ICMS – Diferencial de Alíquota por UF
origem/destino, segundo o disposto na Emenda Constitucional 87/2015.
O registro é obrigatório se a soma, por UF, dos valores dos campos VL_ICMS_UF_DEST dos registros C101 e
D101 for maior que zero; ou VL_ICMS_UF_REM for maior que zero; ou VL_FCP_UF_DEST dos registros C101 e D101
for maior que zero ou ainda se houver um registro 0015 para a UF.
Os períodos informados no registro E300 deverão abranger todo o período da escrituração, para cada UF
informada, não sendo permitidos intervalos.

* Ocorrência – 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E300 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E300.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E300';
	
	/**
	* Sigla da unidade da federação a que se refere à apuração do FCP e do ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $uf
	* @size 2
	* @type string	
	* @position 02
	* @required true
	*/
	protected $uf;
	
	/**
	* Data inicial a que a apuração se refere
	* @name $dt_ini
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_ini;
	
	/**
	* Data final a que a apuração se refere
	* @name $dt_end
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 03
	* @required true	
	*/
	protected $dt_fin;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>