<?php 
/**
* REGISTRO E310: APURAÇÃO DO FUNDO DE COMBATE À POBREZA E DO ICMS DIFERENCIAL DE ALÍQUOTA – UF ORIGEM/DESTINO EC 87/15. (VÁLIDO A PARTIR DE 01/01/2017)
* Este registro tem por objetivo informar valores relativos à apuração do ICMS – Diferencial de Alíquota e Fundo
de Combate à Pobreza - FCP, por UF origem/destino, mesmo nos casos de períodos sem movimento. Registro obrigatório,
se existir o registro E300. 

* Ocorrência – 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E310 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E310.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E310';
	
	/**
	* Indicador de movimento 0 – Sem operações com ICMS Diferencial de Alíquota da UF de Origem/Destino; 1 – Com operações de ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $ind_mov_fcp_difal
	* @size undefined
	* @type string	
	* @position 02
	* @required true
	*/
	protected $ind_mov_fcp_difal;
	
	/**
	* Valor do "Saldo credor de período anterior – ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_sld_cred_ant_difal
	* @size undefined
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $vl_sld_cred_ant_difal;
	
	/**
	* Valor total dos débitos por "Saídas e prestações com débito do ICMS referente ao diferencial de alíquota devido à UF do Remetente/Destinatário
	* @name $vl_tot_debitos_difal
	* @size undefined
	* @type numeric	
	* @position 04
	* @required true	
	*/
	protected $vl_tot_debitos_difal;
	
	/**
	* Valor Total dos ajustes "Outros débitos ICMS Diferencial de Alíquota da UF de Origem/Destino" " e “Estorno de créditos ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_out_deb_difal
	* @size undefined
	* @type numeric	
	* @position 05
	* @required true	
	*/
	protected $vl_out_deb_difal;
	
	/**
	* Valor total dos créditos do ICMS referente ao diferencial de alíquota devido à UF dos Remetente/ Destinatário
	* @name $vl_tot_creditos_difal
	* @size undefined
	* @type numeric	
	* @position 06
	* @required true	
	*/
	protected $vl_tot_creditos_difal;
	
	/**
	* Valor total de Ajustes "Outros créditos ICMS Diferencial de Alíquota da UF de Origem/Destino" e “Estorno de débitos ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_out_cred_difal
	* @size undefined
	* @type numeric	
	* @position 07
	* @required true	
	*/
	protected $vl_out_cred_difal;
	
	/**
	* Valor total de Saldo devedor ICMS Diferencial de Alíquota da UF de Origem/Destino antes das deduções
	* @name $vl_sld_dev_ant_difal
	* @size undefined
	* @type numeric	
	* @position 08
	* @required true	
	*/
	protected $vl_sld_dev_ant_difal;
	
	/**
	* Valor total dos ajustes "Deduções ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_deducoes_difal
	* @size undefined
	* @type numeric	
	* @position 09
	* @required true	
	*/
	protected $vl_deducoes_difal;
	
	/**
	* Valor recolhido ou a recolher referente ao ICMS Diferencial de Alíquota da UF de Origem/Destino (08-09)
	* @name $vl_recol_difal
	* @size undefined
	* @type numeric	
	* @position 10
	* @required true	
	*/
	protected $vl_recol_difal;
	
	/**
	* Saldo credor a transportar para o período seguinte referente ao ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_sld_cred_transportar_difal
	* @size undefined
	* @type numeric	
	* @position 11
	* @required true	
	*/
	protected $vl_sld_cred_transportar_difal;
	
	/**
	* Valores recolhidos ou a recolher, extraapuração - ICMS Diferencial de Alíquota da UF de Origem/Destino
	* @name $vl_esp_difal
	* @size undefined
	* @type numeric	
	* @position 12
	* @required true	
	*/
	protected $vl_esp_difal;
	
	/**
	* Valor do "Saldo credor de período anterior – FCP
	* @name $vl_sld_cred_ant_fcp
	* @size undefined
	* @type numeric	
	* @position 13
	* @required true	
	*/
	protected $vl_sld_cred_ant_fcp;
	
	/**
	* Valor total dos débitos FCP por "Saídas e prestações"
	* @name $vl_tot_deb_fcp
	* @size undefined
	* @type numeric	
	* @position 14
	* @required true	
	*/
	protected $vl_tot_deb_fcp;
	
	/**
	* Valor total dos ajustes "Outros débitos FCP" e “Estorno de créditos FCP”
	* @name $vl_out_deb_fcp
	* @size undefined
	* @type numeric	
	* @position 15
	* @required true	
	*/
	protected $vl_out_deb_fcp;
	
	/**
	* Valor total dos créditos FCP por Entradas
	* @name $vl_tot_cred_fcp
	* @size undefined
	* @type numeric	
	* @position 16
	* @required true	
	*/
	protected $vl_tot_cred_fcp;
	
	/**
	* Valor total de Ajustes "Outros créditos FCP" e “Estorno de débitos FCP”
	* @name $vl_out_cred_fcp
	* @size undefined
	* @type numeric	
	* @position 17
	* @required true	
	*/
	protected $vl_out_cred_fcp;
	
	/**
	* Valor total de Saldo devedor FCP antes das deduções
	* @name $vl_sld_dev_ant_fcp
	* @size undefined
	* @type numeric	
	* @position 18
	* @required true	
	*/
	protected $vl_sld_dev_ant_fcp;
	
	/**
	* Valor total das deduções "FCP"
	* @name $vl_deducoes_fcp
	* @size undefined
	* @type numeric	
	* @position 19
	* @required true	
	*/
	protected $vl_deducoes_fcp;
	
	/**
	* Valor recolhido ou a recolher referente ao FCP (18–19)
	* @name $vl_recol_fcp
	* @size undefined
	* @type numeric	
	* @position 20
	* @required true	
	*/
	protected $vl_recol_fcp;
	
	/**
	* Saldo credor a transportar para o período seguinte referente ao FCP
	* @name $vl_sld_cred_transportar_fcp
	* @size undefined
	* @type numeric	
	* @position 21
	* @required true	
	*/
	protected $vl_sld_cred_transportar_fcp;
	
	/**
	* Valores recolhidos ou a recolher, extraapuração - FCP
	* @name $deb_esp_fcp
	* @size undefined
	* @type numeric	
	* @position 22
	* @required true	
	*/
	protected $deb_esp_fcp;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>