<?php 
/**
* REGISTRO G990: ENCERRAMENTO DO BLOCO G
* Este registro deve ser gerado para o encerramento do bloco G e indica o número total de registros existentes neste bloco.
* Nível hierárquico - 1
* Ocorrência – um por arquivo
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_G990 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo G990.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='G990';

	/**
	* Quantidade total de linhas do Bloco G
	* @name $qtd_lin_g
	* @size undefined
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $qtd_lin_g;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>