<?php 
/**
* REGISTRO H005:  TOTAIS DO INVENTÁRIO
* Este registro deve ser apresentado para discriminar os valores totais dos itens/produtos do inventário realizado em
31 de dezembro de cada exercício, ou nas demais datas estabelecidas pela legislação fiscal ou comercial.
O inventário deverá ser apresentado no arquivo da EFD-ICMS/IPI até o segundo mês subsequente ao evento. Ex.
inventário realizado em 31/12/08 deverá ser apresentado na EFD-ICMS/IPI de período de referência fevereiro de 2009.
A partir de julho de 2012, as empresas que exerçam as atividades descritas na Classificação Nacional de
Atividades Econômicas /Fiscal (CNAE-Fiscal) sob os códigos 4681-8/01 e 4681-8/02 deverão apresentar este registro,
mensalmente, para discriminar os valores itens/produtos do Inventário realizado ao final do mesmo período de referência
do arquivo da EFD-ICMS/IPI. Informar como MOT_INV o código “01”. Exemplo: o inventário realizado no final do mês
de janeiro, deverá ser apresentado na escrituração do mês de janeiro.
Atribuir valor Zero ao inventário significa escriturar sem estoque.
* Nível hierárquico - 2
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_H005 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo H005.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='H005';
	
	/**
	* Data do inventário
	* @name $dt_inv
	* @size 8
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $dt_inv;
	
	/**
	* Valor total do estoque
	* @name $vl_inv
	* @size undefined
	* @type numeric	
	* @position 03
	* @required true
	*/
	protected $vl_inv;
	
	/**
	* Informe o motivo do Inventário: 01 – No final no período; 02 – Na mudança de forma de tributação da mercadoria (ICMS); 03 – Na solicitação da baixa cadastral, paralisação temporária e outras situações; 04 – Na alteração de regime de pagamento – condição do contribuinte; 05 – Por determinação dos fiscos
	* @name $mot_inv
	* @size 2
	* @type string	
	* @position 04
	* @required true
	*/
	protected $mot_inv;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>