<?php 
/**
* REGISTRO K210: DESMONTAGEM DE MERCADORIAS - ITEM DE ORIGEM
* Este registro tem o objetivo de escriturar a desmontagem de mercadorias de tipos: 00 - Mercadoria para revenda; 01 - Matéria-Prima; 02 - Embalagem; 03 - Produtos em Processo; 04 - Produto Acabado; 05 - Subproduto e 10 - Outros Insumos - campo TIPO_ITEM do Registro 0200, no que se refere à saída do estoque do item de origem
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K210 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K210.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K210';
	
	/**
	* Data de início da ordem de serviço
	* @name $dt_ini_os
	* @size 8
	* @type numerico	
	* @position 02
	* @required false
	*/
	protected $dt_ini_os;
	
	/**
	* Data de conclusãoi da ordem de serviço
	* @name $dt_fin_os
	* @size 8
	* @type numerico	
	* @position 03
	* @required false
	*/
	protected $dt_fin_os;
	
	/**
	* Código de identificação da ordem de serviço
	* @name $cod_doc_os
	* @size 30
	* @type caractere	
	* @position 04
	* @required false
	*/
	protected $cod_doc_os;
	
	/**
	* Código do item de origem (campo 02 do Registro 0200)
	* @name $cod_item_ori
	* @size 60
	* @type caractere	
	* @position 05
	* @required true
	*/
	protected $cod_item_ori;
	
	/**
	* Quantidade de origem - saída do estoque
	* @name $qtd_ori
	* @size -
	* @type numerico
	* @position 06
	* @required true
	*/
	protected $qtd_ori;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>