<?php 
/**
* REGISTRO K250: INDUSTRIALIZAÇÃO EFETUADA POR TERCEIROS - ITENS PRODUZIDOS
* Este registro tem o objetivo de informar os produtos que foram industrializados por terceiros por encomenda e sua quantidade.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K250 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K250.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K250';
	
	/**
	* Data do reconhecimento da produção ocorrida no terceiro
	* @name $dt_prod
	* @size 8
	* @type numerico
	* @position 02
	* @required true
	*/
	protected $dt_prod;
	
	/**
	* Código do item produzido (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 03
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade produzida
	* @name $qtd
	* @size -
	* @type numerico
	* @position 04
	* @required true
	*/
	protected $qtd;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>