<?php 
/**
* REGISTRO K255: INDUSTRIALIZAÇÃO EM TERCEIROS – INSUMOS CONSUMIDOS
* Este registro tem o objetivo de informar a quantidade de consumo do insumo que foi remetido para ser industrializado em terceiro, vinculado ao produto resultante informado no campo COD_ITEM do Registro K250.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K255 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K255.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K255';
	
	/**
	* Data do reconhecimento do consumo do insumo referente ao produto informado no campo 04 do Registro K250
	* @name $dt_cons
	* @size 8
	* @type numerico
	* @position 02
	* @required true
	*/
	protected $dt_cons;
	
	/**
	* Código do insumo (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 03
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade de consumo do insumo.
	* @name $qtd
	* @size -
	* @type numerico
	* @position 04
	* @required true
	*/
	protected $qtd;
	
	/**
	* Código do insumo que foi substituído, caso ocorra a substituição (campo 02 do Registro 0210)
	* @name $cod_ins_subst
	* @size 60
	* @type caractere
	* @position 05
	* @required false
	*/
	protected $cod_ins_subst;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>