<?php 
/**
* REGISTRO K265: REPROCESSAMENTO/REPARO - MERCADORIAS CONSUMIDAS E/OU RETORNADAS
* Este registro tem o objetivo de informar o consumo de mercadoria e/ou o retorno de mercadoria ao estoque, ocorridos no reprocessamento/reparo de produto/insumo informado no Registro K260.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K265 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K265.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K265';
	
	/**
	* Código da mercadoria (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 02
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade consumida - saída do estoque
	* @name $qtd_cons
	* @size -
	* @type numerico
	* @position 03
	* @required false
	*/
	protected $qtd_cons;
	
	/**
	* Quantidade retornada - entrada em estoque
	* @name $qtd_ret
	* @size -
	* @type numerico
	* @position 04
	* @required false
	*/
	protected $qtd_ret;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>