<?php 
/**
* REGISTRO K270: CORREÇÃO DE APONTAMENTO DOS REGISTROS K210, K220, K230, K250 E K260
* Este registro tem o objetivo de escriturar correção de apontamento de período de apuração anterior, relativo ao Registro-pai, por tipo de Registro e por período de apuração em que o apontamento será corrigido.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K270 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K270.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K270';
	
	/**
	* Data inicial do período de apuração em que ocorreu o apontamento que está sendo corrigido
	* @name $dt_ini_ap
	* @size 8
	* @type numerico
	* @position 02
	* @required false
	*/
	protected $dt_ini_ap;
	
	/**
	* Data final do período de apuração em que ocorreu o apontamento que está sendo corrigido
	* @name $dt_fin_ap
	* @size 8
	* @type numerico
	* @position 03
	* @required false
	*/
	protected $dt_fin_ap;
	
	/**
	* Código de identificação da ordem de produção ou da ordem de serviço que está sendo corrigida
	* @name $cod_op_os
	* @size 30
	* @type caractere
	* @position 04
	* @required false
	*/
	protected $cod_op_os;
	
	/**
	* Código da mercadoria que está sendo corrigido (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 05
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade de correção positiva de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_pos
	* @size -
	* @type numerico
	* @position 06
	* @required false
	*/
	protected $qtd_cor_pos;
	
	/**
	* Quantidade de correção negativa de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_neg
	* @size -
	* @type numerico
	* @position 07
	* @required false
	*/
	protected $qtd_cor_neg;
	
	/**
	* 1 - correção de apontamento de produção e/ou consumo relativo aos Registros K230/K235; 2 - correção de apontamento de produção e/ou consumo relativo aos Registros K250/K255; 3 - correção de apontamento de desmontagem e/ou consumo relativo aos Registros K210/K215; 4 - correção de apontamento de reprocessamento/reparo e/ou consumo relativo aos Registros K260/K265; 5 - correção de apontamento de movimentação interna relativo ao Registro K220.
	* @name $origem
	* @size 1
	* @type caractere
	* @position 08
	* @required true
	*/
	protected $origem;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>