<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	
	include '../../datapacket.php';
	include '../../TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	$empdir = $TParams->uploads.$TParams->getCodigo()."/"; //diretorio da empresa
	$arqdir = $TParams->uploads.$TParams->getCodigo()."/sped/"; //diretorio do arquivo a ser gerado
	
	if(!is_dir($empdir)){
		mkdir($empdir, 0777);
	}
	
	if(!is_dir($arqdir)){
		mkdir($arqdir, 0777);
	}
	
	//pegando dados da empresa
	$company = $TParams->getCompany();	
	
	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	set_time_limit (300);
	
	error_reporting(E_ALL);
	
	function exibirConsumoDeRecursos() {
        // echo " Tempo: " . ((microtime(true) - INICIO) * 1000) . "ms <br/>";
        //  $memoria = memory_get_usage(true);
        $memoria = memory_get_peak_usage();
		echo " Mem&oacute;ria alocada: ";
		// $gb = 1024 * 1024 * 1024;
		// $mb = 1024 * 1024;
		$gb = 1073741824;
		$mb = 1048576;
		$kb = 1024;
		if ($memoria > $gb) {
			$exibir = floor($memoria / $gb);
			echo $exibir . "Gb ";
			$memoria -= $exibir * $gb;
		}

		if ($memoria > $mb) {
			$exibir = floor($memoria / $mb);
			echo $exibir . "Mb ";
			$memoria -= $exibir * $mb;
		}

		if ($memoria > $kb) {
			$exibir = floor($memoria / $kb);
			echo $exibir . "Kb ";
			$memoria -= $exibir * $kb;
		}

    }
	
	$_REQUEST['param'] = '{"dtini" : "'.$_POST["ini"].' 00:00:00", "dtfim" : "'.$_POST["fim"].' 23:59:59", "registros":["Registro_0000","Registro_0001","Registro_0005","Registro_0015","Registro_0100","Registro_0150","Registro_0190","Registro_0200", "Registro_0990", "Registro_C001", "Registro_C990", "Registro_D001", "Registro_D990"]}';

	// $data = json_decode(base64_decode($_REQUEST['param']));
	$data = json_decode($_REQUEST['param']);

	exibirConsumoDeRecursos();

	class Autoload{
		public static function load($nome) {
			$a=explode('_',$nome);
			$bloco=strtolower(substr($a[1],0,1));
			  $arquivo ='bloco_'.$bloco.'/'.$nome.".php";
			if (file_exists($arquivo))
				include_once($arquivo);
		}
	}
	
	spl_autoload_register(array("Autoload", 'load'));
	include_once('SpedFiscal.php');
	$sped=new SpedFiscal($arqdir.'spedFiscal_'.substr($data->dtini, 0, 4).'-'.substr($data->dtini, 5, 2).'.txt');

	/*
		BLOCOS DOS REGISTROS
	*/
	
	// $qtdeLinhas = array();
	
	if(strlen($company->emp_cpfcnpj)==14){
		$cnpj = $company->emp_cpfcnpj;
		$cpf = '';
	}else if(strlen($company->emp_cpfcnpj)==11){
		$cnpj = '';
		$cpf = $company->emp_cpfcnpj;
	}
	
	if(in_array("Registro_0000", $data->registros)){ //REG 0000 ABERTURA DO ARQUIVO DIGIAL E IDENTIFICACAO DA ENTIDADE
		$ano = substr($data->dtini, 0, 4);
		if($ano=="2017"){
			$versao = "011";
		}else{
			$versao = "010";
		}
		
		$reg_0000=new Registro_0000();
		$reg_0000->_set('cod_ver', $versao)
		->_set('cod_fin','0')
		->_set('dt_ini',str_replace("-","",date('d-m-Y', strtotime($data->dtini))))
		->_set('dt_fin',str_replace("-","",date('d-m-Y', strtotime($data->dtfim))))
		->_set('nome',substr(trim($company->emp_razao),0,100))
		->_set('cnpj',$cnpj)
		->_set('cpf',$cpf)
		->_set('uf',$company->emp_uf)
		->_set('ie',$company->emp_inscrg)
		->_set('cod_mun',$company->emp_codmun)
		->_set('im','')
		->_set('suframa','')
		->_set('ind_perfil','A')
		->_set('ind_ativ','1');
		$sped->add($reg_0000);
	}

	//###################################################################### ALIMENTACAO BLOCO 0 ################################################################################
	
	if(in_array("Registro_0001", $data->registros)){  // DEPENDE DE OUTROS REGISTROS //
		$reg_0001=new Registro_0001();
		$reg_0001->_set('ind_mov','0');
		$sped->add($reg_0001);
	}

	if(in_array("Registro_0005", $data->registros)){ //DAD0S COMPLEMENTARES DA ENTIDADE
		$reg_0005=new Registro_0005();
		$reg_0005->_set('fantasia', substr(trim($company->emp_fantasia), 0, 60))
		->_set('cep',$company->emp_cep)
		->_set('end', substr(trim($company->emp_endereco), 0, 60))
		->_set('num',$company->emp_num)
		->_set('compl',$company->emp_complem)
		->_set('bairro', substr(trim($company->emp_bairro), 0, 60))
		->_set('fone',$company->emp_fone)
		->_set('fax',$company->emp_fax)
		->_set('email',$company->emp_emailremetente);
		$sped->add($reg_0005);
	}
	
	if(in_array("Registro_0015", $data->registros)){ //DADOS DO CONTRIBUINTE SUBSTITUTO varios por arquivo
		$reg_0015=new Registro_0015();
		$reg_0015->_set('uf_st',$company->emp_uf)
		->_set('ie_st',$company->emp_inscrg);
		$sped->add($reg_0015);
	}
	
	if(in_array("Registro_0100", $data->registros)){ //DADOS DO CONTABILISTA
		$reg_0100=new Registro_0100();
		$reg_0100->_set('nome',$company->emp_ctb_nome)
		->_set('cpf',$company->emp_ctb_cpf)
		->_set('crc',$company->emp_ctb_crc)
		->_set('cnpj',$company->emp_ctb_cnpj)
		->_set('cep',$company->emp_ctb_cep)
		->_set('end',$company->emp_ctb_endereco)
		->_set('num',$company->emp_ctb_num)
		->_set('compl',$company->emp_ctb_compl)
		->_set('bairro',$company->emp_ctb_bairro)
		->_set('fone',$company->emp_ctb_fone)
		->_set('fax',$company->emp_ctb_fax)
		->_set('email',$company->emp_ctb_email)
		->_set('cod_mun',$company->emp_ctb_codmun);
		$sped->add($reg_0100);
	}

	if(in_array("Registro_0150", $data->registros)){ // TABELA DE CADASTRO DO PARTICIPANTE varios por arquivo
	
		/*
			select distinct a.cad_codigo,a.cad_nomeraz,a.cad_cnpjcpf,a.cad_inscrg,a.cad_codmun,a.cad_suframa,d.end_nome,d.end_compl,d.end_bairro,d.end_num from header_nota b left join e0155_comum.cadastro a on a.cad_codigo=b.cad_codigo left join e0155_comum.endereco d on d.cad_codigo=b.cad_codigo where not_dtfaturam between '2014-10-01' and '2014-10-31' group by a.cad_codigo
		*/
		
		$filtroCompany = '{"cod":"500180","params":[
			{"name":"database","value":"'.$company->emp_db_comum.'","type":"other"},
			{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
			{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
		]}';

		// $datapacket->setHost($TParams->getHost("empresas"));
		$datapacket->add($filtroCompany);
		$participante = $datapacket->open(true);
		$datapacket->clear();
	
		for($i=0; $i<count($participante); $i++){
		
			if($participante[$i]->cad_codigo!=''){
				if(strlen($participante[$i]->cad_cnpjcpf)==14){
					$cnpj = $participante[$i]->cad_cnpjcpf;
					$cpf  = '';
				}else{
					$cpf  = $participante[$i]->cad_cnpjcpf;
					$cnpj = '';
				}
				
				if(strlen($participante[$i]->cad_pessoa)==1){
					$ie = '';
				}else{
					$ie = $participante[$i]->cad_inscrg;
				}
			
				$reg_0150=new Registro_0150();
				$reg_0150->_set('cod_part',$participante[$i]->cad_codigo)
				->_set('nome',str_replace(""," ", trim($participante[$i]->cad_nomeraz)))
				->_set('cod_pais',1058)
				->_set('cnpj',$cnpj)
				->_set('cpf',$cpf)
				->_set('ie',$ie)
				->_set('cod_mun',$participante[$i]->cad_codmun)
				->_set('suframa',$participante[$i]->cad_suframa)
				->_set('end',str_replace(""," ",$participante[$i]->end_nome))
				->_set('num',$participante[$i]->end_num)
				->_set('compl',trim($participante[$i]->end_compl))
				->_set('bairro',$participante[$i]->end_bairro);
				$sped->add($reg_0150);
			}
		}
	}
	
	//usado somente quando houver alteração no registro 0150
	/*if(in_array("Registro_0175", $data->registros)){
		$reg_0175=new Registro_0175();
		$reg_0175->_set('dt_alt',)
		->_set('nr_campo',)
		->_set('cont_ant',);
		$sped->add($reg_0175);
	}*/
	
	$filtroUnidade = '{"cod":"700070","params":[
		{"name":"database","value":"'.$company->emp_db_sge.'","type":"other"},
		{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
		{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
	]}';
	$datapacket->setHost($TParams->getHost($TParams->getDb()));
	$datapacket->add($filtroUnidade);
	$dataUnidade = $datapacket->open(true);
	$datapacket->clear();
	
	if(in_array("Registro_0190", $data->registros)){ //IDENTIFICACAO DAS UNIDADES DE MEDIDA
		foreach($dataUnidade as $res){
			$reg_0190=new Registro_0190();
			$reg_0190->_set('unid',$res->uni_codigo)
			->_set('descr',$res->uni_descr);
			$sped->add($reg_0190);
		}
	}

	$filtroProduto = '{"cod":"700071","params":[
		{"name":"database","value":"'.$company->emp_db_sge.'","type":"other"},
		{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
		{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
	]}';
	
	/*
		select a.ref_codigo, a.ref_descr, a.ref_codbar, a.ref_reduz, a.uni_codigo, a.ref_tipo, a.ref_ncm, b.tri_aliqicms from referencia a left join tributacao b on a.tri_codigo = b.tri_codigo inner join -}database.item_nota i on a.ref_codigo=i.ref_codigo inner join -}database.header_nota h on h.not_codigo=i.not_codigo where h.not_tipo=9 and h.not_dtfaturam between -}data_ini and -}data_fim group by i.ref_codigo order by a.ref_codigo
	*/
	
	$datapacket->setHost($TParams->getHost($TParams->getDb()));
	$datapacket->add($filtroProduto);
	$dataProduto = $datapacket->open(true);
	$datapacket->clear();
	
	if(in_array("Registro_0200", $data->registros)){ //TABELA DE IDENTIFICACAO DO ITEM (PRODUTOS E SERVIÇOS)

		foreach($dataProduto as $res){

			/* Tabela Fácil
				0=Produto
				1=PA
				2=MP
				3=Insumo
				4=Servico
				5=web
			*/

			/* Tabela Sped
				00=Mercadoria para revenda
				01=Meteria prima
				02=Embalagem
				03=Produto em processo
				04=Produto acabado
				05=Subproduto
				06=Produto intermediário
				07=Material de uso e consumo
				08=Ativo imobilizado
				09=Serviços
				10=Outros insumos
				99=Outros
			*/
		
			switch($res->ref_tipo){
				case "0":
					$tipoItem="00";
					break;
				case "1":
					$tipoItem="04";
					break;
				case "2":
					$tipoItem="01";
					break;
				case "3":
					$tipoItem="07";
					break;
				case "4":
					$tipoItem="09";
					break;
				case "6":
					$tipoItem="01";
					break;
				default:
					$tipoItem="99";
					break;
			}
		
			$reg_0200=new Registro_0200();
			$tri_aliqicms = ( $res->tri_aliqicms>0 ) ? number_format($res->tri_aliqicms, 2, ",", "") : "0,00";
			$reg_0200->_set('cod_item', (string)$res->ref_codigo)
			->_set('descr_item', str_replace(""," ", $res->ref_descr))
			->_set('cod_barra', $res->ref_codbar)
			->_set('cod_ant_item', '')
			->_set('unid_inv', $res->uni_codigo)
			->_set('tipo_item', $tipoItem)
			->_set('cod_ncm', $res->ref_ncm)
			->_set('ex_ipi', '')
			->_set('cod_gen', '')
			->_set('cod_lst', '')
			->_set('ALIQ_ICMS', $tri_aliqicms);
			$sped->add($reg_0200);
			
		}
		
	}
	
	//usado somente quando houver alteração no registro 0200
	/*if(in_array("Registro_0205", $data->registros)){  
		$reg_0205=new Registro_0205();
		$reg_0205->_set('descr_ant_item',)
		->_set('dt_ini',)
		->_set('dt_fim',)
		->_set('cod_ant_item',);
		$sped->add($reg_0175);
	}*/
	
	if(in_array("Registro_0206", $data->registros)){ //CODIGO COMBUSTIVEL TABELA ANP
		$reg_0206=new Registro_0206();
		$reg_0206->_set('cod_comb','');
		$sped->add($reg_0206);
	}
	
	if(in_array("Registro_0220", $data->registros)){ //FATORES DE CONVERSAO DE UNIDADES
		$reg_0220=new Registro_0220();
		$reg_0220->_set('unid_conv','')
		->_set('fat_conv',0);
		$sped->add($reg_0220);
	}
	
	if(in_array("Registro_0300", $data->registros)){ //CADASTRO DE BENS OU COMPONENTES DO ATIVO IMOBILIZADO
		$reg_0300=new Registro_0300();
		$reg_0300->_set('cod_ind_bem','')
		->_set('ident_merc','')
		->_set('descr_item','')
		->_set('cod_prnc','')
		->_set('cod_cta','')
		->_set('nr_parc',0);
		$sped->add($reg_0300);
	}
	
	if(in_array("Registro_0305", $data->registros)){ //INFORMACAO SOBRE A UTILIZACAO DO BEM
		$reg_0305=new Registro_0305();
		$reg_0305->_set('cod_ccus','')
		->_set('func','')
		->_set('vida_util',0);
		$sped->add($reg_0305);
	}

	//TABELA DE NATUREZA DA OPERACAO	
	$filtro = '{"cod":"700074","params":[
		{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
		{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
	]}';
	/*
		select cfo.* from cfo inner join header_nota h on cfo.cfo_codigo=h.cfo_codigo where h.not_tipo=9 and h.not_dtfaturam between -}data_ini and -}data_fim group by cfo.cfo_codigo
	*/
	/*
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	$datapacket->add($filtro);
	$natureza = $datapacket->open(true);
	$datapacket->clear();
	if( is_array($natureza) && count($natureza)>0 ){
		foreach($natureza as $nat){
			$reg_0400=new Registro_0400();
			$reg_0400->_set('cod_nat',$nat->cfo_codigo)
			->_set('descr_nat',$nat->cfo_descr);
			$sped->add($reg_0400);
		}
	}
	*/
	
	/*NOTAS FISCAIS*/
	
	$filtro = '{"cod":"700072","params":[
		{"name":"database","value":"'.$company->emp_db_comum.'","type":"other"},
		{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
		{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
	]}';
	
	/*
		select header_nota.*, item_nota.*, condpagto.cdp_indpag, referencia.uni_codigo as unidade from header_nota left join condpagto on header_nota.cdp_codigo=condpagto.cdp_codigo inner join item_nota on header_nota.not_codigo=item_nota.not_codigo inner join referencia on item_nota.ref_codigo=referencia.ref_codigo where header_nota.not_tipo=9 and header_nota.not_dtfaturam between -}data_ini and -}data_fim order by header_nota.not_codigo
	*/
	
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	$datapacket->add($filtro);
	$notas = $datapacket->open(true);
	$datapacket->clear();
	
	
	
	//TABELA DE INFORMACAO COMPLEMENTAR DO DOCUMENTO FISCAL
	/*
	$not_inf_fisco = array();
	$i=1;
	foreach($notas as $n){
		if( $n->not_inf_fisco && trim(base64_decode($n->not_inf_fisco))!="" ){
			$not_inf_fisco[$n->not_codigo] = str_pad($i, 6, "0", STR_PAD_LEFT);
			
			$reg_0450=new Registro_0450();
			$reg_0450->_set('cod_inf', str_pad($i, 6, "0", STR_PAD_LEFT)) // este valor deve existir em pelo menos um dos demais blocos (C110)
			->_set('txt', base64_decode($n->not_inf_fisco));
			$sped->add($reg_0450);
			$i++;
		}
	}
	*/

	//TABELA DE OBSERVACOES DO LANCAMENTO FISCAL
	$obs = array();
	$cod_obs=100;
	$s="";
	foreach($notas as $n){
		$trib = json_decode(base64_decode($n->itn_tribjson));
		$trib = $trib->rowdata[0];
		
		if( strstr("20|30|40|41|70", $trib->tri_situacao) ){
			$txt = "ICMS Desonerado";
			if( strstr("20|70", $trib->tri_situacao) ){
				$cod_obs = 100;
				$icmsdeson = (($n->itn_valor*$trib->tri_redbaseicms)/100) * ($n->itn_aliqicms/100);
			}else{
				$cod_obs = 101;
				$icmsdeson = ($n->itn_valor * ($n->itn_aliqicms/100));
			}
		}elseif( $trib->tri_situacao=="50" ){
			$cod_obs = 102;
			$txt = "ICMS Suspenso";
			$icmsdeson = ($n->itn_valor * ($n->itn_aliqicms/100));
		}elseif( $trib->tri_situacao=="51" ){
			$cod_obs = 103;
			$txt = "ICMS Diferido";
			$icmsdeson = ($n->itn_valor * ($n->itn_aliqicms/100));
		}
		
		if( strstr("20|30|40|41|70|50|51", $trib->tri_situacao) ){
			$obs[$n->not_codigo] = array($cod_obs, $txt, $icmsdeson);
			
			if( !strstr($s, $trib->tri_situacao) ){
				$reg_0460=new Registro_0460();
				$reg_0460->_set('cod_obs', str_pad($cod_obs, 6, "0", STR_PAD_LEFT)) // este valor deve existir em pelo menos um dos demais blocos (C195)
				->_set('txt',$txt);
				$sped->add($reg_0460);
				
				$s.=$trib->tri_situacao."|";
			}
		}
	}
	

	if(in_array("Registro_0500", $data->registros)){ //PLANO DE CONTAS CONTABEIS
		$reg_0500=new Registro_0500();
		$reg_0500->_set('dt_alt',date('dmY', strtotime($data->dtini)))
		->_set('cod_nat_cc','09')
		->_set('ind_cta','S')
		->_set('nivel',1)
		->_set('cod_cta','1')
		->_set('nome_cta','Conta 1');
		$sped->add($reg_0500);
	}
	
	if(in_array("Registro_0600", $data->registros)){  //CENTRO DE CUSTOS
		$reg_0600=new Registro_0600();
		$reg_0600->_set('dt_alt',date('dmY', strtotime($data->dtini)))
		->_set('cod_ccus','01')
		->_set('ccus','Centro de custo 01');
		$sped->add($reg_0600);
	}
	
	if(in_array("Registro_0990", $data->registros)){ //ENCERRAMENTO DO BLOCO 0
		$reg_0990=new Registro_0990();
		$reg_0990->_set('qtd_lin_0',$sped->countBloco('0'));
		$sped->add($reg_0990);
	}

	//###################################################################### ALIMENTACAO BLOCO C ################################################################################
	
	if(in_array("Registro_C001", $data->registros)){ //ABERTURA DO BLOCO C
		$reg_C001=new Registro_C001();
		$reg_C001->_set('ind_mov',0);
		$sped->add($reg_C001);
	}
	
	$not_codigo = "";
	//o conjunto cfop, cst (icms) e aliquota não pode se repetir no registro C190
	$conjunto="";
	$itn_subtotal = 0;
	$itn_baseicms = 0;
	$itn_icms = 0;
	$tot_icms = 0;
	$itn_baseicmsst = 0;
	$itn_icmssubst = 0;
	$tri_redbaseicms = 0;
	$itn_ipi = 0;
	
	foreach($notas as $nota){
		
		//C100
		if( $not_codigo!=$nota->not_codigo ){
			
			$cod_mod = ($nota->not_tipo==9) ? "55" : "65";
			$cod_sit = ($nota->not_status==2) ? "00" : "02";
			if($nota->not_frete>0){
				$ind_frt = ($nota->not_tpfrete==1) ? '0' : '1';
			}else{
				$ind_frt='9';
			}
			$vl_doc = ($nota->not_totalnota>0) ? number_format($nota->not_totalnota, 2, ",", "") : "0,00";
			$vl_desc = ($nota->not_valordesc>0) ? number_format($nota->not_valordesc, 2, ",", "") : "0,00";
			$vl_merc = ($nota->not_totalprod>0) ? number_format($nota->not_totalprod, 2, ",", "") : "0,00";
			$vl_frt = ($nota->not_frete>0) ? number_format($nota->not_frete, 2, ",", "") : "0,00";
			$vl_seg = ($nota->not_seguro>0) ? number_format($nota->not_seguro, 2, ",", "") : "0,00";
			$vl_out_da = ($nota->not_despesa>0) ? number_format($nota->not_despesa, 2, ",", "") : "0,00";
			$vl_bc_icms = ($nota->not_totbaseicms>0) ? number_format($nota->not_totbaseicms, 2, ",", "") : "0,00";
			$vl_icms = ($nota->not_toticms>0) ? number_format($nota->not_toticms, 2, ",", "") : "0,00";
			$vl_bc_icms_st = ($nota->not_totbaseicmsst>0) ? number_format($nota->not_totbaseicmsst, 2, ",", "") : "0,00";
			$vl_icms_st = ($nota->not_toticmssubst>0) ? number_format($nota->not_toticmssubst, 2, ",", "") : "0,00";
			$vl_ipi = ($nota->not_totipi>0) ? number_format($nota->not_totipi, 2, ",", "") : "0,00";
			$vl_pis = "0,00";
			$vl_cofins = "0,00";
			$vl_pis_st = "0,00";
			$vl_cofins_st = "0,00";
			
			$reg_C100 = new Registro_C100();
			if($cod_sit=='00'){
				$reg_C100->_set('ind_oper', ($nota->not_entrsaida-1))
				->_set('ind_emit', '0')
				->_set('cod_part', $nota->cad_codigo)
				->_set('cod_mod', $cod_mod)
				->_set('cod_sit', $cod_sit)
				->_set('ser', $nota->ser_codigo)
				->_set('num_doc', $nota->not_numero)
				->_set('chv_nfe', $nota->not_key_nfe)
				->_set('dt_doc', date('dmY', strtotime(substr($nota->not_data,0,10))))
				->_set('dt_e_s', date('dmY', strtotime(substr($nota->not_dtemissao,0,10))))
				->_set('vl_doc', $vl_doc)
				->_set('ind_pgto', $nota->cdp_indpag)
				->_set('vl_desc', $vl_desc)
				->_set('vl_abat_nt', '0,00')
				->_set('vl_merc', $vl_merc)
				->_set('ind_frt',  $ind_frt)
				->_set('vl_frt', $vl_frt)
				->_set('vl_seg', $vl_seg)
				->_set('vl_out_da', $vl_out_da)
				->_set('vl_bc_icms', $vl_bc_icms)
				->_set('vl_icms', $vl_icms)
				->_set('vl_bc_icms_st', $vl_bc_icms_st)
				->_set('vl_icms_st', $vl_icms_st)
				->_set('vl_ipi', $vl_ipi)
				->_set('vl_pis', $vl_pis)
				->_set('vl_cofins', $vl_cofins)
				->_set('vl_pis_st', $vl_pis_st)
				->_set('vl_cofins_st', $vl_cofins_st);
			}else{
				$reg_C100->_set('ind_oper', ($nota->not_entrsaida-1))
				->_set('ind_emit', '0')
				->_set('cod_mod', $cod_mod)
				->_set('cod_sit', $cod_sit)
				->_set('ser', $nota->ser_codigo)
				->_set('num_doc', $nota->not_numero)
				->_set('chv_nfe', $nota->not_key_nfe);
			}
			$sped->add($reg_C100);
			
			$not_codigo = $nota->not_codigo;
			$conjunto = "";
			
		}
		
		$trib = json_decode(base64_decode($nota->itn_tribjson));
		$trib = $trib->rowdata[0];
		
		$cst_ipi = str_pad($trib->tri_sit_ipi, 2, "0", STR_PAD_LEFT);
		if($nota->not_entrsaida==2 && $cst_ipi<50){
			$cst_ipi = "5".substr($cst_ipi, 1,1);
		}elseif($nota->not_entrsaida==1 && $cst_ipi>50){
			$cst_ipi = "0".substr($cst_ipi, 1,1);
		}
		if($cst_ipi=="09"){
			$cst_ipi = "49";
		}elseif($cst_ipi=="59"){
			$cst_ipi = "99";
		}
		
		$qtd = ($nota->itn_qtde>0) ? number_format($nota->itn_qtde, 5, ",", "") : "0,00000";
		$vl_item = ($nota->itn_valor>0) ? number_format($nota->itn_valor, 2, ",", "") : "0,00";
		$vl_desc = ($nota->itn_valordesc>0) ? number_format($nota->itn_valordesc, 2, ",", "") : "0,00";
		$vl_bc_icms = ($nota->itn_baseicms>0) ? number_format($nota->itn_baseicms, 2, ",", "") : "0,00";
		$aliq_icms = ($nota->itn_aliqicms>0) ? number_format($nota->itn_aliqicms, 2, ",", "") : "0,00";
		$vl_icms = ($nota->itn_icms>0) ? number_format($nota->itn_icms, 2, ",", "") : "0,00";
		$vl_bc_icms_st = ($nota->itn_baseicmsst>0) ? number_format($nota->itn_baseicmsst, 2, ",", "") : "0,00";
		$aliq_st = ($trib->tri_aliq_icms_st>0) ? number_format($trib->tri_aliq_icms_st, 2, ",", "")  : "0,00";
		$vl_icms_st = ($nota->itn_icmssubst>0) ? number_format($nota->itn_icmssubst, 2, ",", "")  : "0,00";
		$vl_bc_ipi = ($nota->itn_baseipi>0) ? number_format($nota->itn_baseipi, 2, ",", "")  : "0,00";
		$aliq_ipi = ($trib->tri_aliqipi>0) ? number_format($trib->tri_aliqipi, 2, ",", "") : "0,00";
		$vl_ipi = ($nota->itn_ipi>0) ? number_format($nota->itn_ipi, 2, ",", "") : "0,00";
		$vl_bc_pis = ($trib->tri_basepis>0) ? number_format($trib->tri_basepis, 2, ",", "") : "0,00";
		$aliq_pis = ($trib->tri_aliqpis>0) ? number_format($trib->tri_aliqpis, 4, ",", "") : "0,0000";
		$quant_bc_pis = ($nota->itn_qtde>0) ? number_format($nota->itn_qtde, 3, ",", "") : "0,000";
		$aliq_pis_reais = ($trib->tri_aliqpis>0) ? number_format($trib->tri_aliqpis, 4, ",", "") : "0,0000";
		$vl_pis = ($trib->tri_pis>0) ? number_format($trib->tri_pis, 2, ",", "") : "0,00";
		$vl_bc_cofins = ($trib->tri_basecofins>0) ? number_format($trib->tri_basecofins, 2, ",", "") : "0,00";
		$aliq_cofins = ($trib->tri_aliqcofins>0) ? number_format($trib->tri_aliqcofins, 4, ",", "") : "0,0000";
		$quant_bc_cofins = ($nota->itn_qtde>0) ? number_format($nota->itn_qtde, 3, ",", "") : "0,000";
		$aliq_cofins_reais = ($trib->tri_aliqcofins>0) ? number_format($trib->tri_aliqcofins, 4, ",", "") : "0,0000";
		$vl_cofins = ($trib->tri_cofins>0) ? number_format($trib->tri_cofins, 2, ",", "") : "0,00";
		
		if($cod_sit=='00'){
			
			if(!$trib->tri_sit_pis || $trib->tri_sit_pis=='' || $trib->tri_sit_pis=='0'){
				$trib->tri_sit_pis='99';
			}
			if(!$trib->tri_sit_cofins || $trib->tri_sit_cofins=='' || $trib->tri_sit_cofins=='0'){
				$trib->tri_sit_cofins='99';
			}
			
			$reg_C170 = new Registro_C170();
			$reg_C170->_set('num_item', ($nota->itn_ordem+1) )
			->_set('cod_item', (string) $nota->ref_codigo)
			->_set('descr_compl', (string) $nota->itn_descr)
			->_set('qtd', $qtd )
			->_set('unid', $nota->unidade)
			->_set('vl_item', $vl_item )
			->_set('vl_desc', $vl_desc )
			->_set('ind_mov', "0")
			->_set('cst_icms', str_pad($trib->tri_situacao, 3, "0", STR_PAD_LEFT))
			->_set('cfop', $trib->ref_cfop)
			->_set('cod_nat', '')
			->_set('vl_bc_icms', $vl_bc_icms )
			->_set('aliq_icms', $aliq_icms)
			->_set('vl_icms', $vl_icms)
			->_set('vl_bc_icms_st', $vl_bc_icms_st )
			->_set('aliq_st', $aliq_st)
			->_set('vl_icms_st', $vl_icms_st )
			->_set('ind_apur', "0")
			->_set('cst_ipi', $cst_ipi )
			->_set('cod_enq', '')
			->_set('vl_bc_ipi', $vl_bc_ipi )
			->_set('aliq_ipi', $aliq_ipi )
			->_set('vl_ipi', $vl_ipi )
			->_set('cst_pis', str_pad($trib->tri_sit_pis, 2, "0", STR_PAD_LEFT) )
			->_set('vl_bc_pis', $vl_bc_pis)
			->_set('aliq_pis', $aliq_pis )
			->_set('quant_bc_pis', $quant_bc_pis )
			->_set('aliq_pis_reais', $aliq_pis_reais )
			->_set('vl_pis', $vl_pis )
			->_set('cst_cofins', str_pad($trib->tri_sit_cofins, 2, "0", STR_PAD_LEFT) )
			->_set('vl_bc_cofins', $vl_bc_cofins )
			->_set('aliq_cofins', $aliq_cofins )
			->_set('quant_bc_cofins', $quant_bc_cofins )
			->_set('aliq_cofins_reais', $aliq_cofins_reais )
			->_set('vl_cofins', $vl_cofins )
			->_set('cod_cta', '');
			$sped->add($reg_C170);
		
			$itn_aliqicms = ($nota->itn_aliqicms>0) ? number_format($nota->itn_aliqicms, 2, ",", "") : "0,00";
			$itn_subtotal += $nota->itn_subtotal;
			$itn_subtotal = ( $itn_subtotal >0 ) ? number_format($itn_subtotal, 2, ",", "") : "0,00";
			$itn_baseicms += $nota->itn_baseicms;
			$itn_baseicms = ( $itn_baseicms >0 ) ? number_format($itn_baseicms, 2, ",", "") : "0,00";
			$itn_icms += $nota->itn_icms;
			$itn_icms = ( $itn_icms >0 ) ? number_format($itn_icms, 2, ",", "") : "0,00";
			$tot_icms += $nota->itn_icms;
			$itn_baseicmsst += $nota->itn_baseicmsst;
			$itn_baseicmsst = ( $itn_baseicmsst >0 ) ? number_format($itn_baseicmsst, 2, ",", "") : "0,00";
			$itn_icmssubst += $nota->itn_icmssubst;
			$itn_icmssubst = ( $itn_icmssubst >0 ) ? number_format($itn_icmssubst, 2, ",", "") : "0,00";
			$tri_redbaseicms += $trib->tri_redbaseicms;
			$tri_redbaseicms = ( $tri_redbaseicms >0 ) ? number_format($tri_redbaseicms, 2, ",", "") : "0,00";
			$itn_ipi += $nota->itn_ipi;
			$itn_ipi = ( $itn_ipi >0 ) ? number_format($itn_ipi, 2, ",", "") : "0,00";
			
			//C190
			if( !strstr($conjunto, $trib->ref_cfop.$trib->tri_situacao.$nota->itn_aliqicms) ){
				
				$reg_C190 = new Registro_C190();
				$reg_C190->_set('cst_icms', str_pad($trib->tri_situacao, 3, "0", STR_PAD_LEFT))
				->_set('cfop', $trib->ref_cfop)
				->_set('aliq_icms', $itn_aliqicms)
				->_set('vl_opr', $itn_subtotal)
				->_set('vl_bc_icms', $itn_baseicms)
				->_set('vl_icms', $itn_icms)
				->_set('vl_bc_icms_st', $itn_baseicmsst)
				->_set('vl_icms_st', $itn_icmssubst)
				->_set('vl_red_bc', $tri_redbaseicms)
				->_set('vl_ipi', $itn_ipi)
				->_set('cod_obs', '');
				$sped->add($reg_C190);
				
				if( isset($obs[$nota->not_codigo]) ){
					$reg_C195 = new Registro_C195();
					$reg_C195->_set('cod_obs', str_pad($obs[$nota->not_codigo][0], 6, "0", STR_PAD_LEFT))
					->_set('txt_compl', $obs[$nota->not_codigo][1].": ".$obs[$nota->not_codigo][2]);
					$sped->add($reg_C195);
				}
				
				$conjunto.= $trib->ref_cfop.$trib->tri_situacao.$nota->itn_aliqicms."|";
				$itn_subtotal=0;
				$itn_baseicms=0;
				$itn_icms=0;
				$itn_baseicmsst = 0;
				$itn_icmssubst = 0;
				$tri_redbaseicms = 0;
				$itn_ipi = 0;
				
			}
			
		}

	}

	if(in_array("Registro_C400", $data->registros)){ //EQUIPAMENTO ECF
		$reg_C400=new Registro_C400();
		$reg_C400->_set('cod_mod','')
		->_set('ecf_mod','')
		->_set('ecf_fab','')
		->_set('ecf_cx',0);
		$sped->add($reg_C400);
	}
	
	if(in_array("Registro_C405", $data->registros)){ //REDUÇÃO Z (Código 02, 2D e 60)) 
		$reg_C405=new Registro_C405();
		$reg_C405->_set('dt_doc',0)
		->_set('cro',0)
		->_set('crz',0)
		->_set('num_coo_fin',0)
		->_set('gt_fin',0)
		->_set('vl_brt',0);
		$sped->add($reg_C405);
	}
	
	if(in_array("Registro_C410", $data->registros)){ //PIS E COFINS
		$reg_C410=new Registro_C410();
		$reg_C410->_set('vl_pis',0)
		->_set('vl_cofins',0);
		$sped->add($reg_C410);
	}
	
	if(in_array("Registro_C420", $data->registros)){ //REGISTRO DOS TOTALIZADORES PARCIAIS DA REDUÇÃO Z
		$reg_C420=new Registro_C420();
		$reg_C420->_set('cod_tot_par','')
		->_set('vlr_acum_tot',0)
		->_set('nr_tot',0)
		->_set('descr_nr_tot','');
		$sped->add($reg_C420);
	}
	
	if(in_array("Registro_C450", $data->registros)){ //DOCUMENTO FISCAL EMITIDO POR ECF (Código 02, 2D e 60))
		$reg_C450=new Registro_C450();
		$reg_C450->_set('cod_inf','')
		->_set('txt',0);
		$sped->add($reg_C450);
	}
	
	if(in_array("Registro_C460", $data->registros)){ //DOCUMENTO FISCAL EMITIDO POR ECF (Código 02, 2D e 60))
		$reg_C460=new Registro_C460();
		$reg_C460->_set('cod_mod',0)
		->_set('cod_sit',0)
		->_set('num_doc',0)
		->_set('dt_doc',0)
		->_set('vl_doc',0)
		->_set('vl_pis',0)
		->_set('vl_cofins',0)
		->_set('cpf_cnpj',0)
		->_set('nom_adq',0);
		$sped->add($reg_C460);
	}
	
	if(in_array("Registro_C470", $data->registros)){ // ITENS DO DOCUMENTO FISCAL EMITIDFO POR ECF (Código 02 e 2D)) 
		$reg_C470=new Registro_C470();
		$reg_C470->_set('cod_item','')
		->_set('qtd',0)
		->_set('qtd_canc',0)
		->_set('unid','')
		->_set('vl_item',0)
		->_set('cst_icms',0)
		->_set('cfop',0)
		->_set('aliq_icms',0)
		->_set('vl_pis',0)
		->_set('vl_cofins',0);
		$sped->add($reg_C470);
	}
	
	if(in_array("Registro_C490", $data->registros)){ //REGISTRO ANALITICO DO MOVIMENTO DIARIO
		$reg_C490=new Registro_C490();
		$reg_C490->_set('cst_icms',0)
		->_set('cfop',0)
		->_set('aliq_icms',0)
		->_set('vl_opr',0)
		->_set('vl_bc_icms',0)
		->_set('vl_icms',0)
		->_set('cod_obs','');
		$sped->add($reg_C490);
	}
	
	if(in_array("Registro_C990", $data->registros)){ //ENCERRAMENTO DO BLOCO C
		$reg_C990=new Registro_C990();
		$reg_C990->_set('qtd_lin_c',$sped->countBloco('C'));
		$sped->add($reg_C990);
	}
	
	//###################################################################### ALIMENTACAO BLOCO D ################################################################################
	
	if(in_array("Registro_D001", $data->registros)){ //ABERTURA DO BLOCO D
		$reg_D001=new Registro_D001();
		$reg_D001->_set('ind_mov',1);
		$sped->add($reg_D001);
	}
	
	if(in_array("Registro_D990", $data->registros)){ //ENCERRAMENTO DO BLOCO D
		$reg_D990=new Registro_D990();
		$reg_D990->_set('qtd_lin_d',$sped->countBloco('D'));
		$sped->add($reg_D990);
	}
	
	//###################################################################### ALIMENTACAO BLOCO E ################################################################################

	// if(in_array("Registro_E001", $data->registros)){ //ABERTURA DO BLOCO E
		$reg_E001=new Registro_E001();
		$reg_E001->_set('ind_mov',0);
		$sped->add($reg_E001);
	// }
	
	// if(in_array("Registro_E100", $data->registros)){ //PERIODO DA APURACAO ICMS
		$reg_E100=new Registro_E100();
		$reg_E100->_set('dt_ini',date('dmY',strtotime($data->dtini)))
		->_set('dt_end',date('dmY',strtotime($data->dtfim)));
		$sped->add($reg_E100);
	// }

	// if(in_array("Registro_E110", $data->registros)){ //APURACAO ICMS OPERACOES PROPRIAS
/*
		$reg_E110=new Registro_E110();
		$reg_E110->_set('vl_tot_debitos',$tot_icms)
		->_set('vl_aj_debitos',0)
		->_set('vl_tot_aj_debitos',0)
		->_set('vl_estornos_cred',0)
		->_set('vl_tot_creditos',0)
		->_set('vl_aj_creditos',0)
		->_set('vl_tot_aj_creditos',0)
		->_set('vl_estornos_deb',0)
		->_set('vl_sld_credor_ant',0)
		->_set('vl_sld_apurado', $tot_icms)
		->_set('vl_tot_ded',0)
		->_set('vl_icms_recolher', )
		->_set('vl_sld_credor_transportar',0)
		->_set('deb_esp',0);
		$sped->add($reg_E110);
		*/

	// }
	/*
		$reg_E200=new Registro_E200();
		$reg_E200->_set('uf',$company->emp_uf)
		->_set('dt_ini',date('dmY',strtotime($data->dtini)))
		->_set('dt_fin',date('dmY',strtotime($data->dtfim)));
		$sped->add($reg_E200);
		
		$reg_E210=new Registro_E210();
		$reg_E210->_set('ind_mov_st',0)
		->_set('vl_sld_cred_ant_st',0)
		->_set('vl_devol_st',0)
		->_set('vl_ressarc_st',0)
		->_set('vl_out_cred_st',0)
		->_set('vl_aj_creditos_st',0)
		->_set('vl_retencao_st',0)
		->_set('vl_out_deb_st',0)
		->_set('vl_aj_debitos_st',0)
		->_set('vl_sld_dev_ant_st',0)
		->_set('vl_deducoes_st',0)
		->_set('vl_icms_recol_st',0)
		->_set('vl_sld_cred_st_transportar',0)
		->_set('deb_esp_st',0);
		$sped->add($reg_E200);
	*/
	// if(in_array("Registro_E990", $data->registros)){ //ENCERRAMENTO DO BLOCO E
		$reg_E990=new Registro_E990();
		$reg_E990->_set('qtd_lin_d',$sped->countBloco('E'));
		$sped->add($reg_E990);
	// }

	############################################################## ALIMENTACAO BLOCO G ################################################################################
	
	// if(in_array("Registro_G001", $data->registros)){ //ABERTURA DO BLOCO G
		$reg_G001=new Registro_G001();
		$reg_G001->_set('ind_mov',1);
		$sped->add($reg_G001);
	// }
	
	// if(in_array("Registro_G990", $data->registros)){ //ENCERRAMENTO DO BLOCO G
		$reg_G990=new Registro_G990();
		$reg_G990->_set('qtd_lin_g',$sped->countBloco('G'));
		$sped->add($reg_G990);
	// }
	
	############################################################## ALIMENTACAO BLOCO H ################################################################################
	
	// if(in_array("Registro_H001", $data->registros)){ //ABERTURA DO BLOCO H
		$reg_H001=new Registro_H001();
		$reg_H001->_set('ind_mov',1);
		$sped->add($reg_H001);
	// }
	
	// if(in_array("Registro_H990", $data->registros)){ //ENCERRAMENTO DO BLOCO H
		$reg_H990=new Registro_H990();
		$reg_H990->_set('qtd_lin_h',$sped->countBloco('H'));
		$sped->add($reg_H990);
	// }
	
	############################################################## ALIMENTACAO BLOCO K ################################################################################
	
	$filtro = '{"cod":"700075","params":[
		{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"},
		{"name":"data_ini","value":"'.$data->dtini.'","type":"string"},
		{"name":"data_fim","value":"'.$data->dtfim.'","type":"string"}
	]}';
	
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	$datapacket->add($filtro);
	$estoque = $datapacket->open(true);
	$datapacket->clear();
	$ant="";
	
	// if(in_array("Registro_K001", $data->registros)){ //ABERTURA DO BLOCO K
		$reg_K001=new Registro_K001();
		$reg_K001->_set('ind_mov',0);
		// $reg_K001->_set('ind_mov',1);
		$sped->add($reg_K001);
	// }
	
	// if(in_array("Registro_K100", $data->registros)){
		$reg_K100=new Registro_K100();
		$reg_K100->_set('dt_ini',date('dmY', strtotime($data->dtini)))->_set('dt_fin', date('dmY', strtotime($data->dtfim)));
		$sped->add($reg_K100);
	// }
	
	// if(in_array("Registro_K200", $data->registros)){
		$inventario = 0;
		if( is_array($estoque) ){
			foreach($estoque as $est){
				
				if($ant!=$est->ref_codigo && $est->stk_total>0){
					$reg_K200=new Registro_K200();
					$reg_K200->_set('dt_est', date('dmY', strtotime($data->dtfim)))
					->_set('cod_item', $est->ref_codigo)
					->_set('qtd', number_format($est->stk_total, 3, ',', ''))
					->_set('ind_est', 0)
					->_set('cod_part', '');
					$sped->add($reg_K200);
					
					$ant = $est->ref_codigo;
				}
				/*
				if($inventario>0){
					$diff = $inventario - $est->stk_total;
					if($diff>=0){
						$pos = ($pos!=0) ? number_format($diff, 3, ',', '') : 0;
						$neg=0;
					}else{
						$diff = $diff * (-1);
						$neg = number_format($diff, 3, ',', '');
						$pos=0;
					}
					$reg_K280=new Registro_K280();
					$reg_K280->_set('dt_est', date('dmY', strtotime($est->stk_data)))
					->_set('cod_item', $est->ref_codigo)
					->_set('qtd_cor_pos', $pos)
					->_set('qtd_cor_neg', $neg)
					->_set('ind_est', 0)
					->_set('cod_part', '');
					$sped->add($reg_K280);
					$inventario=0;
				}
				if($est->stk_tipo==4){ //inventario
					$inventario = $est->stk_total;
				}
				*/
			}
		}
	// }
	
	// if(in_array("Registro_K990", $data->registros)){ //ENCERRAMENTO DO BLOCO K
		$reg_K990=new Registro_K990();
		$reg_K990->_set('qtd_lin_h',$sped->countBloco('K'));
		$sped->add($reg_K990);
	// }
	
	//###################################################################### ALIMENTACAO BLOCO 1 ################################################################################
	
	// if(in_array("Registro_1001", $data->registros)){ //ABERTURA DO BLOCO 1
		$reg_1001=new Registro_1001();
		$reg_1001->_set('ind_mov',0);
		$sped->add($reg_1001);
	// }
		
	// if(in_array("Registro_1010", $data->registros)){ //OBRIGATORIEDADE DOS REGISTROS DO BLOCO 1
		$reg_1010=new Registro_1010();
		$reg_1010->_set('ind_exp','N')
		->_set('ind_ccrf','N')
		->_set('ind_comb','N')
		->_set('ind_usina','N')
		->_set('ind_va','N')
		->_set('ind_ee','N')
		->_set('ind_cart','N')
		->_set('ind_form','N')
		->_set('ind_aer','N');
		$sped->add($reg_1010);
	// }
	
	// if(in_array("Registro_1990", $data->registros)){ //ENCERRAMENTO DO BLOCO 1
		$reg_1990=new Registro_1990();
		$reg_1990->_set('qtd_lin_1',$sped->countBloco('1'));
		$sped->add($reg_1990);
	// }
	
	$sped->close();
	
?>