<?php 
/**
* REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA PESSOA JURÍDICA
* Observações: Registro obrigatório, correspondente ao primeiro registro do arquivo da escrituração.
* Nível hierárquico - 0
* Ocorrência - um (por arquivo)
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0000 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0000”.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0000';
	
	/**
	* Código da versão do leiaute conforme a tabela 3.1.1.
	* @name $cod_ver
	* @size 3
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cod_ver;
	
	/**
	* Tipo de escrituração:
	*	0 - Original;
	*	1 – Retificadora.
	* @name $tipo_escrit
	* @size 1
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $tipo_escrit;
	
	/**
	* Indicador de situação especial:
	*	0 - Abertura
	*	1 - Cisão
	*	2 - Fusão
	*	3 - Incorporação
	*	4 – Encerramento
	* @name $ind_sit_esp
	* @size 1
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $ind_sit_esp;

	/**
	* Número do Recibo da Escrituração anterior a ser retificada, utilizado quando TIPO_ESCRIT for igual a 1
	* @name $num_rec_anterior
	* @size 41
	* @type string	
	* @position 05
	* @required true
	*/
	protected $num_rec_anterior;

	/**
	* Data inicial das informações contidas no arquivo.
	* @name $dt_ini
	* @size 8
	* @type numeric
	* @format ddmmaaaa
	* @position 06
	* @required true	
	*/
	protected $dt_ini;

	/**
	* Data final das informações contidas no arquivo.
	* @name $dt_fin
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 07
	* @required true
	*/
	protected $dt_fin;

	/**
	* Nome empresarial da pessoa jurídica.
	* @name $nome
	* @size 100
	* @type string	
	* @position 08
	* @required true
	*/
	protected $nome;

	/**
	* Número de inscrição do estabelecimento matriz da pessoa jurídica no CNPJ.
	* @name $cnpj
	* @size 14
	* @type numeric	
	* @position 09
	* @required true
	*/
	protected $cnpj;

	/**
	* Sigla da Unidade da Federação da pessoa jurídica.
	* @name $uf
	* @size 2
	* @type string	
	* @position 10
	* @required true
	*/
	protected $uf;
	
	/**
	* Código do município do domicílio fiscal da entidade, conforme a tabela IBGE
	* @name $cod_mun
	* @size 7
	* @type numeric	
	* @position 11
	* @required true
	*/
	protected $cod_mun;

	/**
	* Inscrição da pessoa jurídica na Suframa.
	* @name $suframa
	* @size 9
	* @type string	
	* @position 12
	* @required false
	*/
	protected $suframa;

	/**
	* Indicador da natureza da pessoa jurídica:
	* 	00 – Sociedade empresária em geral
	* 	01 – Sociedade cooperativa
	* 	02 – Entidade sujeita ao PIS/Pasep exclusivamente com base na Folha de Salários
	* @name $ind_nat_pj
	* @size 2
	* @type numeric
	* @position 13
	* @required false
	*/
	protected $ind_nat_pj;

	/**
	* Indicador de tipo de atividade preponderante:
	* 	0 – Industrial ou equiparado a industrial;
	* 	1 – Prestador de serviços;
	* 	2 - Atividade de comércio;
	* 	3 – Atividade financeira;
	* 	4 – Atividade imobiliária;
	* 	9 – Outros.
	* @name $ind_ativ
	* @size 1
	* @type string
	* @position 14
	* @required true
	*/
	protected $ind_ativ;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>