<?php 
/**
* REGISTRO 0100: DADOS DO CONTABILISTA
* Nível hierárquico - 2
* Ocorrência – um por arquivo
* Observações:
* 	1. Registro obrigatório, utilizado para identificação do contabilista responsável pela escrituração fiscal da empresa, mesmo que o contabilista seja funcionário da empresa ou prestador de serviço.
* 	2. Apesar das contribuições sociais serem apuradas de forma centralizada pelo estabelecimento matriz,  as informações dos Blocos A, C, D e F são escrituradas por estabelecimento. 
* Neste sentido, caso a pessoa jurídica tenha mais de um contabilista responsável pela escrituração fiscal de suas operações, estes devem ser relacionados no registro 0100.
* Nível hierárquico – 2
* Ocorrência - Vários (por arquivo)
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0100 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0100”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0100';
	
	/**
	* Nome do contabilista.
	* @name $nome
	* @size 100
	* @type string	
	* @position 02
	* @required true
	*/
	protected $nome;
	
	/**
	* Número de inscrição do contabilista no CPF.
	* @name $cpf
	* @size 11
	* @type numeric
	* @position 03
	* @required true	
	*/
	protected $cpf;
	
	/**
	*
	* Número de inscrição do contabilista no Conselho Regional de Contabilidade.
	* $name $crc
	* @size 15
	* @type string
	* @position 04
	* @required true
	*/
	protected $crc;


	/**
	* Número de inscrição do escritório de contabilidade no CNPJ, se houver.
	* $name $cnpj
	* @size 14
	* @type numeric
	* @position 05
	* @required true
	*/
	protected $cnpj;

	/**
	* Código de Endereçamento Postal.
	* @name $cep
	* @size 8
	* @type numeric	
	* @position 06
	* @required false	
	*/
	protected $cep;

	/**
	* Logradouro e endereço do imóvel.
	* @name $end
	* @size 60
	* @type string	
	* @position 07
	* @required false
	*/
	protected $end;

	/**
	* Número do imóvel.
	* @name $num
	* @size undefined
	* @type string	
	* @position 08
	* @required false
	*/
	protected $num;

	/**
	* Dados complementares do endereço.
	* @name $compl
	* @size 60
	* @type string	
	* @position 09
	* @required false
	*/
	protected $compl;

	/**
	* Bairro em que o imóvel está situado.
	* @name $bairro
	* @size 60
	* @type string	
	* @position 10
	* @required false
	*/
	protected $bairro;

	/**
	* Número do telefone (DDD+FONE).
	* @name $fone
	* @size 10
	* @type string	
	* @position 11
	* @required false
	*/
	protected $fone;

	/**
	* Número do fax.
	* @name $fax
	* @size 10
	* @type string	
	* @position 12
	* @required false
	*/
	protected $fax;

	/**
	* Endereço do correio eletrônico.
	* @name $email
	* @size undefined
	* @type string	
	* @position 13
	* @required false
	*/
	protected $email;

	/**
	* Código do município, conforme tabela IBGE.
	* @name $cod_mun
	* @size 7
	* @type numeric
	* @position 14
	* @required false
	*/
	protected $cod_mun;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>