<?php 
/**
* REGISTRO 0110: REGIMES DE APURAÇÃO DA CONTRIBUIÇÃO SOCIAL E DE APROPRIAÇÃO DE CRÉDITO
* Este registro tem por objetivo definir o regime de incidência a que se submete a pessoa jurídica (não-cumulativo,
* cumulativo ou ambos os regimes) no período da escrituração. No caso de sujeição ao regime não-cumulativo, será
* informado também o método de apropriação do crédito incidente sobre operações comuns a mais de um tipo de receita adotado pela pessoa jurídica para o ano-calendário.
* Observações: Registro obrigatório. Informar somente os regimes de apuração a que se submeteu a pessoa jurídica no período da escrituração.
* Nível hierárquico - 2
* Ocorrência – um (por arquivo)
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0110 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0110”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0110';
	
	/**
	* Código indicador da incidência tributária no período:
	* 	1 – Escrituração de operações com incidência exclusivamente no regime não-cumulativo;
	* 	2 – Escrituração de operações com incidência exclusivamente no regime cumulativo;
	* 	3 – Escrituração de operações com incidência nos regimes não-cumulativo e cumulativo.	
	* @name $cod_inc_trib
	* @size 1
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cod_inc_trib;
	
	/**
	* Código indicador de método de apropriação de créditos comuns, no caso de incidência no regime nãocumulativo (COD_INC_TRIB = 1 ou 3):
	* 	1 – Método de Apropriação Direta;
	* 	2 – Método de Rateio Proporcional (Receita Bruta)
	* @name $ind_apro_cred
	* @size 1
	* @type numeric
	* @position 03
	* @required false	
	*/
	protected $ind_apro_cred;
	
	/**
	* Código indicador do Tipo de Contribuição Apurada no Período
	* 1 – Apuração da Contribuição Exclusivamente a Alíquota Básica
	* 2 – Apuração da Contribuição a Alíquotas Específicas (Diferenciadas e/ou por Unidade de Medida de Produto)
	* $name $cod_tipo_cont
	* @size 1
	* @type numeric
	* @position 04
	* @required false
	*/
	protected $cod_tipo_cont;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>