<?php 
/**
* REGISTRO 0150: TABELA DE CADASTRO DO PARTICIPANTE
* Este registro tem por objetivo relacionar e cadastrar os participantes (fornecedores e clientes pessoa jurídica ou pessoa física) que tenham realizado operações com a empresa, objeto de registro nos Blocos A, C, D, F ou 1.
* Em relação às operações documentadas com base em Nota Fiscal Eletrônica (Código 55), no caso da pessoa jurídica
* proceder à escrituração consolidada de suas vendas (Registro C180) e/ou de suas aquisições (Registro C190), não é
* obrigatório cadastrar e relacionar no Registro 0150 o participante cujas operações estejam exclusivamente escrituradas nos registros C180 e C190.
* Em relação às operações documentadas com base em Nota Fiscal Eletrônica (Código 55), no caso da pessoa jurídica proceder à escrituração de forma individualizada por documento fiscal (Registros C100/C170) de suas vendas e/ou de suas aquisições, é obrigatório cadastrar e relacionar no Registro 0150 cada participante cujas operações estejam escrituradas nos registros C100 e C170.
* Observações:
* 	1. Registro utilizado para informações cadastrais das pessoas físicas ou jurídicas envolvidas nas transações comerciais e de prestação/contratação de serviços relacionadas na escrituração fiscal digital, no período.
* 	2. Todos os participantes informados nos registros dos Blocos A, C, D ou F devem ser relacionados neste Registro 0150, bem como os participantes relacionados em operações extemporâneas (de contribuições e/ou créditos) no Bloco 1.
* 	3. No caso de registros representativos de operações de vendas a consumidor final (Nota Fiscal de Vendas a Consumidor Final), inclusive os emitidos por ECF, não precisam ser informados os campos CNPJ e CPF;
* 	4. O Campo CPF não precisa ser informado, nas operações representativas de vendas de bens e serviços a pessoas físicas estrangeiras.
* Nível hierárquico - 3
* Ocorrência – 1:N
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0150 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 0150.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0150';
	
	/**
	* Código de identificação do participante no arquivo.
	* @name $cod_part
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_part;
	
	/**
	* Nome pessoal ou empresarial do participante.
	* @name $nome
	* @size 100
	* @type string
	* @position 03
	* @required true	
	*/
	protected $nome;
	
	/**
	* Código do país do participante, conforme a tabela indicada no item 3.2.1.
	* @name $cod_pais
	* @size 5
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $cod_pais;

	/**
	* CNPJ do participante.
	* @name $cnpj
	* @size 14
	* @type numeric	
	* @position 05
	* @required false
	*/
	protected $cnpj;

	/**
	* CPF do participante.
	* @name $cpf
	* @size 11
	* @type numeric
	* @position 06
	* @required false	
	*/
	protected $cpf;

	/**
	* Inscrição Estadual do participante.
	* @name $ie
	* @size 14
	* @type string
	* @position 07
	* @required false
	*/
	protected $ie;

	/**
	* Código do município, conforme a tabela IBGE
	* @name $cod_mun
	* @size 7
	* @type numeric	
	* @position 08
	* @required false
	*/
	protected $cod_mun;

	/**
	* NNúmero de inscrição do participante na Suframa
	* @name $suframa
	* @size 9
	* @type string	
	* @position 09
	* @required false
	*/
	protected $suframa;

	/**
	* Logradouro e endereço do imóvel.
	* @name $end
	* @size 60
	* @type string	
	* @position 10
	* @required false
	*/
	protected $end;
	
	/**
	* Número do imóvel
	* @name $num
	* @size undefined
	* @type string
	* @position 11
	* @required false
	*/
	protected $num;

	/**
	* Dados complementares do endereço.
	* @name $compl
	* @size 60
	* @type string	
	* @position 12
	* @required false
	*/
	protected $compl;

	/**
	* Bairro em que o imóvel está situado.
	* @name $bairro
	* @size 60
	* @type string
	* @position 13
	* @required false
	*/
	protected $bairro;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>