<?php 
/**
* REGISTRO 0200: TABELA DE IDENTIFICAÇÃO DO ITEM (PRODUTOS E SERVIÇOS)
* Este registro tem por objetivo informar as mercadorias, serviços, produtos ou quaisquer outros itens concernentes às transações representativas de receitas e/ou geradoras de créditos, objeto de escrituração nos Blocos A, C, D, F ou 1.
* Observações:
* Nível hierárquico - 3
* Ocorrência – 1:N
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0200 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 0200.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0200';
	
	/**
	* Código do item.
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Descrição do item.
	* @name $descr_item
	* @size undefined
	* @type string
	* @position 03
	* @required true	
	*/
	protected $descr_item;
	
	/**
	* Representação alfanumérico do código de barra do produto, se houver.
	* @name $cod_barra
	* @size undefined
	* @type string
	* @position 04
	* @required false
	*/
	protected $cod_barra;

	/**
	* Código anterior do item com relação à última informação apresentada.
	* @name $cod_ant_item
	* @size 60
	* @type string	
	* @position 05
	* @required false
	*/
	protected $cod_ant_item;

	/**
	* Unidade de medida utilizada na quantificação de estoques.
	* @name $unid_inv
	* @size 6
	* @type string
	* @position 06
	* @required false	
	*/
	protected $unid_inv;

	/**
	* Tipo do item – Atividades Industriais, Comerciais e Serviços:
	* 	00 – Mercadoria para Revenda;
	* 	01 – Matéria-Prima;
	* 	02 – Embalagem;
	* 	03 – Produto em Processo;
	* 	04 – Produto Acabado;
	* 	05 – Subproduto;
	* 	06 – Produto Intermediário;
	* 	07 – Material de Uso e Consumo;
	* 	08 – Ativo Imobilizado;
	* 	09 – Serviços;
	* 	10 – Outros insumos;
	* 	99 – Outras
	* @name $tipo_item
	* @size 2
	* @type numeric
	* @position 07
	* @required true
	*/
	protected $tipo_item;

	/**
	* Código da Nomenclatura Comum do Mercosul
	* @name $cod_ncm
	* @size 8
	* @type string	
	* @position 08
	* @required false
	*/
	protected $cod_ncm;

	/**
	* Código EX, conforme a TIPI
	* @name $ex_ipi
	* @size 3
	* @type string	
	* @position 09
	* @required false
	*/
	protected $ex_ipi;

	/**
	* Código do gênero do item, conforme a Tabela 4.2.1.
	* @name $cod_gen
	* @size 2
	* @type numeric
	* @position 10
	* @required false
	*/
	protected $cod_gen;
	
	/**
	* Código do serviço conforme lista do Anexo I da Lei Complementar Federal nº 116/03
	* @name $cod_lst
	* @size 4
	* @type numeric
	* @position 11
	* @required false
	*/
	protected $cod_lst;

	/**
	* Alíquota de ICMS aplicável ao item nas operações internas
	* @name $aliq_icms
	* @size 6
	* @type decimal 2 casas decimais	
	* @position 12
	* @required false
	*/
	protected $aliq_icms;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>