<?php 
/**
* REGISTRO A010: IDENTIFICAÇÃO DO ESTABELECIMENTO
* Este registro tem o objetivo de identificar o estabelecimento da pessoa jurídica a que se referem as operações e
* documentos fiscais informados neste bloco. Só devem ser escriturados no Registro A010 os estabelecimentos que
* efetivamente tenham realizado operações de prestação ou de contratação de serviços, mediante emissão de documento fiscal, que devam ser escrituradas no Bloco A.
* O estabelecimento que não realizou operações passíveis de registro nesse bloco, no período da escrituração, não deve ser identificado no Registro A010.
* Para cada estabelecimento cadastrado em “A010”, deve ser informado nos registros de nível inferior (Registros Filho) as operações próprias
* Observações: Registro obrigatório (se IND_MOV igual a 0, em A001)
* Nível hierárquico - 2
* Ocorrência - vários (por arquivo)
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_A010 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo A010.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='A010';
	
	/**
	* Número de inscrição do estabelecimento no CNPJ.
	* @name $cnpj
	* @size 14
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cnpj;
	

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>