<?php 
/**
* REGISTRO A100: DOCUMENTO - NOTA FISCAL DE SERVIÇO
* Deve ser gerado um Registro A100 para cada documento fiscal a ser relacionado na escrituração, referente à prestação ou
* à contratação de serviços, que envolvam a emissão de documentos fiscais estabelecidos pelos Municípios, eletrônicos ou em papel.
* Para cada registro A100, obrigatoriamente deve ser apresentado, pelo menos, um registro A170.
* Não podem ser informados, para um mesmo documento fiscal, dois ou mais registros com a mesma combinação de valores dos campos formadores da chave do registro.
* A chave deste registro é:
* - para documentos com campo IND_EMIT igual a “1” (um) – emissão por terceiros: campo IND_OPER, campo IND_EMIT, campo COD_PART, campo COD_SIT, campo SER e campo NUM_DOC;
* - para documentos com campo (IND_EMIT igual “0” (zero) – emissão própria: campo IND_OPER, campo IND_EMIT, campo COD_SIT, campo SER e campo NUM_DOC.
* Observações:
* 	1. Devem ser informadas no Registro A100 as operações de serviços, prestados ou contratados, cujo documento fiscal não seja objeto de escrituração nos Blocos C, D e F.
*	 2. O detalhamento das informações dos itens da Nota Fiscal de Serviço que repercute na apuração das contribuições sociais (serviços prestados) e dos créditos (serviços contratados) deve ser informado, em relação a cada item relacionado  no documento, no registro Filho “A170”.
*	 3. Caso a pessoa jurídica tenha contratado serviços à pessoa física ou jurídica domiciliada no exterior, com direito a crédito nas formas previstas na Lei nº 10.865, de 2004, deve preencher o Registro “A120” para validar a apuração do
* crédito.
* 	4. Caso a pessoa jurídica tenha realizado operações de prestação de serviço ou de contratação de serviços com direito a crédito, sem a emissão de Nota Fiscal de Serviço especifica ou documento internacional equivalente (no caso de serviços
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_A010 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo A100.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='A100';
	
	/**
	* Código da versão do leiaute conforme a tabela 3.1.1.
	* Indicador do tipo de operação:
	* 	0 - Serviço Contratado pelo Estabelecimento;
	* 	1 - Serviço Prestado pelo Estabelecimento.	
	* @name $ind_oper
	* @size 1
	* @type string	
	* @position 02
	* @required true
	*/
	protected $ind_oper;
	
	/**
	* Indicador do emitente do documento fiscal:
	* 	0 - Emissão própria;
	* 	1 - Emissão de Terceiros
	* @name $ind_emit
	* @size 1
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $ind_emit;
	
	/**
	* Código do participante (campo 02 do Registro 0150):
	* 	- do emitente do documento, no caso de emissão de terceiros;
	* 	- do adquirente, no caso de serviços prestados.
	* @name $cod_part
	* @size 60
	* @type string
	* @position 04
	* @required true
	*/
	protected $cod_part;

	/**
	* Série do documento fiscal
	* @name $cod_sit
	* @size 2
	* @type numeric	
	* @position 05
	* @required true
	*/
	protected $cod_sit;

	/**
	* Série do documento fiscal
	* @name $ser
	* @size 20
	* @type string
	* @position 06
	* @required false	
	*/
	protected $ser;

	/**
	* Subsérie do documento fiscal
	* @name $sub
	* @size 20
	* @type string	
	* @position 07
	* @required false
	*/
	protected $dt_fin;

	/**
	* Número do documento fiscal ou documento internacional equivalente
	* @name $num_doc
	* @size 60
	* @type string	
	* @position 08
	* @required true
	*/
	protected $num_doc;

	/**
	* Chave/Código de Verificação da nota fiscal de serviço eletrônica
	* @name $chv_nfse
	* @size 60
	* @type string	
	* @position 09
	* @required false
	*/
	protected $chv_nfse;

	/**
	* Data da emissão do documento fiscal
	* @name $dt_doc
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 10
	* @required true
	*/
	protected $dt_doc;
	
	/**
	* Data de Execução / Conclusão do Serviço
	* @name $dt_exe_serv
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 11
	* @required false
	*/
	protected $dt_exe_serv;

	/**
	* Valor total do documento.
	* @name $vl_doc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required true
	*/
	protected $vl_doc;

	/**
	* Indicador do tipo de pagamento:
	* 	0- À vista;
	* 	1- A prazo;
	* 	9- Sem pagamento.
	* @name $ind_pgto
	* @size 1
	* @type string
	* @position 13
	* @required true
	*/
	protected $ind_pgto;

	/**
	* Valor total do desconto
	* @name $vl_desc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required false
	*/
	protected $vl_desc;
	
	/**
	* Valor da base de cálculo do PIS/PASEP
	* @name $vl_bc_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required true
	*/
	protected $vl_bc_pis;
	/**
	* Valor total do PIS
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required true
	*/
	protected $vl_pis;
	/**
	* Valor da base de cálculo da COFINS
	* @name $vl_bc_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 17
	* @required true
	*/
	protected $vl_bc_cofins;
	
	/**
	* Valor total da COFINS
	* @name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 18
	* @required true
	*/
	protected $vl_cofins;
	
	/**
	* Valor total do PIS retido na fonte
	* @name $vl_pis_ret
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 19
	* @required false
	*/
	protected $vl_pis_ret;
	
	/**
	* Valor total da COFINS retido na fonte.
	* @name $vl_cofins_ret
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 20
	* @required false
	*/
	protected $vl_cofins_ret;

	/**
	* Valor do ISS
	* @name $vl_iss
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 21
	* @required false
	*/
	protected $vl_iss;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>