<?php 
/**
* REGISTRO A170: COMPLEMENTO DO DOCUMENTO - ITENS DO DOCUMENTO
* Registro obrigatório para discriminar os itens da nota fiscal de serviço emitida pela pessoa jurídica ou por terceiros.
* Não podem ser informados para um mesmo documento fiscal, dois ou mais registros com o mesmo conteúdo no campo NUM_ITEM.
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_A170 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo A170.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='A170';
	
	/**
	* Número seqüencial do item no documento fiscal
	* @name $num_item
	* @size 3
	* @type numeric
	* @position 02
	* @required true
	*/
	protected $num_item;
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $cod_item;
	
	/**
	* Descrição complementar do item como adotado no documento fiscal.
	* @name $descr_compl
	* @size undefined
	* @type string
	* @position 04
	* @required false
	*/
	protected $descr_compl;

	/**
	* Valor total do item (mercadorias ou serviços)
	* @name $vl_item
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 05
	* @required true
	*/
	protected $vl_item;

	/**
	* Valor do desconto do item / Exclusão
	* @name $vl_desc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required false	
	*/
	protected $vl_desc;

	/**
	* Código da Base de Cálculo do Crédito, conforme a Tabela indicada no item 4.3.7, caso seja informado código representativo de crédito no Campo 09 (CST_PIS) ou no Campo 13 (CST_COFINS).
	* @name $nat_bc_cred
	* @size 2
	* @type string	
	* @position 07
	* @required false
	*/
	protected $nat_bc_cred;

	/**
	* Indicador da origem do crédito:
	* 	0 – Operação no Mercado Interno
	* 	1 – Operação de Importação
	* @name $ind_orig_cred
	* @size 1
	* @type string	
	* @position 08
	* @required false
	*/
	protected $ind_orig_cred;

	/**
	* Código da Situação Tributária referente ao PIS/PASEP – Tabela 4.3.3.
	* @name $cst_pis
	* @size 2
	* @type nuemric	
	* @position 09
	* @required true
	*/
	protected $cst_pis;

	/**
	* Valor da base de cálculo do PIS/PASEP.
	* @name $vl_bc_pis
	* @size undefined
	* @type decimal 2 casas decimais	
	* @position 10
	* @required false
	*/
	protected $vl_bc_pis;
	
	/**
	* Alíquota do PIS/PASEP (em percentual)
	* @name $aliq_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 11
	* @required false
	*/
	protected $aliq_pis;

	/**
	* Valor do PIS/PASEP
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required false
	*/
	protected $vl_pis;

	/**
	* Código da Situação Tributária referente ao COFINS –Tabela 4.3.4.
	* @name $cst_cofins
	* @size 2
	* @type string
	* @position 13
	* @required true
	*/
	protected $cst_cofins;

	/**
	* Valor da base de cálculo da COFINS
	* @name $vl_bc_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required false
	*/
	protected $vl_bc_cofins;
	
	/**
	* Alíquota do COFINS (em percentual)
	* @name $aliq_cofins
	* @size 6
	* @type decimal 2 casas decimais
	* @position 15
	* @required false
	*/
	protected $aliq_cofins;
	
	/**
	* Valor da COFINS
	* @name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required false
	*/
	protected $vl_cofins;
	
	/**
	* Valor da base de cálculo da COFINS
	* @name $cod_cta
	* @size 60
	* @type string
	* @position 17
	* @required false
	*/
	protected $cod_cta;
	
	/**
	* Código do centro de custos
	* @name $cod_ccus
	* @size 60
	* @type string
	* @position 18
	* @required false
	*/
	protected $cod_ccus;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>