<?php 
/**
* REGISTRO C100: DOCUMENTO - NOTA FISCAL (CÓDIGO 01), NOTA FISCAL AVULSA (CÓDIGO 1B), NOTA FISCAL DE PRODUTOR (CÓDIGO 04) e NF-e (CÓDIGO 55)
*
*
*
* Registro com estrutura, campos e conteúdo definidos e constantes no Leiaute da Escrituração Fiscal Digital – EFD (ICMS e IPI), instituído pelo Ato COTEPE/ICMS nº 9, de 12 de abril de 2008, disponível no portal de serviços (SPED) da
* página da Secretaria da Receita Federal do Brasil na Internet, no endereço <www.receita.fazenda.gov.br/sped>.
* Este registro deve ser gerado para cada documento fiscal código 01, 1B, 04 e 55, registrando a entrada ou saída de produtos ou outras situações que envolvam a emissão dos documentos fiscais mencionados, representativos de receitas
* auferidas, tributadas ou não pelo PIS/Pasep ou pela Cofins, bem como de operações de aquisições e/ou devoluções com direito a crédito da não cumulatividade.
* Não devem ser informados documentos fiscais que não se refiram a operações geradoras de receitas ou de créditos de PIS/Pasep e de Cofins.
* Para cada registro C100, obrigatoriamente deve ser apresentado, pelo menos, um registro C170, exceto em relação aos
* documentos fiscais referentes à nota fiscal cancelada (código “02”), Nota Fiscal Eletrônica (NF-e) denegada (código
* “04”) ou numeração inutilizada (código “05”), os quais não devem ser escriturados os registros filhos de C100.
* Não podem ser informados, para um mesmo documento fiscal, dois ou mais registros com a mesma combinação de valores dos campos formadores da chave do registro. A chave deste registro é:
* 	- para documentos com campo “IND_EMIT” igual a “1” (um) – emissão por terceiros: campo IND_OPER, campo  IND_EMIT, campo COD_PART, campo COD_MOD, campo COD_SIT, campo SER e campo NUM_DOC;
* 	- para documentos com campo “IND_EMIT” igual “0” (zero) – emissão própria: campo IND_OPER, campo IND_EMIT, campo COD_MOD, campo COD_SIT, campo SER e campo NUM_DOC.
*
*
*
* Observações:
* 	1. Tendo em vista que as operações de vendas e de aquisições e/ou devoluções, documentadas por Nota Fiscal Eletrônica – NF-e (código 55), serem escrituradas de forma consolidada nos registros C180 (vendas) e C190 (compras e/ou devoluções) da EFD-PIS/Cofins, o registro C100 (e filhos) não é de preenchimento obrigatório na EFD-PIS/Cofins em relação às referidas operações com NF-e (código 55) ;
* 	2. Todavia, a EFD-PIS/Cofins permite a escrituração alternativa, por opção da pessoa jurídica, das operações de vendas, compras e/ou devoluções por Nota Fiscal Eletrônica – NF-e, com base nos registros C100, C110, C120 e C170. Neste
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C100 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C100.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C100';
	
	/**
	* Indicador do tipo de operação:
	* 	0- Entrada;
	* 	1- Saída	
	* @name $ind_oper
	* @size 1
	* @type string	
	* @position 02
	* @required true
	*/
	protected $ind_oper;
	
	/**
	* Indicador do emitente do documento fiscal:
	* 	0 - Emissão própria;
	* 	1 - Emissão de Terceiros
	* @name $ind_emit
	* @size 1
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $ind_emit;
	
	/**
	* Código do participante (campo 02 do Registro 0150):
	* - do emitente do documento ou do remetente das  mercadorias, no caso de entradas;
	* - do adquirente, no caso de saídas
	* @name $cod_part
	* @size 60
	* @type string
	* @position 04
	* @required true
	*/
	protected $cod_part;

	/**
	* Código do modelo do documento fiscal, conforme a Tabela 4.1.1
	* @name $cod_mod
	* @size 2
	* @type string	
	* @position 05
	* @required true
	*/
	protected $cod_mod;

	/**
	* Código da situação do documento fiscal, conforme a Tabela 4.1.2
	* @name $cod_sit
	* @size 2
	* @type numeric
	* @position 06
	* @required true	
	*/
	protected $cod_sit;

	/**
	* Série do documento fiscal
	* @name $ser
	* @size 3
	* @type string	
	* @position 07
	* @required false
	*/
	protected $ser;

	/**
	* Número do documento fiscal
	* @name $num_doc
	* @size 9
	* @type numeric	
	* @position 08
	* @required true
	*/
	protected $num_doc;

	/**
	* Chave da Nota Fiscal Eletrônica
	* @name $chv_nfe
	* @size 44
	* @type numeric	
	* @position 09
	* @required false
	*/
	protected $chv_nfe;

	/**
	* Data da emissão do documento fiscal
	* @name $dt_doc
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 10
	* @required true
	*/
	protected $dt_doc;
	
	/**
	* Data da entrada ou da saída
	* @name $dt_e_s
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 11
	* @required false
	*/
	protected $dt_e_s;

	/**
	* Valor total do documento.
	* @name $vl_doc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required true
	*/
	protected $vl_doc;

	/**
	* Indicador do tipo de pagamento:
	* 	0- À vista;
	* 	1- A prazo;
	* 	9- Sem pagamento.
	* @name $ind_pgto
	* @size 1
	* @type string
	* @position 13
	* @required true
	*/
	protected $ind_pgto;

	/**
	* Valor total do desconto
	* @name $vl_desc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required false
	*/
	protected $vl_desc;
	
	/**
	* Abatimento não tributado e não comercial Ex. desconto ICMS nas remessas para ZFM.
	* @name $vl_abat_nt
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required false
	*/
	protected $vl_abat_nt;
	/**
	* Valor total das mercadorias e serviços
	* @name $vl_merc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required false
	*/
	protected $vl_merc;
	/**
	* Indicador do tipo do frete:
	* 	0- Por conta de terceiros;
	* 	1- Por conta do emitente;
	* 	2- Por conta do destinatário;
	* 	9- Sem cobrança de frete.
	* @name $ind_frt
	* @size 1
	* @type string
	* @position 17
	* @required true
	*/
	protected $ind_frt;
	
	/**
	* Valor do frete indicado no documento fiscal
	* @name $vl_frt
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 18
	* @required false
	*/
	protected $vl_frt;
	
	/**
	* Valor do seguro indicado no documento fiscal
	* @name $vl_seg
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 19
	* @required false
	*/
	protected $vl_seg;
	
	/**
	* Valor de outras despesas acessórias
	* @name $vl_out_da
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 20
	* @required false
	*/
	protected $vl_out_da;

	/**
	* Valor da base de cálculo do ICMS
	* @name $vl_bc_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 21
	* @required false
	*/
	protected $vl_bc_icms;
	
	/**
	* Valor do ICMS
	* @name $vl_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 22
	* @required false
	*/
	protected $vl_icms;
	
	/**
	* Valor da base de cálculo do ICMS substituição tributária
	* @name $vl_bc_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 23
	* @required false
	*/
	protected $vl_bc_icms_st;
	
	/**
	* Valor do ICMS retido por substituição tributária
	* @name $vl_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 24
	* @required false
	*/
	protected $vl_icms_st;
	
	/**
	* Valor total do IPI
	* @name $vl_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 25
	* @required false
	*/
	protected $vl_ipi;
	
	/**
	* Valor total do PIS
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 26
	* @required false
	*/
	protected $vl_pis;
	
	/**
	* Valor total da COFINS
	* @name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 27
	* @required false
	*/
	protected $vl_cofins;
	
	/**
	* Valor total do PIS retido por substituição tributária
	* @name $vl_pis_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 28
	* @required false
	*/
	protected $vl_pis_st;
	
	/**
	* Valor total da COFINS retido por substituição tributária
	* @name $vl_cofins_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 29
	* @required false
	*/
	protected $vl_cofins_st;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>