<?php 
/**
* REGISTRO C110: COMPLEMENTO DO DOCUMENTO - INFORMAÇÃO COMPLEMENTAR DA NOTA FISCAL (CÓDIGOS 01, 1B, 04 e 55)
* Este registro tem por objetivo identificar os dados contidos no campo Informações Complementares da Nota Fiscal, que sejam de interesse do Fisco ou conforme disponha a legislação, e que estejam explicitamente citadas no documento
* Fiscal, tais como: forma de pagamento, local da prestação/execução do serviço, operação realizada com suspensão das contribuições sociais, etc.
* Não podem ser informados para um mesmo documento fiscal, dois ou mais registros com o mesmo conteúdo no campo COD_INF.
* Registro com estrutura, campos e conteúdo definidos e constantes no Leiaute da Escrituração Fiscal Digital – EFD
* (ICMS e IPI), instituído pelo Ato COTEPE/ICMS nº 9, de 12 de abril de 2008, disponível no portal de serviços (SPED) da página da Secretaria da Receita Federal do Brasil na Internet, no endereço <www.receita.fazenda.gov.br/sped>.
*
* Observações: Devem ser observadas para este registro as observações constantes no registro pai (C100).
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C110 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C110.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C110';
	
	/**
	* Código da informação complementar do documento fiscal (campo 02 do Registro 0450)
	* @name $cod_inf
	* @size 6
	* @type string
	* @position 02
	* @required true
	*/
	protected $cod_inf;
	
	/**
	* Descrição complementar do código de referência
	* @name $txt_compl
	* @size undefined
	* @type string	
	* @position 03
	* @required false	
	*/
	protected $txt_compl;
	

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>
?>