<?php 
/**
* REGISTRO C170: COMPLEMENTO DO DOCUMENTO - ITENS DO DOCUMENTO (CÓDIGOS 01, 1B, 04 e 55)
* Registro obrigatório para discriminar os itens da nota fiscal (mercadorias e/ou serviços constantes em notas conjugadas),
* inclusive em operações de entrada de mercadorias acompanhada de Nota Fiscal Eletrônica (NF-e) de emissão de terceiros.
* Não podem ser informados para um mesmo documento fiscal, dois ou mais registros com o mesmo conteúdo no campo NUM_ITEM.
* Registro com estrutura, campos e conteúdo definidos e constantes no Leiaute da Escrituração Fiscal Digital – EFD (ICMS
* e IPI), instituído pelo Ato COTEPE/ICMS nº 9, de 12 de abril de 2008, disponível no portal de serviços (SPED) da
* página da Secretaria da Receita Federal do Brasil na Internet, no endereço <www.receita.fazenda.gov.br/sped>.
* IMPORTANTE: para documentos de entrada/aquisição, os campos de valor de imposto/contribuição, base de cálculo e alíquota só devem ser informados se o adquirente tiver direito à apropriação do crédito (enfoque do declarante). Não precisam ser relacionados documentos fiscais que não dão direito à apuração de créditos de PIS/Pasep e de Cofins. Caso o
* documento fiscal contenha tanto itens sem direito à apropriação de crédito quanto itens com direito, a nota fiscal deverá ser informada em sua integralidade.
* Não precisam ser relacionados neste registro os documentos fiscais representativos das operações geradoras de
* contribuição social ou de crédito, abaixo relacionadas, tendo em vista que as mesma são informadas e consideradas em
* registros próprios da EFD-PIS/Cofins:
* 	- Aquisição de bens a serem incorporados ao ativo imobilizado, cujo crédito for determinado com base no valor de aquisição e/ou com base nos encargos mensais de depreciação. O detalhamento do crédito com base nos encargos de depreciação deverá ser feito no registro F120. Caso o crédito seja apurado com base no valor de aquisição deverá ser informado no registro F130;
*
* 	- Fornecimento e/ou Aquisição de Energia Elétrica (documento fiscal código 06). Os documentos fiscais relativos à energia elétrica devem ser escriturados nos registros C500 (Aquisição com crédito) e/ou C600 (Fornecimento de energia);
*
*	- Prestação e/ou Aquisição de serviços de transportes (documentos fiscais códigos 07, 08, 8B, 09, 10, 11, 26, 27 e 57). Os referidos documentos fiscais relativos a serviços de transportes devem ser escriturados nos registros D100 (Aquisição com crédito) e/ou D200 (Prestação de serviço);
*
* 	- Prestação e/ou Aquisição de serviços de transporte de passageiros – Bilhetes de Passagem (documentos fiscais códigos 2E, 13, 14, 15, 16 e 18). Os referidos documentos fiscais relativos a serviços de transporte de passageiros devem ser escriturados nos registros D300 ou D350 (bilhete emitido por ECF);
*
* 	- Prestação e/ou Aquisição de serviços de comunicação e telecomunicação (documentos fiscais códigos 21 e 22). Os referidos documentos fiscais relativos a serviços de comunicação e telecomunicação devem ser escriturados nos registros D500 (Aquisição com crédito) e/ou D600 (Prestação de serviço);
*
* 	- Fornecimento e/ou Aquisição de água canalizada ou gás (documentos fiscais códigos 28 e 29). Os documentos fiscais relativos a água canalizada e gás devem ser escriturados nos registros C500 (Aquisição com crédito) e/ou C600 (Fornecimento d´água canalizada e gás);
*
* 	- Cupom Fiscal (documentos fiscais códigos 02, 2D e 59). Os documentos fiscais relativos Cupom Fiscal devem ser escriturados nos registros C400 (informação por ECF) ou C490 (informação consolidada).
*
* Observações:
* 	1. Devem ser observadas para este registro as observações constantes no registro pai (C100).
* 	2. Este registro deve ser preenchido para detalhar, em relação a cada item constante no documento fiscal escriturado em C100, as informações referentes ao CST, bases de cálculo, alíquota e valor da contribuição ou do crédito.
* 	3. Caso a pessoa jurídica apure a Contribuição Social por Unidade de Medida de Produto (Combustíveis, Bebidas Frias e Embalagem para Bebidas, etc), deve preencher os campos “QUANT_BC_PIS”, “QUANT_BC_COFINS”, “ALIQ_PIS_QUANT” e “ALIQ_COFINS_QUANT”. Neste caso (contribuição apurada por unidade de medida) os campos “VL_BC_PIS”, “VL_BC_COFINS”, “ALIQ_PIS” e “ALIQ_COFINS” não devem ser preenchidos.
* 	4. Os valores escriturados nos campos de bases de cálculo de PIS/Pasep (Campos 26 e 28) e de Cofins (Campos 32 e 34), de itens com CST representativos de receitas tributadas ou de operações geradoras de créditos, serão recuperados no Bloco M, para a demonstração das bases de cálculo do PIS/Pasep (M210) e da Cofins (M610) apuradas, bem como para a  demonstração das bases de cálculo dos créditos de PIS/Pasep (M105) e da Cofins (M505) apurados, conforme o caso.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C170 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C170.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C170';
	
	/**
	* Número seqüencial do item no documento fiscal
	* @name $num_item
	* @size 3
	* @type numeric
	* @position 02
	* @required true
	*/
	protected $num_item;
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $cod_item;
	
	/**
	* Descrição complementar do item como adotado no documento fiscal.
	* @name $descr_compl
	* @size undefined
	* @type string
	* @position 04
	* @required false
	*/
	protected $descr_compl;

	/**
	* Quantidade do item
	* @name $qtd
	* @size undefined
	* @type decimal 5 casas decimais
	* @position 05
	* @required true
	*/
	protected $qtd;

	/**
	* Unidade do item (Campo 02 do registro 0190)
	* @name $unid
	* @size 6
	* @type numeric
	* @position 06
	* @required false	
	*/
	protected $unid;

	/**
	* Valor total do item (mercadorias ou serviços)
	* @name $vl_item
	* @size undefined
	* @type decimal 2 casas decimais	
	* @position 07
	* @required true
	*/
	protected $vl_item;

	/**
	* Valor do desconto comercial
	* @name $vl_desc
	* @size undefined
	* @type decimal 2 casas decimais	
	* @position 08
	* @required false
	*/
	protected $vl_desc;

	/**
	* Movimentação física do ITEM/PRODUTO:
	* 0. SIM
	* 1. NÃO
	* @name $ind_mov
	* @size 2
	* @type string	
	* @position 09
	* @required false
	*/
	protected $ind_mov;

	/**
	* Código da Situação Tributária referente ao ICMS, conforme a Tabela indicada no item 4.3.1
	* @name $cst_icms
	* @size 3
	* @type numeric
	* @position 10
	* @required false
	*/
	protected $cst_icms;
	
	/**
	* Código Fiscal de Operação e Prestação
	* @name $cfop
	* @size 4
	* @type numeric
	* @position 11
	* @required true
	*/
	protected $cfop;

	/**
	* Código da natureza da operação (campo 02 do Registro 0400)
	* @name $cod_nat
	* @size 10
	* @type string
	* @position 12
	* @required false
	*/
	protected $cod_nat;

	/**
	* Valor da base de cálculo do ICMS
	* @name $vl_bc_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 13
	* @required false
	*/
	protected $vl_bc_icms;

	/**
	* Valor da base de cálculo da COFINS
	* @name $aliq_icms
	* @size 6
	* @type decimal 2 casas decimais
	* @position 14
	* @required false
	*/
	protected $aliq_icms;
	
	/**
	* Valor do ICMS creditado/debitado
	* @name $vl_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required false
	*/
	protected $vl_icms;
	
	/**
	* Valor da base de cálculo referente à substituição tributária
	* @name $vl_bc_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required false
	*/
	protected $vl_bc_icms_st;
	
	/**
	* Alíquota do ICMS da substituição tributária na unidade da federação de destino
	* @name $aliq_st
	* @size 6
	* @type decimal 2 casas decimais
	* @position 17
	* @required false
	*/
	protected $aliq_st;
	
	/**
	* Valor do ICMS referente à substituição tributária
	* @name $vl_icms_st
	* @size undefined
	* @type decimal 2 casa decimais
	* @position 18
	* @required false
	*/
	protected $vl_icms_st;
	
	/**
	* Indicador de período de apuração do IPI:
	* 	0 - Mensal;
	* 	1 Decendial
	* @name $ind_apur
	* @size 1
	* @type string
	* @position 19
	* @required false
	*/
	protected $ind_apur;
	
	/**
	* Código da Situação Tributária referente ao IPI, conforme a Tabela indicada no item 4.3.2.
	* @name $cst_ipi
	* @size 2
	* @type string
	* @position 20
	* @required false
	*/
	protected $cst_ipi;
	
	/**
	* Código de enquadramento legal do IPI, conforme tabela indicada no item 4.5.3.
	* @name $cod_enq
	* @size 3
	* @type string
	* @position 21
	* @required false
	*/
	protected $cod_enq;
	
	/**
	* Valor da base de cálculo do IPI
	* @name $vl_bc_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 22
	* @required false
	*/
	protected $vl_bc_ipi;	
	
	/**
	* Alíquota do IPI
	* @name $aliq_ipi
	* @size 6
	* @type decimal 2 casas decimais
	* @position 23
	* @required false
	*/
	protected $aliq_ipi;	
	
	/**
	* Valor do IPI creditado/debitado
	* @name $vl_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 24
	* @required false
	*/
	protected $vl_ipi;
	
	/**
	* Código da Situação Tributária referente ao PIS.
	* @name $cst_pis
	* @size 2
	* @type numeric
	* @position 25
	* @required true
	*/
	protected $cst_pis;
	
	/**
	* Valor da base de cálculo do PIS
	* @name $vl_bc_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 26
	* @required false
	*/
	protected $vl_bc_pis;
	
	/**
	* Alíquota do PIS (em percentual)
	* @name $aliq_pis
	* @size 8
	* @type decimal 4 casas decimais
	* @position 27
	* @required false
	*/
	protected $aliq_pis;
	
	/**
	* Quantidade – Base de cálculo PIS/PASEP
	* @name $quant_bc_pis
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 28
	* @required false
	*/
	protected $quant_bc_pis;
	
	/**
	* Alíquota do PIS (em reais)
	* @name $aliq_pis_quant
	* @size undefined
	* @type decimal 4 casas decimais
	* @position 29
	* @required false
	*/
	protected $aliq_pis_quant;
	
	/**
	* Valor do PIS
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 30
	* @required false
	*/
	protected $vl_pis;
	
	/**
	* Código da Situação Tributária referente ao COFINS
	* @name $cst_cofins
	* @size 2
	* @type numeric
	* @position 31
	* @required true
	*/
	protected $cst_cofins;
	
	/**
	* Valor da base de cálculo da COFINS
	* @name $vl_bc_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 32
	* @required false
	*/
	protected $vl_bc_cofins;
	
	/**
	* Alíquota do COFINS (em percentual)
	* @name $aliq_cofins
	* @size 8
	* @type decimal 4 casas decimais
	* @position 33
	* @required false
	*/
	protected $aliq_cofins;
	
	/**
	* Quantidade – Base de cálculo COFINS
	* @name $quant_bc_cofins
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 34
	* @required false
	*/
	protected $quant_bc_cofins;
	
	/**
	* Alíquota da COFINS (em reais)
	* @name $aliq_cofins_quant
	* @size undefined
	* @type decimal 4 casas decimais
	* @position 35
	* @required false
	*/
	protected $aliq_cofins_quant;
	
	/**
	* Valor da COFINS
	* @name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 36
	* @required false
	*/
	protected $vl_cofins;
	
	/**
	* Código da conta analítica contábil debitada/creditada
	* @name $cod_cta
	* @size 60
	* @type string
	* @position 37
	* @required false
	*/
	protected $cod_cta;
	

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>