<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	if(!empty($dados->marca) && $dados->marca != "Novo Registro"){
		$aux = $dados->marca;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$mar_descr = " and d.mar_codigo in (".$aux2.")";	
	}else{
		$mar_descr = "";	
	}

	if(!empty($dados->produto) && $dados->produto != "Novo Registro"){
		$aux = $dados->produto;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_descr = " and a.ref_codigo in (".$aux2.")";	
	}else{
		$ref_descr = "";	
	}

	$grp_codigo = "";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and b.grp_codigo = ".$dados->{'grupo'};
	}

	$sgp_codigo = "";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and b.sgp_codigo = ".$dados->{'subgrupo'};
	}

	if(empty($dados->data_ini) || $dados->data_ini == "Novo Registro"){
		$data_ini = "2000-01-01";
	}else{
		$data_ini = $dados->data_ini;	
	}

	if(empty($dados->data_fim) || $dados->data_fim == "Novo Registro"){
		$data_fim = "2020-12-30";
	}else{
		$data_fim = $dados->data_fim;	
	}

	$stk_data = " and a.stk_data between '".$data_ini."' and '".$data_fim."'";
	if($data_ini != "2020-12-30" && $data_fim != "2020-12-30"){
		$periodo = "DE ".$data_ini." ATÉ ".$data_fim;
	}else{
		$periodo = "DE ".data($data_ini)." ATÉ ".data($data_fim);
	}
	
	if($dados->ordenar == 0){
		$ordenar = " b.ref_descr asc";
	}else{
		$ordenar = " d.mar_descr asc, b.ref_descr asc";
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();

	$condicao = "a.stk_qde>0 and ";
	
	$filtroSaldoPositivo='{"cod":"700520","params":[
		{"name":"emp_codigo","value":"'.$company[0]->emp_codigo.'","type":"string"},
		{"name":"ref_descr","value":"'.$ref_descr.'","type":"other"},
		{"name":"mar_descr","value":"'.$mar_descr.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"ordenar","value":"'.$ordenar.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"condicao","value":"'.$condicao.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$Datapacket->add($filtroSaldoPositivo);
	$rowdataPositivo = $Datapacket->open(true);
	$cntPositivo = $Datapacket->getRecordCount();
	$Datapacket->clear();

	$condicao = "a.stk_qde<0 and ";
	
	$filtroSaldoNegativo='{"cod":"700520","params":[
		{"name":"emp_codigo","value":"'.$company[0]->emp_codigo.'","type":"string"},
		{"name":"ref_descr","value":"'.$ref_descr.'","type":"other"},
		{"name":"mar_descr","value":"'.$mar_descr.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"ordenar","value":"'.$ordenar.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"condicao","value":"'.$condicao.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$Datapacket->add($filtroSaldoNegativo);
	$rowdataNegativo = $Datapacket->open(true);
	$cntNegativo = $Datapacket->getRecordCount();
	$Datapacket->clear();

	$condicao = "";
	
	$filtro='{"cod":"700520", "params":[
		{"name":"emp_codigo","value":"'.$company[0]->emp_codigo.'","type":"string"},
		{"name":"ref_descr","value":"'.$ref_descr.'","type":"other"},
		{"name":"mar_descr","value":"'.$mar_descr.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"ordenar","value":"'.$ordenar.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"condicao","value":"'.$condicao.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	echo "MARCA;PRODUTO;COD. BARRAS;COD. FABRICANTE;COD. AUXILIAR;ESTOQUE;ENTRADAS;SAIDAS;".chr(13).chr(10);

	$ref_marca = "";
	$arrayMarca = array();	
	$saldoN = 0;
	$saldoP = 0;
	
	for($i=0; $i<$cnt; $i++){
		if($ref_marca != $rowdata[$i]->{'mar_descr'}){
			array_push($arrayMarca,$rowdata[$i]->{'mar_descr'}."-".$rowdata[$i]->{'mar_codigo'});
			$ref_marca = $rowdata[$i]->{'mar_descr'};
		}
	}


	for($k=0; $k<$cnt; $k++){
		$saldo = $rowdata[$k]->{'saldo'};
		$ref_preco = $rowdata[$k]->{'ref_preco'};
		$ref_codigo = $rowdata[$k]->{'ref_codigo'};
		$descricao = $rowdata[$k]->{'ref_reduz'};
		$propriedade = $rowdata[$k]->{'ref_propriedade'};
		$fornecedor = $rowdata[$k]->{'ref_codforn'};
		$codbar = $rowdata[$k]->{'ref_codbar'};
		
		for($y=0; $y<$cntPositivo; $y++){
			if($rowdataPositivo[$y]->{'ref_codigo'} == $ref_codigo){
				$saldoP = $rowdataPositivo[$y]->{'saldo'};
				break;
			}
		}
		for($z=0; $z<$cntNegativo; $z++){
			if($rowdataNegativo[$z]->{'ref_codigo'} == $ref_codigo){
				$saldoN = $rowdataNegativo[$z]->{'saldo'};
				break;
			}
		}				
		echo $rowdata[$k]->{"mar_descr"}.";".$descricao.";".$codbar.";".$fornecedor.";".$propriedade.";".qtde($saldo).";".valorVazio(qtde($saldoP)).";".valorVazio(qtde(valorNegativo($saldoN))).";".chr(13).chr(10);
	}	
	
	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $TParams->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit("/desktop/tmp/".$nome.".csv");

?>