<?php
	error_reporting(E_ALL);

	set_time_limit(0);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include('../php/datapacket.php');
	include('../php/TParams.class.php');
	include('../php/funcoes.php');
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//--- marca
		$mar_codigo = '';
		if(isset($dados->{'marcas'}) && !empty($dados->{'marcas'})){
			$aux = $dados->{'marcas'};
			$aux2 = "";
			$j=count($aux)-1;
			for($i=0;$i<count($aux);$i++){
				if($j < count($aux)){
					$aux2 .= "'".$aux[$i]."'"; 
				}else{
					$aux2 .= ", '".$aux[$i]."'"; 
				}
				$j++;
			}
			$mar_codigo = " and d.mar_codigo in (".$aux2.")";	
		}
	//---
	//--- produtos
		$ref_codigo = '';
		if(isset($dados->{'produtos'}) && !empty($dados->{'produtos'})){
			$aux = $dados->{'produtos'};
			$aux2 = "";
			$j=count($aux)-1;
			for($i=0;$i<count($aux);$i++){
				if($j < count($aux)){
					$aux2 .= "'".$aux[$i]."'"; 
				}else{
					$aux2 .= ", '".$aux[$i]."'"; 
				}
				$j++;
			}
			$ref_codigo = " and c.ref_codigo in (".$aux2.")";	
		}
	//---
	//--- data
		$not_data = "";
		$periodo = "";
		if(!empty($dados->{'data_ini'}) && $dados->{'data_ini'} != "Novo Registro"){
			$not_data =  " and b.not_data >= '".dataBd($dados->{'data_ini'})." 00:00:00'";
			$periodo = "DE ".data($dados->{'data_ini'});	
			if(!empty($dados->{'data_fim'}) && $dados->{'data_fim'} != "Novo Registro"){
				$not_data .= " and b.not_data <= '".dataBd($dados->{'data_fim'})." 23:59:59'";
				$periodo .= "ATÉ ".data($dados->{'data_fim'});	
			}
		}else{
			if(!empty($dados->{'data_fim'}) && $dados->{'data_fim'} != "Novo Registro"){
				$not_data = " and b.not_data <= '".dataBd($dados->{'data_fim'})." 23:59:59'";
				$periodo = "ATÉ ".data($dados->{'data_fim'});	
			}else{
				$periodo = "TODOS";	
			}
		}
	//---- 
		
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$filtroProdutos = '{"cod":"500730", "params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"not_data","value":"'.$not_data.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroProdutos);
	$retProdutos = $Datapacket->open(true);
	$cntProdutos = $Datapacket->getRecordCount();
	// echo $Datapacket->getLastQuery()."<br />";
	$Datapacket->clear();

	$filtroItem = '{"cod":"500731", "params":[
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"not_data","value":"'.$not_data.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtroItem);
	$retItem = $Datapacket->open(true);
	$cntItem = $Datapacket->getRecordCount();
	// echo $Datapacket->getLastQuery()."<br />";
	$Datapacket->clear();

	class Registro{
		private $registros;
		private $codigo = "";
		private $tmp;

		function __construct($args){
			$this->registros = $args;
		}

		public function getRegistros($codigo){		
			if($this->codigo != $codigo){
				$this->codigo = $codigo;
				reset($this->registros);
			} 
			$this->tmp = array();
		    while ($array = current($this->registros)) {
			    if ($array->{'ref_codigo'} == $codigo) {
			        
			        array_push($this->tmp, json_encode($array));
			    }
			    next($this->registros);
			}
		    return $this->tmp;
		}

		public function getRegs(){
			return $this->registros;
		}
	}
	$registros = new Registro($retItem);
	unset($retItem);

	echo "# Produtos inexistentes na tabela de produtos;".chr(13).chr(10);
	
	echo "CODIGO;PRODUTO;QTDE. TOTAL;CUSTO MEDIO;CUSTO TOTAL;PMU;FATURAMENTO;LUCRO R$;LUCRO %;".chr(13).chr(10);
	
	$i=0;
	while($i < $cntProdutos){
		
		$pmu = 0;
		$qtdeTotal = 0;
		$custoMedio = 0;
		$custoTotal = 0;
		$valorLucro = 0;
		$valorUnitario = 0;
		$faturamentoTotal = 0;
		$porcentagemLucro = 0;
		$descricao = "";
		$regis = $registros->getRegistros($retProdutos[$i]->{'ref_codigo'});
		$j = 0;
		while($j < count($regis)){
			$linha = json_decode($regis[$j]);
			$qtdeTotal += $linha->{'itn_qtde'};
			$valorUnitario += $linha->{'itn_valor'};
			if(isset($linha->{'itn_custovenda'})&&!empty($linha->{'itn_custovenda'})&&$linha->{'itn_custovenda'}>0){
				$custoMedio += $linha->{'itn_custovenda'};  
			}else{
				$custoMedio += $linha->{'cus_medio'};  
			}
			$j++;
		}
		$custoMedio = $custoMedio / count($regis);
		$custoTotal = $custoMedio * $qtdeTotal;
		$pmu = $valorUnitario / count($regis);
		$faturamentoTotal = $pmu * $qtdeTotal;
		$valorLucro = $faturamentoTotal - $custoTotal;
		if($valorLucro != 0 && $faturamentoTotal != 0){
			$porcentagemLucro = $valorLucro * 100 / $faturamentoTotal;	
		}
		
		if(isset($retProdutos[$i]->{'ref_descr'})&&!empty($retProdutos[$i]->{'ref_descr'})){
			$codigo = ($retProdutos[$i]->{'ref_codbar'})?$retProdutos[$i]->{'ref_codbar'}:$retProdutos[$i]->{'ref_propriedade'};
			$descricao = $retProdutos[$i]->{'ref_descr'};
		}else{
			$codigo = ($retProdutos[$i]->{'itn_codbar'})?"# ".$retProdutos[$i]->{'itn_codbar'}:"# ";
			$descricao = $retProdutos[$i]->{'itn_descr'};
		}
		
		echo $codigo.";".$descricao.";".$qtdeTotal.";".str_replace(",",".",valorFormatDuasCasas($custoMedio)).";".str_replace(",",".",valorFormatDuasCasas($custoTotal)).";".str_replace(",",".",valorFormatDuasCasas($pmu)).";".str_replace(",",".",valorFormatDuasCasas($faturamentoTotal)).";".str_replace(",",".",valorFormatDuasCasas($valorLucro)).";".str_replace(",",".",valorFormatDuasCasas($porcentagemLucro)).";".chr(13).chr(10);	

		$i++;
	}
	
	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $TParams->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit("/desktop/tmp/".$nome.".csv");
	
?>