<?php
	set_time_limit(0);
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	//argumentos
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//marca
	$mar_codigo = "";
	if(!empty($dados->{'marca'})){
		$aux = $dados->{'marca'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$mar_codigo = " and b.mar_codigo in (".$aux2.")";	
	}

	//produto
	$ref_codigo = "";
	if(!empty($dados->{'produto'}) && $dados->{'produto'} != "Novo Registro"){
		$aux = $dados->{'produto'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and a.ref_codigo in (".$aux2.")";	
	}

	// grupo
	$grp_codigo = "";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and a.grp_codigo = ".$dados->{'grupo'};
	}

	//subgrupo
	$sgp_codigo = "";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and a.sgp_codigo = ".$dados->{'subgrupo'};
	}

	//data inicial e final
	$stk_data = "";
	$periodo = "TODOS";
	if(isset($dados->{'data_ini'})){
		$stk_data = " and stk_data >= '".$dados->{'data_ini'}."'";	
		$periodo = "DE ".data($dados->{'data_ini'});
		if(isset($dados->{'data_fim'})){
			$stk_data .= " and stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo .= utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}else{
		if(isset($dados->{'data_fim'})){
			$stk_data = " and stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo = utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}
	
	//ordenação
	$ordenacao = "";
	if($dados->{'ordenar'} == 0){
		$ordenacao = ", a.ref_descr asc";
	}
	
	//consultas
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$datapacket->setHost($TParams->getHost("empresas"));
	$datapacket->add($filtroCompany);
	$company = $datapacket->open(true);
	$datapacket->clear();
	
	$filtro='{"cod":"700972","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"database","value":"'.$company[0]->{'emp_db_sge'}.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro);
	$retMarcas = $datapacket->open(true);
	$cntMarcas = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	$filtro2='{"cod":"700973","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"database","value":"'.$company[0]->{'emp_db_sge'}.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro2);
	$retProdutos = $datapacket->open(true);
	$cntProdutos = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	$filtro3='{"cod":"700976","params":[
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro3);
	$retForn = $datapacket->open(true);
	$cntForn = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();


	echo "MARCA;PRODUTO;COD. BARRAS;NCM;ESTOQUE MINIMO;ESTOQUE ATUAL;CUSTO VENDA;CUSTO MEDIO;PRECO VENDA;".chr(13).chr(10);
	

	for($i=0;$i<$cntMarcas;$i++){
		for($j=0;$j<$cntProdutos;$j++){
			if(empty($retProdutos[$j]->{'mar_codigo'})){
				$retProdutos[$j]->{'mar_codigo'} = 999;
				$retProdutos[$j]->{'mar_descr'} = "PADRAO";
			}
			if($retProdutos[$j]->{'mar_codigo'} == $retMarcas[$i]->{'mar_codigo'}){
				echo $retMarcas[$i]->{'mar_descr'}.";".$retProdutos[$j]->{'ref_descr'}.";".$retProdutos[$j]->{'ref_codbar'}.";".$retProdutos[$j]->{'ref_ncm'}.";".qtde($retProdutos[$j]->{'ref_qtdemin'}).";".qtde($retProdutos[$j]->{'stk_qde'}).";".str_replace(",",".",valorFormat($retProdutos[$j]->{'cus_venda'})).";".str_replace(",",".",valorFormat($retProdutos[$j]->{'cus_medio'})).";".str_replace(",",".",valorFormat($retProdutos[$j]->{'ref_preco'})).";".chr(13).chr(10);
			}
		}
	}
	
	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $TParams->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit("/desktop/tmp/".$nome.".csv");
	
?>