<?php
	set_time_limit(0);
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	//argumentos
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//produto
	$ref_codigo = "";
	if(!empty($dados->{'produto'}) && $dados->{'produto'} != "Novo Registro"){
		$aux = $dados->{'produto'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and a.ref_codigo in (".$aux2.")";	
	}

	// grupo
	$grp_codigo = "";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and c.grp_codigo = ".$dados->{'grupo'};
	}

	// subgrupo
	$sgp_codigo = "";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and c.sgp_codigo = ".$dados->{'subgrupo'};
	}

	//data inicial e final
	$stk_data = "";
	$periodo = "TODOS";
	if(isset($dados->{'data_ini'})){
		$stk_data = " and stk_data >= '".$dados->{'data_ini'}."'";	
		$periodo = "DE ".data($dados->{'data_ini'});
		if(isset($dados->{'data_fim'})){
			$stk_data .= " and stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo .= utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}else{
		if(isset($dados->{'data_fim'})){
			$stk_data = " and stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo = utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}
	
	class SaldoStk {
		private $registros;
		private $total;
		private $codigo;

		function __construct($regis, $total){
			$this->registros = $regis;
			$this->total = $total;
		}

		public function getRegistros(){
			return $this->registros;
		}

		public function getLotes($ref){
			$lotes = array();
			$prod = array();
			reset($this->registros);
			while ($aux = current($this->registros)) {
			    if ($aux->{'ref_codigo'} == $ref) {
			        array_push($lotes, $aux->{'lot_codigo'}."%".$aux->{'lot_vencto'}."%".$aux->{'lot_descr'}); 
			    }
			    next($this->registros);
			}
			$lotes = array_unique($lotes);
			foreach($lotes as $value){
				$total = 0;
				$lot = explode("%", $value);
				reset($this->registros);
				while ($aux = current($this->registros)) {
				    if ($aux->{'ref_codigo'} == $ref && $aux->{'lot_codigo'} == $lot[0]) {
				        $total += $aux->{'stk_qde'};
				    }
				    next($this->registros);
				}
				array_push($prod, '{"lot_codigo":"'.$lot[0].'", "stk_qde":"'.$total.'", "lot_vencto":"'.$lot[1].'", "lot_descr":"'.$lot[2].'"}');
			}
			return $prod;
		}
	}
	
	//consultas
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$datapacket->setHost($TParams->getHost("empresas"));
	$datapacket->add($filtroCompany);
	$company = $datapacket->open(true);
	$datapacket->clear();
	
	$filtro='{"cod":"700974","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro);
	$retProd = $datapacket->open(true);
	$cntProd = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	$filtro='{"cod":"700975","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro);
	$retStk = $datapacket->open(true);
	$cntStk = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	$saldoStk = new SaldoStk($retStk, $cntStk);
	unset($retStk);
	unset($cntStk);

	echo "PRODUTO;COD. BARRAS;ESTOQUE;LOTE;VALIDADE;QUANTIDADE".chr(13).chr(10);

	$vencimento = "";
	
	for($i=0;$i<$cntProd;$i++){
		
		if(isset($retProd[$i]->{'ref_descr'})&&!empty($retProd[$i]->{'ref_descr'})){
			if(isset($retProd[$i]->{'stk_qde'})&&$retProd[$i]->{'stk_qde'}>0){
				$registros = $saldoStk->getLotes($retProd[$i]->{'ref_codigo'});
				for($j=0;$j<count($registros);$j++){
					$lote = json_decode($registros[$j]);
					if($lote->{'stk_qde'} > 0){
						if(isset($lote->{'lot_vencto'})&&!empty($lote->{'lot_vencto'})){
							$vencimento = data($lote->{'lot_vencto'});
						}
						echo $retProd[$i]->{'ref_descr'}.";".$retProd[$i]->{'ref_codbar'}.";".qtde($retProd[$i]->{'stk_qde'}).";".$lote->{'lot_descr'}.";".$vencimento.";".qtde($lote->{'stk_qde'}).chr(13).chr(10);	
					}
				}
			}
		}
	}

	$html = ob_get_clean();
	$nome = str_replace(array(".",","), "", microtime(true));
	$arquivo = $TParams->getHostRoot()."tmp/".$nome.'.csv';
	$fp = fopen($arquivo, 'w');
	fwrite($fp, $html); 
	$type = pathinfo($arquivo);
	header("Content-Type: ".mime_content_type($arquivo));
	header("Content-Length:".filesize($arquivo));
	header('Content-Disposition: attachment; filename="'.$type['filename'].'.'.$type['extension'].'"');
	header("Content-Transfer-Encoding: binary");
	header('Expires: 0');
	header('Pragma: no-cache');
	fclose($fp);
	$fp = fopen($arquivo, "r");
	fclose($fp);

	exit("/desktop/tmp/".$nome.".csv");
	
?>