<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	if(isset($dados->{'not_dtfaturam_ini'})&&!empty($dados->{'not_dtfaturam_ini'})){
		$not_dtfaturam_ini = data($dados->{'not_dtfaturam_ini'},true)." 00:00:01";
	}else{
		$not_dtfaturam_ini = "2000-01-01 00:00:01";
	}
	
	if(isset($dados->{'not_dtfaturam_fim'})&&!empty($dados->{'not_dtfaturam_fim'})){
		$not_dtfaturam_fim = data($dados->{'not_dtfaturam_fim'},true)." 23:59:59";
	}else{
		$not_dtfaturam_fim = date('Y-m-d H:i:s');
	}
		
	if(isset($dados->{'cad_codvend'})&&!empty($dados->{'cad_codvend'}) && $dados->{'cad_codvend'} != "Novo Registro"){
		$cad_codvend = " and header_nota.cad_codvend = ".$dados->{'cad_codvend'};
	}else{
		$cad_codvend = "";
	}
	
	if(isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'}) && $dados->{'cad_codigo'} != "Novo Registro"){
		$cad_codigo = " and header_nota.cad_codigo = ".$dados->{'cad_codigo'};	
	}else{
		$cad_codigo = "";
	}
	
	if(isset($dados->{'ser_codigo'})&&!empty($dados->{'ser_codigo'}) && $dados->{'ser_codigo'} != "Novo Registro"){
		$ser_codigo = " and header_nota.ser_codigo = ".$dados->{'ser_codigo'};
		$serie = $dados->{'ser_codigo'};
	}else{
		$ser_codigo = "";
		$serie = "Não informada";
	}
	
	if(isset($dados->{'ccu_codigo'})&&!empty($dados->{'ccu_codigo'}) && $dados->{'ccu_codigo'} != "Novo Registro"){
		$ccu_codigo = "and header_nota.ccu_codigo = '".$dados->{'ccu_codigo'}."'";
		$descrCusto = $dados->{'ccu_descr'};
	}else{
		$ccu_codigo = "";
		$descrCusto = "Não informado";
	}

	$tipo = "TODOS";
	if(isset($dados->{'tipo'})&&!empty($dados->{'tipo'})||$dados->{'tipo'}==0){
		if($dados->{'tipo'} != 0){
			
			$not_tipo = $dados->{'tipo'};
			
			if($dados->{'tipo'}==2){
				$tipo = "PEDIDO";
			}else{
				$tipo = "NOTA FISCAL DE SAÍDA";
			}
		}else{
			$not_tipo = "2,9";
		}
	}else{
		$not_tipo = "2,9";
	}
	
	if(isset($dados->{'frete'})){
		$frete = "Sim";
	}else{
		$frete = "Não";
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$empr_razao = $company[0]->emp_razao;
	$empLogo = $company[0]->emp_logo;
	$empCodigo = $company[0]->emp_codigo;
	
	$filtro = '{"cod":"500500", "params":[
		{"name":"db","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"},
		{"name":"not_dtfaturam_ini","value":"'.$not_dtfaturam_ini.'","type":"string"},
		{"name":"not_dtfaturam_fim","value":"'.$not_dtfaturam_fim.'","type":"string"},
		{"name":"cad_codvend","value":"'.$cad_codvend.'","type":"other"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"other"},
		{"name":"ser_codigo","value":"'.$ser_codigo.'","type":"other"},
		{"name":"ccu_codigo","value":"'.$ccu_codigo.'","type":"other"},
		{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"}
	]}';
	
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$periodo = "De ".data($not_dtfaturam_ini). " à ".data($not_dtfaturam_fim);
	$titulo = utf8_decode("RELATÓRIO SINTÉTICO DE COMISSÃO POR VENDEDOR");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};

	include "../rel/inc/relatorioCabecalho.php";
	
	$filtro1 =  base64_encode('<span style="font-weight:bold;">' .utf8_decode("PERÍODO"). ': </span> <span style="font-weight:normal;">' .utf8_decode($periodo).'</span>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1
	);

	$colunas  = '';

	$arrayVendedor = array();
	$vendedor = "";
	$comissao = 0;

	$totalCliente = array();
	$somaFrete= 0;		
	$somaLiquido= 0;
	$somaBruto= 0;
	$somaDesconto= 0;
	$somaDevolucao= 0;
	$somaComissao= 0;

	$qntTotal= 0;		
	$totalSomaFrete= 0;		
	$totalSomaLiquido= 0;
	$totalSomaBruto= 0;
	$totalSomaDesconto= 0;
	$totalSomaDevolucao= 0;
	$totalSomaComissao= 0;

	?>
	<div class="informacaoColuna">
		<div style="float:left; width: 47%; text-align:right;"> TOTAL BRUTO </div>
		<div style="float:left; width: 11%; text-align:right;"> DESCONTO </div>
		<div style="float:left; width: 10%; text-align:right;"> DEVOLUÇÃO</div>
		<div style="float:left; width: 8%;  text-align:right;"> FRETE </div>
		<div style="float:left; width: 10%; text-align:right;"> TOTAL LÍQ.</div>
		<div style="float:left; width: 8%;  text-align:right">  COMISSÃO</div>
	</div>

<?php
	
	for($i=0; $i<$cnt; $i++){
		if($vendedor != $rowdata[$i]->{'cad_codvend'}){
			array_push($arrayVendedor, $rowdata[$i]->{'cad_codvend'}."-".$rowdata[$i]->{'cad_nomeraz'}."-".$rowdata[$i]->{'comissao'});
			$vendedor = $rowdata[$i]->{'cad_codvend'};
		}
	}
	
	
	for($a=0; $a<count($arrayVendedor); $a++){ 
		$aux = explode("-", $arrayVendedor[$a]);
		if($a % 2 == 0){
			$backCor = '#e7e7e7';
		}else{
			$backCor = '#fff';
		}
		for($b=0; $b<$cnt; $b++){
			
			if(!$rowdata[$b]->{'comissao'} || $rowdata[$b]->{'comissao'}=="" || $rowdata[$b]->{'comissao'}==0){
				$rowdata[$b]->{'comissao'} = $rowdata[$b]->{'comissao2'};
			}
			
			if($rowdata[$b]->{'cad_codvend'} == $aux[0]){ 
					
				if($dados->frete==0){
					$total = $rowdata[$b]->{'not_liquido'};
					$comissao = ($rowdata[$b]->{'comissao'}/100 )*$rowdata[$b]->{'not_liquido'};
				}else{
					$total = $rowdata[$b]->{'not_liquido'} - $rowdata[$b]->{'not_frete'};
					$comissao = ($rowdata[$b]->{'comissao'}/100)*$total;
				}
				
				array_push($totalCliente, $rowdata[$b]->{'cad_codigo'});
				$somaBruto+=$rowdata[$b]->{'not_totalnota'}; 
				$somaDesconto+=$rowdata[$b]->{'not_valordesc'}; 
				$somaDevolucao+=$rowdata[$b]->{'not_devolucao'}; 
				$somaFrete+=$rowdata[$b]->{'not_frete'};		
				$somaLiquido+=$total; 
				$somaComissao+=$comissao;

			}
		}
		?>
		<div style="float:left; width:100%; padding:5px 0px; background-color:<?php echo $backCor?>">
			<div style="float:left; width: 20%;"><b>VENDEDOR:</b> <?php echo $aux[1]."&nbsp"; ?></div>
			<div style="float:left; width: 10%; text-align:center; padding-left: 6%;"> Total <?php echo count(array_unique($totalCliente)); if($totalCliente > 1){echo " Clientes";}else{echo " Cliente";}; ?></div>		 			
			<div style="float:left; width: 11%; text-align:right"> <?php echo valorFormat($somaBruto)."&nbsp"; ?></div> 					
			<div style="float:left; width: 11%; text-align:right;"> <?php echo valorFormat($somaDesconto)."&nbsp"; ?></div>
			<div style="float:left; width: 8%; text-align:right"> <?php echo valorFormat($somaDevolucao)."&nbsp"; ?></div> 
			<div style="float:left; width: 10%; text-align:right"> <?php echo valorFormat($somaFrete)."&nbsp"; ?> </div> 
			<div style="float:left; width: 10%; text-align:right"> <?php echo valorFormat($somaLiquido)."&nbsp"; ?></div> 
			<div style="float:left; width: 8%; text-align:right"> <?php echo valorFormat($somaComissao)."&nbsp"; ?></div>
		</div>

		<?php
		$qntTotal+= count(array_unique($totalCliente));		
		$totalSomaFrete+= $somaFrete;		
		$totalSomaLiquido+= $somaLiquido;
		$totalSomaBruto+= $somaBruto;
		$totalSomaDesconto+= $somaDesconto;
		$totalSomaDevolucao+= $somaDevolucao;
		$totalSomaComissao+= $somaComissao;

		$totalCliente = array();
		$somaFrete= 0;		
		$somaLiquido= 0;
		$somaBruto= 0;
		$somaDesconto= 0;
		$somaDevolucao= 0;
		$somaComissao= 0;
		
	}
	?>
		<div class="informacaoRodape">
			<div style="float:left; width:20%; padding-right: 7%"> Total Geral <?php echo $qntTotal; if($qntTotal > 1){echo " Clientes";}else{echo " Cliente";}; ?> </div>		 			
			<div style="float:left; width: 20%; text-align:right"> <?php echo valorFormat($totalSomaBruto)."&nbsp"; ?></div> 					
			<div style="float:left; width: 11%; text-align:right"> <?php echo valorFormat($totalSomaDesconto)."&nbsp"; ?></div>
			<div style="float:left; width: 8%; text-align:right"> <?php echo valorFormat($totalSomaDevolucao)."&nbsp"; ?></div> 
			<div style="float:left; width: 10%; text-align:right"> <?php echo valorFormat($totalSomaFrete)."&nbsp"; ?></div> 
			<div style="float:left; width: 10%; text-align:right"> <?php echo valorFormat($totalSomaLiquido)."&nbsp"; ?></div> 
			<div style="float:left; width: 8%; text-align:right"> <?php echo valorFormat($totalSomaComissao)."&nbsp"; ?></div>
		</div>
<?php

	include "../rel/inc/relatorioRodape.php";
	
?>