<?php
error_reporting(E_ALL);

set_time_limit(600);

ob_start();
date_default_timezone_set("America/Sao_Paulo");
setlocale(LC_ALL, 'pt_BR');

include('../php/TParams.class.php');
include('../php/funcoes.php');

$datapacket = new TParams();

if (isset($_REQUEST['dados']) && !empty($_REQUEST['dados'])) {
	$dados = json_decode(base64_decode($_REQUEST['dados']));

	$doc_dtvcto_ini = date("Y-m-d 00:00:00");
	if(isset($_REQUEST['doc_dtvcto_ini']) && $_REQUEST['doc_dtvcto_ini']!=""){
		$doc_dtvcto_ini = implode("-", array_reverse(explode("/", substr($_REQUEST["doc_dtvcto_ini"],0,10))));
	}
	
	$doc_dtvcto_fim = date("Y-m-d 23:59:59");
	if(isset($_REQUEST["doc_dtvcto_fim"]) && $_REQUEST["doc_dtvcto_fim"]){
		$doc_dtvcto_fim = implode("-", array_reverse(explode("/", substr($_REQUEST["doc_dtvcto_fim"],0,10))));
	}



	$filtro = '{"cod":"500990","params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"doc_dtvcto_ini","value":"'.$doc_dtvcto_ini.'","type":"string"},
		{"name":"doc_dtvcto_fim","value":"'.$doc_dtvcto_fim.'","type":"string"}
	]}';
	
	$datapacket->add($filtro);
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$ret = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

}

	$filtros = "";
	$titulo = utf8_decode('RELATÓRIO DE FLUXO DE CAIXA');
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $datapacket->getCompany()->{"emp_codigo"} . "/" . $datapacket->getCompany()->{"emp_logo"};

	include '../rel/inc/relatorioCabecalho.php';

	?>
	<div style="width:100%; margin: 20px 0px 10px 0px; float:left; font-size:16px; background-color:#D1814B;">Documentos a Receber:</div>
	<div class="informacaoListagem">
		<div style="float:left; width:8%;  text-align:left;"> TIPO  </div>
		<div style="float:left; width:11%; text-align:right; padding-right: 15%"> NÚMERO DOC.  </div>
		<div style="float:left; width:20%; text-align:left;"> CLIENTE  </div>
		<div style="float:left; width:8%;  text-align:right;"> D.INCLUSÃO   </div>
		<div style="float:left; width:8%;  text-align:right;"> VENCIMENTO   </div>
		<div style="float:left; width:12%; text-align:right;"> VALOR        </div>
		<div style="float:left; width:8%;  text-align:right;"> D.PAGAMENTO  </div>
	</div>

	<?php
	// quando o doc_status for 2 ou 1 e quando o doc_pagrec = 1
	// se o doc_status for 1 devemos pegar o valor parcial, ao invés do total.
	$doc_pago = 0;

	// quando o doc_status for 2 ou 1 e quando o doc_pagrec = 2
	// se o doc_status for 1 devemos pegar o valor parcial, ao invés do total.
	$doc_recebido = 0;

	//documentos em aberto que ainda não foram pagos doc_pagrec = 2 e doc_status = 0
	$doc_previsto_pagar = 0;

	//documentos em aberto que ainda não foram recebidos doc_pagrec = 1 e doc_status = 0
	$doc_previsto_receber = 0;
	
	$documentos = array(
		1 => array(),
		2 => array()
	);

	foreach ($ret as $i=>$documento) {
		$tipoDocumento = "Sem Tipo";
		switch ($documento->documento) {
			case 0: 
				$tipoDocumento =  "Vinculado";
				break;
			case 1: 
				$tipoDocumento =  "Duplicata";
				break;
			case 2: 
				$tipoDocumento =  "Boleto";
				break;			
			case 3: 
				$tipoDocumento =  "Promissoria";
				break;			
			case 4: 
				$tipoDocumento =  "Cheque";
				break;			
			case 5: 
				$tipoDocumento =  "Cartão Cred.";
				break;
			case 6: 
				$tipoDocumento =  "Cartão Deb.";
				break;			
			case 7: 
				$tipoDocumento =  "Carnê";
				break;			
			case 8: 
				$tipoDocumento =  "Darf";
				break;			
			case 9: 
				$tipoDocumento =  "Depo. em Conta";
				break;			
			case 10: 
				$tipoDocumento =  "Dinheiro";
				break;			
			case 11: 
				$tipoDocumento =  "Déb. em Conta";
				break;
			case 12: 
				$tipoDocumento =  "Fatura";
				break;
			case 13: 
				$tipoDocumento =  "Multiplas";
				break;
			case 14: 
				$tipoDocumento =  "Boleto Uni. Integrado";
				break;			
			case 99: 
				echo "Outro";
				break;
			default:
				echo "Outro";
				break;
		}
		
		$documentos[$documento->tipo][] = $documento;

		/* ------------------------------------------------------------------------------ 
			SOMATÓRIO DOS VALORES RECEBIDOS

			Quando o tipo for entrada(2) e o status for parcial(1),
			somamos o valor pago à variavel $doc_recebido

			Quando o tipo for entrada(2) e o status for finalizado(2)
			somamos o valor integral
		------------------------------------------------------------------------------ */	

		if(($documento->doc_status == 1) && ($documento->tipo == 2)){
			$doc_recebido += $documento->valor_pago;
		}
		
		if(($documento->doc_status == 2) && ($documento->tipo == 2)){
			$doc_recebido += $documento->valor_total;	
		}

		/* ------------------------------------------------------------------------------ 
			SOMATÓRIO DOS VALORES PAGOS

			Quando o tipo for saida(1) e o status for parcial(1),
			somamos o valor pago à variavel $doc_pago

			Quando o tipo for saida(1) e o status for finalizado(2)
			somamos o valor integral
		------------------------------------------------------------------------------ */	

		if(($documento->doc_status == 1) && ($documento->tipo == 1)){
			$doc_pago += $documento->valor_pago;
		}
		
		if(($documento->doc_status == 2) && ($documento->tipo == 1)){
			$doc_pago += $documento->valor_total;	
		}

		/* ------------------------------------------------------------------------------ 
			SOMATÓRIO DOS VALORES A PAGAR

			Quando o tipo for saida(1) e o status for parcial(1),
			subtraimos o valor pago do valor total e adiconamos á variavel $doc_previsto_pagar

			Quando o tipo for saida(1) e o status for finalizado(2)
			somamos o valor integral
		------------------------------------------------------------------------------ */	

		if(($documento->doc_status == 1) && ($documento->tipo == 1)){
			$doc_previsto_pagar += ($documento->valor_total - $documento->valor_pago);
		}
		
		if(($documento->doc_status == 0) && ($documento->tipo == 1)){
			$doc_previsto_pagar += $documento->valor_total;	
		}


		/* ------------------------------------------------------------------------------ 
			SOMATÓRIO DOS VALORES A RECEBER

			Quando o tipo for entrada(2) e o status for parcial(1),
			subtraimos o valor pago do valor total e adiconamos á variavel $doc_previsto_receber

			Quando o tipo for entrada(2) e o status for finalizado(2)
			somamos o valor integral
		------------------------------------------------------------------------------ */	

		if(($documento->doc_status == 1) && ($documento->tipo == 2)){
			$doc_previsto_receber += ($documento->valor_total - $documento->valor_pago);
		}
		
		if(($documento->doc_status == 0) && ($documento->tipo == 2)){
			$doc_previsto_receber += $documento->valor_total;	
		}


	}

	// Tipo 2 pois estamos interando sobre os documentos a receber
	foreach($documentos[2] as $documento){

		if($i % 2 == 0){
			$backCor = "#EFEEED";
		}else{
			$backCor = "#fff";
		}
		?>
			<div style="float:left; width:100%; background-color:<?php echo $backCor; ?>;  padding:2px 0px 0px 0px;">
				<div style="float:left; width:8%;  text-align:left;">  <?php echo $tipoDocumento ?> &nbsp</div>
				<div style="float:left; width:11%; text-align:right; padding-right: 15%"> <?php echo $documento->numero ?> &nbsp</div>
				<div style="float:left; width:20%; text-align:left;">  <?php echo substr($documento->cliente,0,25) ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_inclusao) ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_vencimento) ?> &nbsp</div>
				<div style="float:left; width:12%; text-align:right;"> <?php echo $documento->valor_total ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_pagamento) ?> &nbsp</div>
			</div>
			
		<?php
	}
		?>

	<div style="width:100%; margin: 20px 0px 10px 0px; float:left; font-size:16px; background-color:#D1814B;">Documentos a Pagar:</div>
		<div class="informacaoListagem">
		<div style="float:left; width:8%;  text-align:left;"> TIPO  </div>
		<div style="float:left; width:11%; text-align:right; padding-right: 15%"> NÚMERO DOC.  </div>
		<div style="float:left; width:20%; text-align:left;"> CLIENTE  </div>
		<div style="float:left; width:8%;  text-align:right;"> D.INCLUSÃO   </div>
		<div style="float:left; width:8%;  text-align:right;"> VENCIMENTO   </div>
		<div style="float:left; width:12%; text-align:right;"> VALOR        </div>
		<div style="float:left; width:8%;  text-align:right;"> D.PAGAMENTO  </div>
	</div>
		<?php

	foreach($documentos[1] as $documento){

		if($i % 2 == 0){
			$backCor = "#EFEEED";
		}else{
			$backCor = "#fff";
		}
		?>
			<div style="float:left; width:100%; background-color:<?php echo $backCor; ?>;  padding:2px 0px 0px 0px;">
				<div style="float:left; width:8%;  text-align:left;">  <?php echo $tipoDocumento ?> &nbsp</div>
				<div style="float:left; width:11%; text-align:right; padding-right: 15%"> <?php echo $documento->numero ?> &nbsp</div>
				<div style="float:left; width:20%; text-align:left;">  <?php echo substr($documento->cliente,0,25) ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_inclusao) ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_vencimento) ?> &nbsp</div>
				<div style="float:left; width:12%; text-align:right;"> <?php echo $documento->valor_total ?> &nbsp</div>
				<div style="float:left; width:8%;  text-align:right;"> <?php echo data($documento->data_pagamento) ?> &nbsp</div>
			</div>
		<?php
	}
	?>
	<div class="informacaoRodape">
		<!-- <div style="float:left;width:35%; ">Total <?php echo $totalDoctos." Documento(s) &nbsp"?></div> -->
		<div style="float:left;width:20%; text-align:right;">TOTAL A PAGAR <?php echo valorFormat($doc_previsto_pagar)."&nbsp"?></div>
		<div style="float:left;width:20%; text-align:right; ">TOTAL A RECEBER <?php echo valorFormat($doc_previsto_receber)."&nbsp"?></div>
		<div style="float:left;width:20%; text-align:right;">TOTAL PAGO <?php echo valorFormat($doc_pago)."&nbsp"?></div>
		<div style="float:left;width:20%; text-align:right;">TOTAL RECEBIDO <?php echo valorFormat($doc_recebido);?></div>
	</div>
<?php
	include '../rel/inc/relatorioRodape.php';

?>