<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	$Datapacket = new TParams();
	$Datapacket->debug(true);
	$Datapacket->clear();

	$company = array();
	$company[0] = $Datapacket->getCompany();

	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$cta_codigo = "%";
	$conta = "TODAS";
	if($dados->{'cta_codigo'}!=""){
		$cta_codigo = $dados->{'cta_codigo'};
	}

	$data_ini = date("Y-m-d");
	if(isset($dados->{'data_ini'})&&!empty($dados->{'data_ini'})){
		$data_ini = data($dados->{'data_ini'},true, '/');
	}

	$data_fim = date("Y-m-d");
	if(isset($dados->{'data_fim'})&&!empty($dados->{'data_fim'})){
		$data_fim = data($dados->{'data_fim'},true, '/');
	}

	$conciliado = "%%";
	if(isset($dados->{'conciliado'})&&!empty($dados->{'conciliado'})){
		if($dados->{'conciliado'} == "sim" ){
			$conciliado = 1;
		}else if ($dados->{'conciliado'} == "nao"){
			$conciliado = 0;
		}
	}

	$filtro = '{"cod":"501180", "params":[
		{"name":"data_ini","value":"'.$data_ini.' 00:00:00","type":"string"},
		{"name":"data_fim","value":"'.$data_fim.' 23:59:59","type":"string"},
		{"name":"cta_codigo","value":"'.$cta_codigo.'","type":"string"},
		{"name":"lan_conc","value":"'.$conciliado.'","type":"string"},
		{"name":"database","value":"'.$company[0]->{'emp_db_comum'}.'","type":"other"}
	]}';
	$Datapacket->setHost($Datapacket->getHost($company[0]->{'emp_db_sge'}));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	if($cta_codigo != "%" && count($rowdata)>0){
		$conta = $rowdata[0]->{'cta_descr'};
	}

	$filtroSaldo = '{"cod":"500151","params":[
		{"name":"cta_codigo","value":"like \''.$cta_codigo.'\'","type":"other"},
		{"name":"lan_conc","value":"like \''.$conciliado.'\'","type":"other"}
	]}';
	$Datapacket->setHost($Datapacket->getHost($company[0]->{'emp_db_sge'}));
	$Datapacket->add($filtroSaldo);
	$rowdataSaldo = $Datapacket->open(true);
	// echo $Datapacket->getLastQuery();
	$Datapacket->clear();
	$saldoDisp = $rowdataSaldo[0]->saldo;

	$titulo = utf8_decode("RELATÓRIO DE LANÇAMENTOS EM CONTA");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $Datapacket->getCompany()->{"emp_codigo"} . "/" . $Datapacket->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");

	$filtros = array(
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;"> CONTA: '.$conta.' |</span></div>'),
		base64_encode('<div style="float:left; padding-right:1%;"><span style="font-weight:bold;"> PER&Iacute;ODO: de ' .data($data_ini).' at&eacute; '.data($data_fim).' </span></div>'),
	);

	$objColuna = new stdClass();

	$colunas = '';

	if($cnt > 0){

		$debito = array();
		$credito = array();
		$totalGeral = 0;
		$totalDebito = 0;	
		$totalCredito = 0;	

		foreach ($rowdata as $pes){
			if($pes->lan_dc == 1){
				array_push($debito, $pes);
			} elseif ($pes->lan_dc == 2) {
				array_push($credito, $pes);
			}
		}

		if(!empty($debito)){
			?>
			<div class="informacaoColuna" ">
				<div style="float:left; width:8%;  text-align:left ;">TIPO</div>
				<div style="float:left; width:15%; text-align:right;">DOC. NÚMERO</div>
				<div style="float:left; width:8%;  text-align:right; padding-right: 4%">DATA</div>
				<div style="float:left; width:12.5%; text-align:left;">CLIENTE</div>
				<div style="float:left; width:11%; text-align:right;">VENCIMENTO</div>
				<div style="float:left; width:15%; text-align:right;">VALOR RECEBIDO</div>
				<div style="float:left; width:22.5%; text-align:right;">HISTÓRICO</div>
			</div>
			<?php
			foreach ($debito as $i=>$pes){

				if($i % 2 == 0){
					$backCor = "#EFEEED";
				}else{
					$backCor = "#fff";
				}

				?>
				<div class="informacaoListagem">Débito:</div>

				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; border:0.5px solid #000; font-size:12px; margin-top:2px">
					<div style="width:8%;  float:left; text-align:left; padding-left: 0.5%"> <?php echo "&nbsp";?> </div>
					<div style="width:15%; float:left; text-align:right;"> <?php echo $pes->{'doc_numero'}."&nbsp";?> </div>
					<div style="width:8%;  float:left; text-align:right; padding-right: 4%"> <?php echo data($pes->{'doc_data'})."&nbsp";?> </div>
					<div style="width:12.5%; float:left; text-align:left;"> <?php echo substr($pes->{'cad_nomeraz'}."&nbsp",0,25);?> </div>
					<div style="width:11%; float:left; text-align:right;"> <?php echo data($pes->{'doc_dtvcto'})."&nbsp";?> </div>
					<div style="width:15%; float:left; text-align:right;"> <?php echo valorFormat($pes->{'lan_valor'})."&nbsp";?> </div>
					<div style="width:22.5%; float:left; text-align:right;"> <?php echo substr($pes->{'lan_historico'}."&nbsp",0,25);?> </div>
				</div>
				<?php

				$totalGeral += $pes->{'lan_valor'};
				$totalDebito += $pes->{'lan_valor'};
			}

		}
		?>
		<div class="informacaoRodape"> Total Débito:    
			<?php echo valorFormat($totalDebito, true)."&nbsp";?>
		</div>

		<?php

		if(!empty($credito)){	
			?>	
			<div class="informacaoColuna" ">
				<div style="float:left; width:8%;  text-align:left ;">TIPO</div>
				<div style="float:left; width:15%; text-align:right;">DOC. NÚMERO</div>
				<div style="float:left; width:8%;  text-align:right; padding-right:4%;">DATA</div>
				<div style="float:left; width:12.5%; text-align:left;">CLIENTE</div>
				<div style="float:left; width:11%; text-align:right;">VENCIMENTO</div>
				<div style="float:left; width:15%; text-align:right;">VAL RECEBIDO</div>
				<div style="float:left; width:22.5%; text-align:right;">HISTÓRICO</div>
			</div>

			<div class="informacaoListagem">Crédito:</div>

			<?php
			foreach ($credito as $i=>$pes){

				if($i % 2 == 0){
					$backCor = "#EFEEED";
				}else{
					$backCor = "#fff";
				}
				?>
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; border:0.5px solid #000; font-size:13px; margin-top:2px">
					<div style="width:8%;  float:left; text-align:left; padding-left: 0.5%"> <?php echo "&nbsp";?> </div>
					<div style="width:15%; float:left; text-align:right;"> <?php echo $pes->{'doc_numero'}."&nbsp";?> </div>
					<div style="width:8%;  float:left; text-align:right; padding-right: 4%"> <?php echo data($pes->{'doc_data'})."&nbsp";?> </div>
					<div style="width:12.5%; float:left; text-align:left;"> <?php echo substr($pes->{'cad_nomeraz'}."&nbsp",0,25);?> </div>
					<div style="width:11%; float:left; text-align:right;"> <?php echo data($pes->{'doc_dtvcto'})."&nbsp";?> </div>
					<div style="width:15%; float:left; text-align:right;"> <?php echo valorFormat($pes->{'lan_valor'})."&nbsp";?> </div>
					<div style="width:22.5%; float:left; text-align:right;"> <?php echo substr($pes->{'lan_historico'}."&nbsp",0,25);?> </div>
				</div>

				<?php

				$totalGeral += $pes->{'lan_valor'};
				$totalCredito += $pes->{'lan_valor'};

			}
		}
		$total = 0;

		$total = $totalCredito - $totalDebito;

		?>
		<div class="informacaoRodape" "> Total Crédito:  
			<?php echo valorFormat($totalCredito, true)."&nbsp";?>
		</div>

		<div class="informacaoRodape_outro">Saldo do Período:
			<?php echo valorFormat($total, true)."&nbsp";?> 
		</div>


		<div class="informacaoRodape_outro">Saldo Disponível em Caixa:
			<?php echo valorFormat($saldoDisp, true)."&nbsp";?>
		</div>

		<?php		

	} else {

		?>
		<div style="width:100%; float:left; margin:50px 0px 0px 0px; padding: 0px 0px; text-align:center">
			Não foram encontrados registros para sua pesquisa
		</div>
		<?php
	}

	include "../rel/inc/relatorioRodape.php";

?>