<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');

	include('../php/TParams.class.php');
	include('../php/funcoes.php');

	$datapacket = new TParams();
	$empresa = $datapacket->getCompany();

	if(!isset($_POST['dados']) || empty($_POST['dados'])){
		exit("erro de parametro");
	}

	$dados = json_decode(base64_decode($_POST['dados']));

	$log_data_ini = "1900-01-01 00:00:00";
	if(isset($dados->{'log_data_ini'})&&!empty($dados->{'log_data_ini'})){
		$log_data_ini = data($dados->{'log_data_ini'},true)." 00:00:00";
	}

	$log_data_fim = "3000-12-31 23:59:59";
	if(isset($dados->{'log_data_fim'})&&!empty($dados->{'log_data_fim'})){
		$log_data_fim = data($dados->{'log_data_fim'},true)." 23:59:59";
	}

	$cad_codigo = '%';
	if (isset($dados->{'cad_codigo'})&&!empty($dados->{'cad_codigo'})){
		$cad_codigo = $dados->{'cad_codigo'};
	}	

	$ordem = '';
	if (isset($dados->{'ordem'})&&!empty($dados->{'ordem'}) && ($dados->{"ordem"}) == 1){
		$ordem = 'b.cad_nomeraz';
	} else {
		$ordem = 'a.log_data';
	}

	$tipo = '';
	if (isset($dados->{'tipo'})&&!empty($dados->{'tipo'}) && ($dados->{'tipo'}) == 1){
		$tipo = 'asc';
	} else {
		$tipo = 'desc';
	}

	$log_tipo = '%';
	if (isset($dados->{'log_tipo'}) && !empty($dados->{'log_tipo'}) && ($dados->{'log_tipo'} == 7)) {
		$log_tipo = '%';
	} else {
		$log_tipo = $dados->{'log_tipo'};
	}

	$filtro = '{"cod":"501400", "params":[
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"},
		{"name":"log_data_ini","value":"'.$log_data_ini.'","type":"string"},
		{"name":"log_data_fim","value":"'.$log_data_fim.'","type":"string"},
		{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"},
		{"name":"log_tipo","value":"'.$log_tipo.'","type":"string"},
		{"name":"ordem","value":"'.$ordem.'","type":"other"},
		{"name":"tipo","value":"'.$tipo.'","type":"other"}
	]}';

	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$rowdata = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
	$cnt = $datapacket->getRecordCount();
	$datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE ALTERAÇÕES");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $empresa->emp_codigo . "/" . $empresa->emp_logo;

	include("./inc/relatorioCabecalho.php");

	$filtros = '';
	$colunas = '';				
	$clientes = array();
	foreach($rowdata as $registro){
		if (!isset($clientes[$registro->cad_codigo])) {
			$obj = new stdClass();
			$obj->{"cad_codigo"} = $registro->{"cad_codigo"};
			$obj->{"cad_nomeraz"} = $registro->{"funcionario"};
			$clientes[$registro->{"cad_codigo"}] = $obj;
		}
	}

	if($cnt > 0){
		$contador = 0;

		foreach ($clientes as $cliente) {

			?>
				<div class="informacaoListagem">

					<div style="float:left;width:30%; font-family:;"><?php echo $cliente->{'cad_nomeraz'}."&nbsp"?></div>

				</div>		

				<div class="informacaoColuna">
					<div style="float:left; width:20%; text-align:left;">CLIENTE</div>
					<div style="float:left; width:20%; text-align:left;">HORA DA OPERAÇÃO</div>
					<div style="float:left; width:20%; text-align:left;">OPERAÇÃO</div>
					<div style="float:left; width:20%; text-align:left;">MÓDULO</div>
					<div style="float:left; width:12%; text-align:right;">NÚMERO</div>
				</div>
			<?php
			
			foreach($rowdata as $i=>$log){

				if($log->{"cad_codigo"} == $cliente->{"cad_codigo"}){


					if($i % 2 == 0){
						$backCor = "#F7F7F7";
					}else{
						$backCor = "#fff";
					}
					
					?>

						<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>;">
							<div style="float:left; width:20%; text-align:left;padding-left:0.5%;"><?php echo $log->{'funcionario'}."&nbsp";?></div>
							<div style="float:left; width:20%; text-align:left; "><?php echo dataComHoras($log->{'log_data'})."&nbsp";?></div>
							<div style="float:left; width:20%; text-align:left;">&nbsp
								<?php 

									switch ($log->{'log_tipo'}) {
										case 1:
											echo "INCLUSAO";
											break;
										case 2:
											echo "EDICAO";
											break;
										case 3:
											echo "TRANSMISSAO";
											break;
										case 4:
											echo "IMPRESSAO";
											break;
										case 5:
											echo "CANCELAMENTO";
											break;
										case 6:
											echo "CORRECAO";
											break;
										case 7:
											echo "FATURAMENTO";
											break;
										case 8:
											echo "CONVERSAO";
											break;
									}	
								?>
							</div>

							<div style="float:left; width:20%; text-align:left; padding-left:0.5%;">&nbsp
								<?php 

									switch ($log->{'log_tipo'}) {
										case 1:
											echo "NFS-E";
											break;
										case 2:
											echo "NF";
											break;
										case 3:
											echo "CT-E";
											break;
										case 4:
											echo "CTT";
											break;
										case 5:
											echo "PED";
											break;
										case 6:
											echo "O.S";
											break;
										case 7:
											echo "CONSIGNADO";
											break;
										case 8:
											echo "PDV";
											break;
										case 9:
											echo "NFCE";
											break;
									}
								?>
							</div>

							<div style="float:left; width:12%; text-align:right;"><?php echo $log->{'log_nro'}."&nbsp";?></div>

						</div>

					<?php
				}
			}
		}
		?>
			<div class="informacaoRodape_outro" style="margin-top: 50px;">
			</div>
		<?php
	}else{

		?>
		<div style="float:left; width:100%; margin:50px 0px 10px 0px; padding:3px 0px; text-align:center;font-weight:bold">Nenhum Resultado para sua pesquisa</div>

		<?php
	}
	include "inc/relatorioRodape.php";

?>