<?php

	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	set_time_limit (20);
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));
	
	$ref_codigo = "";
	if(isset($dados->{'ref_codigo'}) && $dados->{'ref_codigo'} != "Novo Registro"){
		$ref_codigo = " and a.ref_codigo = ".$dados->{'ref_codigo'};
	}

	$grp_codigo = "";
	$grupo = "TODOS";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and c.grp_codigo = ".$dados->{'grupo'};
		$grupo = strtoupper($dados->{'grupo_descr'});
	}

	$sgp_codigo = "";
	$subgrupo = "TODOS";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and c.sgp_codigo = ".$dados->{'subgrupo'};
		$subgrupo = strtoupper($dados->{'subgrupo_descr'});
	}

	$not_data = "";
	$periodo = "TODOS";
	if(isset($dados->{'data_ini'})&&!empty($dados->{'data_ini'})){
		$not_data = " and b.not_data >= '".dataBd($dados->{'data_ini'})."'";	
		$periodo = "DE ".data($dados->{'data_ini'},false);
		if(isset($dados->{'data_fim'})&&!empty($dados->{'data_fim'})){
			$not_data .= " and b.not_data <= '".dataBd($dados->{'data_fim'})."'";	
			$periodo .= utf8_decode(" ATÉ ").data($dados->{'data_fim'},false);
		}
	}else{
		if(isset($dados->{'data_fim'})&&!empty($dados->{'data_fim'})){
			$not_data = " and b.not_data <= '".dataBd($dados->{'data_fim'})."'";	
			$periodo = utf8_decode("ATÉ ").data($dados->{'data_fim'},false);
		}
	}

	class NotasFiscais {
		private $notas;

		function __construct($args){
			$this->notas = $args;
		}

		function getNotas($ref_codigo){
			$array = array();
			foreach ($this->notas as $nota) {
				if($nota->{'ref_codigo'}==$ref_codigo){
					array_push($array, $nota->{'ref_codigo'}."%".$nota->{'not_entrsaida'}."%".$nota->{'cfo_codigo'}."%".$nota->{'cfo_tipo'}."%".$nota->{'not_numero'}."%".$nota->{'not_data'}."%".$nota->{'cad_nomeraz'}."%".$nota->{'itn_qtde'}."%".$nota->{'not_codigo'});
				}
			}
			return $array;
		}

		function getProdutos(){
			$array = array();
			foreach($this->notas as $nota){ 
				array_push($array, $nota->{'ref_codigo'}."%".$nota->{'itn_descr'}."%".$nota->{'ref_codbar'}."%".$nota->{'ref_propriedade'}."%".$nota->{'stk_qde'});
			}	
			return array_values(array_unique($array));
		}

	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	$filtro='{"cod":"700521","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"database","value":"'.$TParams->getDb().'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"not_data","value":"'.$not_data.'","type":"other"}
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	$cnt = $Datapacket->getRecordCount();
	// echo $Datapacket->getLastQuery();
	$Datapacket->clear();

	$titulo = utf8_decode("RELATÓRIO DE MOVIMENTO DE ESTOQUE");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 = base64_encode('<span style="font-weight:bold;"> '.utf8_decode("PERÍODO").': </span><span>' . utf8_decode($periodo) . ' |</span>');
	$filtro2 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("GRUPO").': </span>' . utf8_decode($grupo) . ' |</span>');
	$filtro3 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("SUBGRUPO").': </span>' . utf8_decode($subgrupo) . ' |</span>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3
	);
		
	$colunas = array();

	array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:left"> COD. PRODUTO </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:25%; text-align:left"> PRODUTO </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:11%; text-align:right;"> COD. BARRAS </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:11%; text-align:right;"> COD. AUXILIAR </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:10%; text-align:right;"> ESTOQUE </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:11%; text-align:right;"> ENTRADAS </div>'));
	array_push($colunas, base64_encode('<div style="float:left; width:11%; text-align:right;">'. utf8_decode("SAÍDAS").'</div>'));

	

	if($cnt > 0){

		$totalGeralProdutos = 0;
		$totalGeralEntradas = 0;
		$totalGeralSaidas = 0;

		$notas = new NotasFiscais($rowdata);
		unset($rowdata);

		$arrayProdutos = $notas->getProdutos();
		$totalGeralProdutos = count($arrayProdutos);

		foreach($arrayProdutos as $aux){

			$produto = explode("%", $aux);
			$produtoNotas = $notas->getNotas($produto[0]);

			?>

				<div class="informacaoListagem">

					<div style="float:left; width:10%; text-align:left;">   <?php echo $produto[0]."&nbsp"; ?></div>
					<div style="width:25%; float:left;text-align:left;"> <?php echo $produto[1]."&nbsp" ;?> </div>
					<div style="width:12%; float:left;text-align:right;"> <?php echo $produto[2]."&nbsp" ;?> </div>
					<div style="width:10%; float:left;text-align:right;"> <?php echo $produto[3]."&nbsp" ;?> </div>
					<div style="width:10%; float:left;text-align:right;"> <?php echo qtde($produto[4])."&nbsp" ;?> </div>

				</div>

			<?php

			foreach ($produtoNotas as $i=>$aux2) {
				$nota = explode("%", $aux2);

				if($i % 2 == 0){
	                $backCor = "#EFEEED";
	            }else{
	                $backCor = "#FFF";
	            }

				?>

					<div style="width:100%; float:left; margin:1px 0px; border: 0.5px solid #000; margin-left:10%; background-color:<?php echo $backCor; ?>">

						<div style="width:5%; float:left;"> 
							<?php 
								if($nota[3]==1){
									echo "Devolução";
								}else if($nota[1] == 1){
									echo "Entrada";
								}else if($nota[1] == 2){
									echo "Saida";
								}else{
									echo "&nbsp";
								}
							?> 
						</div>  <!-- not_etrsaida -->  

						<div style="width:7%; float:left; text-align:right; margin-right:6%"> <?php echo $nota[4]."&nbsp" ;?> </div>  <!-- not_numero -->
						<div style="width:10%; float:left;"> <?php echo data($nota[5])."&nbsp" ;?> </div>  <!-- not_data -->
						<div style="width:25%; float:left;"> <?php echo substr($nota[6],0,30)."&nbsp" ;?> </div>  <!-- cad_nomeraz -->
						<div style="width:15%; float:left; text-align:right;"> 
							<?php 
								if($nota[1]==1){
									echo qtde($nota[7]);
									$totalGeralEntradas += qtde($nota[7]);
								}else if($nota[1]==2){
									echo "&nbsp";
								}
							?> 
						</div>  <!-- itn_qtde -->
						<div style="width:12%; float:left; text-align:right;"> 
							<?php 
								if($nota[1]==1){
									echo "&nbsp";
								}else if($nota[1]==2){
									echo qtde($nota[7]);
									$totalGeralSaidas += qtde($nota[7]);
								}
							?> 
						</div>  <!-- itn_qtde -->

					</div>

				<?php
			}

			?>
				<div style="clear:both">&nbsp</div>
			<?php

		}

		?>
			<div class="informacaoRodape">	
				<div style="width:20%; float:left;"> TOTAIS do MOVIMENTO no Período: </div>
				<div style="width:20%; float:left;"> Quantidade de produtos (<?php echo $totalGeralProdutos ;?>) </div>
				<div style="width:20%; float:left;"> Total entradas (<?php echo $totalGeralEntradas ;?>) </div>
				<div style="width:20%; float:left;"> Total saídas (<?php echo $totalGeralSaidas ;?>) </div>
			</div>
		<?php

		
	}else{
		?>	
			<div style="width:100%; float:left; margin:0px 0px 0px 0px; text-align:center; font-weight:bold">					
				Nenhum registro para sua pesquisa!
			</div>
		<?php
	}
	
	include "../rel/inc/relatorioRodape.php";
	
?>