<?php
	set_time_limit(0);
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	//argumentos
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//produto
	$ref_codigo = "";
	if(!empty($dados->{'produto'}) && $dados->{'produto'} != "Novo Registro"){
		$aux = $dados->{'produto'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and a.ref_codigo in (".$aux2.")";	
	}

	// grupo
	$grp_codigo = "";
	$grupo = "TODOS";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and c.grp_codigo = ".$dados->{'grupo'};
		$grupo = strtoupper($dados->{'grupo_descr'});
	}

	// subgrupo
	$sgp_codigo = "";
	$subgrupo = "TODOS";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and c.sgp_codigo = ".$dados->{'subgrupo'};
		$subgrupo = strtoupper($dados->{'subgrupo_descr'});
	}

	//data inicial e final
	$stk_data = "";
	$periodo = "TODOS";
	if(isset($dados->{'data_ini'})){
		$stk_data = " and b.lot_vencto >= '".data($dados->{'data_ini'}, true, "-") ." 00:00:00'";	
		$periodo = "DE ".data($dados->{'data_ini'});
		if(isset($dados->{'data_fim'})){
			$stk_data .= " and b.lot_vencto <= '".data($dados->{'data_fim'}, true, "-")." 23:59:59'";	
			$periodo .= utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}else{
		if(isset($dados->{'data_fim'})){
			$stk_data = " and b.lot_vencto <= '".data($dados->{'data_fim'}, true, "-")." 23:59:59'";	
			$periodo = utf8_decode(" ATÉ ").data($dados->{'data_fim'});
		}
	}
	
	class SaldoStk {
		private $registros;
		private $total;
		private $codigo;

		function __construct($regis, $total){
			$this->registros = $regis;
			$this->total = $total;
		}

		public function getRegistros(){
			return $this->registros;
		}

		public function getProdutos(){
			$array = array();
			foreach ($this->registros as $prod) {
				array_push($array, '{"ref_codigo":"'.$prod->{'ref_codigo'}.'", "ref_descr":"'.$prod->{'ref_descr'}.'", "ref_codbar":"'.$prod->{'ref_codbar'}.'", "stk_qde":"'.$prod->{'stk_qde'}.'"}');
			}
			return array_values(array_unique($array));
		}

		public function getLotes($ref){
			$lotes = array();
			$prod = array();
			foreach ($this->registros as $aux) {
			    if ($aux->{'ref_codigo'} == $ref) {
		        	array_push($lotes, '{"lot_codigo":"'.$aux->{'lot_codigo'}.'", "stk_total_lote":"'.$aux->{'stk_total_lote'}.'", "lot_vencto":"'.$aux->{'lot_vencto'}.'", "lot_descr":"'.$aux->{'lot_descr'}.'"}'); 	
			    }
			}
			return $lotes;
		}
	}
	
	//consultas
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$datapacket->setHost($TParams->getHost("empresas"));
	$datapacket->add($filtroCompany);
	$company = $datapacket->open(true);
	$datapacket->clear();
	
	$filtro='{"cod":"700974","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtro);
	$retProd = $datapacket->open(true);
	$cntProd = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	//corpo relatório
	$titulo = utf8_decode("RELATÓRIO DE PRODUTOS POR LOTE");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 = base64_encode('<span style="font-weight:bold;"> '.utf8_decode("VALIDADE").': </span>' . $periodo);
	$filtro2 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("GRUPO").': </span>' . utf8_decode($grupo));
	$filtro3 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("SUBGRUPO").': </span>' . utf8_decode($subgrupo));
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3
	);
	
	$colunas = array();

	$saldoStk = new SaldoStk($retProd, $cntProd);
	$todosProdutos = $saldoStk->getProdutos();


	
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> COD. PRODUTO </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:left;"> PRODUTO </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:20%; text-align:right;"> COD. BARRAS </div>'));
		array_push($colunas, base64_encode('<div style="float:left; width:19%; text-align:right;"> ESTOQUE </div>'));
	

	if(count($todosProdutos) > 0){

		for($i=0;$i<count($todosProdutos);$i++){
		
			$prod = json_decode($todosProdutos[$i]);	
		
			if(isset($prod->{'ref_descr'})&&!empty($prod->{'ref_descr'})){
				
				if(isset($prod->{'stk_qde'})&&$prod->{'stk_qde'} > 0){
					
					?>
						<div style="width:100%; float:left; margin:0px 0px 20px 0px;">
							
							<div style="width:100%; float:left; margin:0px 0px 0px 0px;">
							
								<div style="width:100%;   float:left; padding:2px 0px; background-color:#e7e7e7">
									<div style="width:20%; float:left; text-align:left; padding-left: 0.5%"><?php echo $prod->{'ref_codigo'}; ?></div> 
									<div style="width:20%; float:left; text-align:left;"><?php echo substr($prod->{'ref_descr'},0,26); ?></div> 
									<div style="width:20%; float:left; text-align:right;"><?php echo $prod->{'ref_codbar'}; ?></div> 
									<div style="width:19%; float:left; text-align:right"><?php echo qtde($prod->{'stk_qde'}); ?></div> 
							
								</div>
							
							</div>

							<div style="width:100%; float:left; margin:0px 0px 0px 0px;">
								
								<?php
									
									$registros = $saldoStk->getLotes($prod->{'ref_codigo'});
									
									for($j=0;$j<count($registros);$j++){
										
										$lote = json_decode($registros[$j]);
										
										if($lote->{'stk_total_lote'} > 0){
											
											?>
												<div style="width:100%; float:left; padding:0px 0px; font-weight:bold; font-size:12px">
													
													<div style="width:25%; float:left;">Lote: <?php echo $lote->{'lot_descr'}; ?></div> 
													
													<div style="width:25%; float:left;">
														
														Validade: 
														
														<?php 
															if(isset($lote->{'lot_vencto'})&&!empty($lote->{'lot_vencto'})){
																echo data($lote->{'lot_vencto'}); 
															}else{
																echo "&nbsp";
															}
														?>
													</div> 
													
													<div style="width:25%; float:left;">Quantidade: <?php echo qtde($lote->{'stk_total_lote'}); ?></div> 
													
													<div style="width:25%; float:left;">lote codigo: <?php echo qtde($lote->{'lot_codigo'}); ?></div> 
												
												</div>
											
											<?php 
										}
									}
								?>

							</div>

						</div>

					<?php
				}
			}
		}
		
	}else{
		?>
			<div style="width:100%; float:left; padding:50px; text-align:center; font-weigth:bold">
				<span>Nenhum resultado para essa pesquisa!</span>
			</div>
		<?php
	}
	
	include "../rel/inc/relatorioRodape.php";
	
?>