<?php
	set_time_limit(0);
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	//argumentos
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//marca
	$mar_codigo = "";
	if(!empty($dados->{'marca'})){
		$aux = $dados->{'marca'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$mar_codigo = " and b.mar_codigo in (".$aux2.")";	
	}

	//produto
	$ref_codigo = "";
	if(!empty($dados->{'produto'}) && $dados->{'produto'} != "Novo Registro"){
		$aux = $dados->{'produto'};
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i == 0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and a.ref_codigo in (".$aux2.")";	
	}

	// grupo
	$grp_codigo = "";
	$grupo = "TODOS";
	if(isset($dados->{'grupo'}) && !empty($dados->{'grupo'}) && $dados->{'grupo'} != "Novo Registro"){
		$grp_codigo = " and a.grp_codigo = ".$dados->{'grupo'};
		$grupo = strtoupper($dados->{'grupo_descr'});
	}

	// subgrupo
	$sgp_codigo = "";
	$subgrupo = "TODOS";
	if(isset($dados->{'subgrupo'}) && !empty($dados->{'subgrupo'}) && $dados->{'subgrupo'} != "Novo Registro"){
		$sgp_codigo = " and a.sgp_codigo = ".$dados->{'subgrupo'};
		$subgrupo = strtoupper($dados->{'subgrupo_descr'});
	}

	//data inicial e final
	$stk_data = "";
	$periodo = "TODOS";
	if(isset($dados->{'data_ini'})){
		$stk_data = " and c.stk_data >= '".$dados->{'data_ini'}."'";	
		$periodo = "DE ".data($dados->{'data_ini'});
		if(isset($dados->{'data_fim'})){
			$stk_data .= " and c.stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo .= " ATÉ ".data($dados->{'data_fim'});
		}
	}else{
		if(isset($dados->{'data_fim'})){
			$stk_data = " and c.stk_data <= '".$dados->{'data_fim'}."'";	
			$periodo = "ATÉ ".data($dados->{'data_fim'});
		}
	}
	
	//ordenação
	$ordenacao = "";
	if($dados->{'ordenar'} == 0){
		$ordenacao = " order by a.ref_descr asc";
	}
	
	//consultas
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
	]}';
	$datapacket->setHost($TParams->getHost("empresas"));
	$datapacket->add($filtroCompany);
	$company = $datapacket->open(true);
	$datapacket->clear();
	
	$filtroDados='{"cod":"700970","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"database","value":"'.$company[0]->{'emp_db_sge'}.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtroDados);
	$ret = $datapacket->open(true);
	$cnt = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	$filtroDados='{"cod":"700971","params":[
		{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
		{"name":"database","value":"'.$company[0]->{'emp_db_sge'}.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"stk_data","value":"'.$stk_data.'","type":"other"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"sgp_codigo","value":"'.$sgp_codigo.'","type":"other"},
		{"name":"ordenacao","value":"'.$ordenacao.'","type":"other"}
	]}';
	$datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
	$datapacket->add($filtroDados);
	$retMarcas = $datapacket->open(true);
	$cntMarcas = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
	$datapacket->clear();

	//corpo relatório
	$titulo = utf8_decode("RELATÓRIO DE SALDO EM ESTOQUE VALORIZADO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 = base64_encode('<span style="font-weight:bold;"> '.utf8_decode("PERÍODO").': </span>' . utf8_decode($periodo));
	$filtro2 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("GRUPO").': </span>' . utf8_decode($grupo));
	$filtro3 = base64_encode('<span style="font-weight:bold; margin-left:50px"> '.utf8_decode("SUBGRUPO").': </span>' . utf8_decode($subgrupo));
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3
	);
	
	$objColumn = new stdClass();
	
	$colunas = '';

	?>
		<div class="informacaoColuna">
			<div style="float:left; width:5%;  text-align:left"> MARCA </div>
			<div style="float:left; width:13%; text-align:right; padding-right: 4%"> COD. PRODUTO </div>
			<div style="float:left; width:11%; text-align:left"> PRODUTO </div>
			<div style="float:left; width:8%;  text-align:right;"> COD. BARRAS </div>
			<div style="float:left; width:10%; text-align:right;"> COD. FAB. </div>
			<div style="float:left; width:10%;  text-align:right;"> ESTOQUE </div>
			<div style="float:left; width:9%;  text-align:right;"> VENDA UNITÁRIO </div>
			<div style="float:left; width:10%; text-align:right;"> VENDA TOTAL </div>
			<div style="float:left; width:9%;  text-align:right;"> CUSTO UNITÁRIO </div>
			<div style="float:left; width:10%; text-align:right;"> CUSTO TOTAL </div>
		</div>

<?php

	if($cnt > 0){

		$venda = 0;
		$custo = 0;
		$totalVenda = 0;
		$totalCusto = 0;
		$totalProdutos = 0;
		$totaGeralVenda = 0;
		$totaGeralCusto = 0;
		$totaGeralProdutos = 0;

		for($i=0;$i<$cntMarcas;$i++){

			$l=0;
			for($j=0;$j<$cnt;$j++){

				if($l%2==0){
					$backCor = "#E6E7E9";
				}else{
					$backCor = "#FFF";
				}

				if($retMarcas[$i]->{'mar_codigo'} == $ret[$j]->{'mar_codigo'}){
					
					$venda = ($ret[$j]->{'ref_preco'}*$ret[$j]->{'stk_qde'} > 0) ? floatval(intval($ret[$j]->{'ref_preco'}*$ret[$j]->{'stk_qde'} * 100) / 100) : 0;
					$custo = ($ret[$j]->{'cus_repos'}*$ret[$j]->{'stk_qde'} > 0) ? floatval(intval($ret[$j]->{'cus_repos'}*$ret[$j]->{'stk_qde'} * 100) / 100) : 0;

					?>
						<div style="width:100%; float:left; padding:1px 5px; margin: 0px 0px 2px 0px; background-color:<?php echo $backCor;?>">
							
							<div style="width:5%; float:left; text-align: left;font-weight:bold;">
								<?php 
									if($l == 0){
										echo $retMarcas[$i]->{'mar_descr'};
									}else{
										echo "&nbsp";
									}
								?>
							</div>

							<div style="width:13%; float:left; text-align:right; padding-right: 4%">
								<?php echo ($ret[$j]->{'ref_codigo'})?$ret[$j]->{'ref_codigo'}:'&nbsp'; ?>
							</div>
							
							<div style="width:11%; float:left; text-align:left;">
								<?php echo substr(($ret[$j]->{'ref_descr'})?$ret[$j]->{'ref_descr'}:'&nbsp',0,21); ?>
							</div>

							<div style="width:8%; float:left; text-align: right;">
								<?php echo ($ret[$j]->{'ref_codbar'})?$ret[$j]->{'ref_codbar'}:'&nbsp'; ?>
							</div>

							<div style="width:10%; float:left; text-align:right;">
								<?php echo ($ret[$j]->{'ref_propriedade'})?$ret[$j]->{'ref_propriedade'}:'&nbsp'; ?>
							</div>

							<div style="width:10%; float:left; text-align:right;">
								<?php echo ($ret[$j]->{'stk_qde'})?qtde($ret[$j]->{'stk_qde'}):'&nbsp'; ?>
							</div>

							<div style="width:9%; float:left; text-align:right;">
								<?php echo valorFormat($ret[$j]->{'ref_preco'}) ;?>
							</div>

							<div style="width:10%; float:left; text-align:right;">
								<?php echo valorFormat($venda);?>
							</div>

							<div style="width:9%; float:left; text-align:right;">
								<?php echo valorFormat($ret[$j]->{'cus_repos'}) ;?>
							</div>

							<div style="width:10%; float:left; text-align:right;">
								<?php echo valorFormat($custo) ;?>
							</div>

						</div>
					<?php
					$l++;
					$totalProdutos++;
					$totalVenda += $venda;
					$totalCusto += $custo;
				}	
			}
			?>	
				<div class="informacaoRodape">
					<div style="width:51%; float:left;">
						Total Produtos (<?php echo $totalProdutos;?>)
					</div>
					<div style="width:21%; float:left; text-align:right;">
						<?php echo valorFormat($totalVenda);?>
					</div>
					<div style="width:10%; float:left; text-align:right; padding-left:8% ">
						<?php echo valorFormat($totalCusto);?>
					</div>
				</div>
			<?php
			$totaGeralVenda += $totalVenda;
			$totaGeralCusto += $totalCusto;
			$totaGeralProdutos += $totalProdutos;
			$totalVenda = 0;
			$totalCusto = 0;
			$totalProdutos = 0;
		}
		?>	
			<div class="informacaoRodape_outro">
				<div style="width:55%; float:left;">
					Total Geral Produtos (<?php echo $totaGeralProdutos;?>)
				</div>
				<div style="width:25%; float:left; text-align:center">
					<?php echo valorFormat($totaGeralVenda);?>
				</div>
				<div style="width:10%; float:left; text-align:right">
					<?php echo valorFormat($totaGeralCusto);?>
				</div>
			</div>
		<?php
	}else{
		?>
			<div style="width:100%; float:left; padding:50px; text-align:center; font-weigth:bold">
				<span>Nenhum resultado para essa pesquisa!</span>
			</div>
		<?php
	}
	
	include "../rel/inc/relatorioRodape.php";
	
?>