<?php
set_time_limit(0);
error_reporting(E_ALL);

ob_start();
date_default_timezone_set("America/Sao_Paulo");
setlocale(LC_ALL, 'pt_BR');

include_once '../php/datapacket.php';
include_once '../php/TParams.class.php';
include_once '../php/funcoes.php';

$datapacket = new datapacket();
$datapacket->debug(true);
$TParams = new TParams();

	//argumentos
$dados  = json_decode(base64_decode($_REQUEST['dados']));

	//produto
$ref_codigo = "";
if(!empty($dados->{'produto'}) && $dados->{'produto'} != "Novo Registro"){
	$aux = $dados->{'produto'};
	$aux2 = "";
	for($i=0;$i<count($aux);$i++){
		if($i == 0){
			$aux2 .= $aux[$i]; 
		}else{
			$aux2 .= ", ".$aux[$i]; 
		}
	}
	$ref_codigo = " and a.ref_codigo in (".$aux2.")";	
}

	//lote
$lot_codigo = "";
if(!empty($dados->{'lote'}) && $dados->{'lote'} != "Novo Registro"){
	$aux = $dados->{'lote'};
	$aux2 = "";
	for($i=0;$i<count($aux);$i++){
		if($i == 0){
			$aux2 .= "'".$aux[$i]."'"; 
		}else{
			$aux2 .= ", '".$aux[$i]."'"; 
		}
	}
	$lot_codigo = " and a.lot_codigo in (".$aux2.")";	
}

if(!empty($dados->{'not_entrsaida'}) && $dados->{'not_entrsaida'} != "Novo Registro"){
	$not_entrsaida = $dados->{'not_entrsaida'};
}

class Notas{
	private $notas;

	function __construct($args){
		$this->notas = $args;
	}

	function getLotes($ref_codigo){
		$arr = array();
		foreach ($this->notas as $notas) {
			if($notas->{'ref_codigo'} == $ref_codigo){
				array_push($arr, $notas->{'lot_codigo'}."%".$notas->{'lot_descr'}."%".$notas->{'lot_vencto'});
			}
		}
		return array_unique($arr);
	}

	function getTotalItens($ref, $lot){
		$total = 0;
		foreach ($this->notas as $nota) {
			if($nota->{'ref_codigo'} == $ref && $nota->{'lot_codigo'} == $lot){
				$total += $nota->{'itn_qtde'};
			}
		}
		return $total;
	}

	function getTotalNotas($ref, $lot){
		$total = 0;
		foreach ($this->notas as $nota) {
			if($nota->{'ref_codigo'} == $ref && $nota->{'lot_codigo'} == $lot){
				$total++;
			}
		}
		return $total;
	}

	function getNotas($ref, $lot){
		$arr = array();
		foreach ($this->notas as $nota) {
			if($nota->{'ref_codigo'} == $ref && $nota->{'lot_codigo'} == $lot){
				array_push($arr, $nota);
			}
		}
		return $arr;
	}
}

	//consultas
$filtroCompany = '{"cod":"600001","params":[
{"name":"emp_codigo","value":"'.$dados->{'emp_codigo'}.'","type":"string"}
]}';
$datapacket->setHost($TParams->getHost("empresas"));
$datapacket->add($filtroCompany);
$company = $datapacket->open(true);
$datapacket->clear();

$filtro='{"cod":"500880","params":[
{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
{"name":"database","value":"'.$TParams->getDb().'","type":"other"},
{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"other"}
]}';
$datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
$datapacket->add($filtro);
$rowdata = $datapacket->open(true);
$cnt = $datapacket->getRecordCount();
	// echo $datapacket->getLastQuery();
$datapacket->clear();

$filtro1='{"cod":"500881","params":[
{"name":"emp_codigo","value":"'.$company[0]->{'emp_codigo'}.'","type":"string"},
{"name":"database","value":"'.$TParams->getDb().'","type":"other"},
{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
{"name":"not_entrsaida","value":"'.$not_entrsaida.'","type":"integer"},
{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"other"}
]}';
$datapacket->setHost($TParams->getHost($company[0]->{'emp_db_sge'}));
$datapacket->add($filtro1);
$rowdataProd = $datapacket->open(true);
	// echo $datapacket->getLastQuery();
$datapacket->clear();

$notas = new Notas($rowdata);
unset($rowdata);

	//corpo relatório
$titulo = utf8_decode("RELATÓRIO DE RASTREAMENTO DE PRODUTOS POR LOTE (NF-e DE SAÍDA)");
$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
include("inc/relatorioCabecalho.php");

$filtros = "";

$colunas = '';	

?>
<div class="informacaoColuna">
	<div style="float:left; width:20%; text-align:left;"> PRODUTO </div>
	<div style="float:left; width:20%; text-align:right;"> COD. BARRAS </div>
	<div style="float:left; width:20%; text-align:right;"> TOTAL NOTAS </div>
	<div style="float:left; width:15%; text-align:right;"> QTD. NAS NOTAS </div>
	<div style="float:left; width:20%; text-align:right;"> ESTOQUE </div>
</div>
<?php

if($cnt > 0){

	foreach ($rowdataProd as $prod) {

		$lotes = $notas->getLotes($prod->{'ref_codigo'});

		foreach($lotes as $lot){
			$aux = explode("%", $lot);

			?>
			<div style="width:100%; float:left; padding:2px 0px; margin:0px 0px 20px 0px ">

				<div class="informacaoListagem">

					<div style="width:20%; float:left; text-align: left;"><?php echo substr($prod->{'ref_descr'},0,35)."&nbsp"; ?></div>
					<div style="width:20%; float:left; text-align: right;"><?php echo $prod->{'ref_codbar'}."&nbsp"; ?></div>
					<div style="width:20%; float:left; text-align: right;"><?php echo qtde($notas->getTotalNotas($prod->{'ref_codigo'}, $aux[0]))."&nbsp"; ?></div>
					<div style="width:15%; float:left; text-align: right;"><?php echo qtde($notas->getTotalItens($prod->{'ref_codigo'}, $aux[0]))."&nbsp"; ?></div>
					<div style="width:20%; float:left; text-align: right"><?php echo qtde($prod->{'total_stk'})."&nbsp"; ?></div>
				</div>

				<div style="width:15%; float:left; text-align:left;"><span style="font-weight:bold">Lote:</span><?php echo substr($aux[1],0,20)."&nbsp"; ?></div>
				<div style="width:10%; float:left; text-align:left;">
					<?php 
					if(isset($aux[2])&&!empty($aux[2])){
						echo data($aux[2])."&nbsp"; 
					}else{
						echo "&nbsp";
					}

					?>
				</div>
				<?php
				foreach($notas->getNotas($prod->{'ref_codigo'}, $aux[0]) as $not){
					?>
					<div class="informacaoRodape_outro">
						<div style="width:17%; float:left; text-align:left;"> Nº nota: <?php echo $not->{'not_numero'}."&nbsp"; ?></div>
						<div style="width:18%; float:left;"> Data: <?php echo data($not->{'not_data'})."&nbsp"; ?></div>
						<div style="width:20%; float:left; text-align:left"> Cliente: <?php echo substr($not->{'cad_nomeraz'}."&nbsp",0,30); ?></div>
						<div style="width:20%; float:left; text-align:right;"><?php echo qtde($not->{'itn_qtde'})."&nbsp"; ?></div>
					</div>
					<?php
				}
				?>
			</div>
			<?php
		}	
	}	

}else{
	?>
	<div style="width:100%; float:left; padding:50px; text-align:center; font-weigth:bold">
		<span>Nenhum resultado para essa pesquisa!</span>
	</div>
	<?php
}

include "../rel/inc/relatorioRodape.php";

?>