<?php
	
	header('Content-Type: text/html; charset=utf-8');
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	set_time_limit (300);
	ob_start();

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new TParams();
	$company = array($datapacket->getCompany());
	
	// selecionar doctos da remessa
	$filtroRemessa = '{"cod":"700738","params":[
		{"name":"database","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"rem_codigo","value":"'.$_REQUEST["rem_codigo"].'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($company[0]->emp_db_sge));
	$datapacket->add($filtroRemessa);
	$rowdata = $datapacket->open(true);
	$cntRet = $datapacket->getRecordCount();
	$datapacket->clear();
	
	/* BANCOS - buscar o banco selecionado dentre os bancos da empresa */
	$bancos = json_decode(base64_decode($company[0]->emp_bancos));
	foreach($bancos as $ban){
		$ban = (array) $ban;
		if($ban["carteira"]==$rowdata[0]->{'doc_carteira'}){
			$banco = $ban;
		}
	}
	
	//finalidade da remessa
	if( isset($_REQUEST["rem_movimento"]) ){
		$rem_movimento=$_REQUEST["rem_movimento"];
	}else{
		$rem_movimento=1;
	}
	
	switch($rem_movimento){
		case 1:
			$fin = "Registro de títulos no Banco";
			break;
		case 2:
			$fin = "Solicitação de Baixa de título";
			break;
		case 6:
			$fin = "Alteração de Vencimento";
			break;
		default:
			$fin = "Registro de títulos no Banco";
			break;
	}

	/*
	 * * CABECALHO DOS RELATORIOS
 	*/
	$titulo = utf8_decode("RELATÓRIO DE REMESSA DE BOLETOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $company[0]->{"emp_codigo"} . "/" . $company[0]->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	$filtros = '';
	$colunas = '';
	$cabecalhoHeight = 200;
	
	?>
	
	<div style="width:100%; margin:20px 0px 20px 0px; float:left;">
		
		<div style="margin:0px 0px 10px 0px; width:100%; float:left; border-bottom:1px solid #1A1A1A; font-size:13px;">
			
			<span style="float:left; width:100%; font-weight:bold;font-size:18px">
				FINALIDADE DA REMESSA: <?php echo $fin ?><br>
				REMESSA NÚMERO <?php echo $_REQUEST["rem_codigo"]?> - BANCO: <?php echo $banco["banco_nome"]; ?> -
				AGÊNCIA: <?php echo $banco["agencia"]; ?> 
				CONTA: <?php echo $banco["conta"]; ?> 
				CARTEIRA: <?php echo $banco["carteira"]; ?>
			</span>

		</div>	

	</div>
	
	<div style="width:100%; float:left; border-top:1px solid #1A1A1A; border-bottom:1px solid #1A1A1A;">
		<div style="width:8%; float:left; text-align:left; font-weight:bold;"> NÚMERO </div>
		<div style="width:12%; float:left; text-align:left; font-weight:bold; text-align:center;"> NOSSO NÚMERO </div>
		<div style="width:28%; float:left; text-align:left; font-weight:bold;"> CLIENTE </div>
		<div style="width:8%; float:left; text-align:left; font-weight:bold; text-align:center;"> EMISSÃO </div>
		<div style="width:8%; float:left; text-align:left; font-weight:bold; text-align:center;"> VENCIMENTO </div>
		<div style="width:8%; float:left; text-align:left; font-weight:bold; text-align:center;"> VALOR R$ </div>
		<div style="width:25%; float:left; text-align:left; font-weight:bold;"> OBS </div>
	</div>
	
	<?php

	if($cntRet> 0){
		
		$totalPago="";
		$total="";
		
		for ($i = 0; $i < $cntRet; $i++) {
			
			$numero = $rowdata[$i]->{'doc_numero'};
			$nossoNumero = $rowdata[$i]->{'doc_nossonumero'};
			$cliente = $rowdata[$i]->{'cliente'};
			$emissao = $rowdata[$i]->{'doc_data'};
			$vcto = $rowdata[$i]->{'doc_dtvcto'};
			$valor = $rowdata[$i]->{'doc_valor'};
			$pgto = $rowdata[$i]->{'doc_dtpgto'};
			$valPagto = $rowdata[$i]->{'doc_valorpg'};
			$obs = $rowdata[$i]->{'doc_descr'};

			/*
			 * * LINHAS ZEBRADAS
			 */
			if ($i % 2 == 0) {
				$backCor = "#e7e7e7";
			} else {
				$backCor = "#FFF";
			}

			/*
			 * * SOMAR VALORES PARA O TOTAL
			 */
			$totalPago += $valPagto;
			$total += $valor;
		    
		    ?>
		    
		    <div style="width:100%; float:left; background-color:<?php echo $backCor; ?>">
		        <div style="width:8%; float:left; text-align:left; "> <?php echo substr($numero, 0, 17) . "&nbsp;"; ?> </div>
		        <div style="width:12%; float:left; text-align:left; text-align:center;"> <?php echo $nossoNumero . "&nbsp;"; ?> </div>
				<div style="width:28%; float:left; text-align:left; "> <?php echo substr($cliente, 0, 35) . "&nbsp;"; ?> </div>
				<div style="width:8%; float:left; text-align:left; text-align:center; "> <?php echo substr(data($emissao), 0, 10) . "&nbsp;"; ?> </div>
				<div style="width:8%; float:left; text-align:left; text-align:center; "> <?php echo substr(data($vcto), 0, 10) . "&nbsp;"; ?> </div>
				<div style="width:8%; float:left; text-align:left; text-align:center;"><?php if($valor > 0){ echo number_format($valor, 2, ',', '.'); }else{ echo "0,00"; } ?></div>
				<div style="width:25%; float:left; text-align:left; "> <?php echo substr($obs, 0, 35) . "&nbsp;"; ?> </div>
		    </div>
		    
		    <?php
		}

		?>
			<div style="width:250px; margin:20px 0px 0px 0px; float:right; text-align:right;">
		
				<b> VALOR TOTAL R$ </b>: <?php echo number_format($total, 2, ',', '.'); ?>
		
			</div>
			<div style="width:250px; margin:20px 0px 0px 0px; float:right; text-align:right;">
		
				<b> TOTAL TÍTULOS</b>: <?php echo $i; ?>
		
			</div>
		<?php
	
	}else{ 
	
		?>
			<div style="width:100%; float:left; margin:50px 0px 0px 0px; font-weight:bold; text-align:center;">
		
				NENHUM REGISTRO ENCONTRADO!
		
			</div>
		
		<?php 

	}
	
	include "../rel/inc/relatorioRodape.php";
?>