<?php
	header('Content-Type: text/html; charset=utf-8');
	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	set_time_limit (300);

	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';
	
	$datapacket = new TParams();
	$company = array($datapacket->getCompany());
	
	$filtroRetorno = '{"cod":"700751","params":[
		{"name":"database","value":"'.$company[0]->{"emp_db_comum"}.'","type":"other"},
		{"name":"ret_codigo","value":"'.$_REQUEST["ret_codigo"].'","type":"integer"}
	]}';
	$datapacket->setHost($datapacket->getHost($company[0]->{"emp_db_sge"}));
	$datapacket->add($filtroRetorno);
	$rowdata = $datapacket->open(true);
	$cntRet= $datapacket->getRecordCount();
	$datapacket->clear();

	/*
	 * * CABECALHO DOS RELATORIOS
	 */
	$titulo = utf8_decode("RELATÓRIO DE RETORNO DE BOLETOS");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $company[0]->{"emp_codigo"} . "/" . $company[0]->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	$filtros = '';
	$colunas = '';
	$cabecalhoHeight = 200;

	if($cntRet > 0){
	
		/*	BANCOS - buscar o banco selecionado dentre os bancos da empresa */
		$bancos = json_decode(base64_decode($company[0]->{"emp_bancos"}));
		foreach($bancos as $ban){
			$ban = (array) $ban;
			if($ban["carteira"]==$rowdata[0]->{'doc_carteira'}){
				$banco = $ban;
			}
		}

		?>
			
			<div style="width:100%; margin:20px 0px 20px 0px; float:left;">
				<div style="margin:0px 0px 10px 0px; width:100%; float:left; border-bottom:1px solid #1A1A1A; font-size:13px;">
					<span style="float:left; width:60%; font-weight:bold;">
						<?php 
							echo utf8_encode(utf8_decode('RETORNO NÚMERO')); 
							echo $_REQUEST["ret_codigo"]
						?> 
						- 
						<?php 
							echo $banco["banco_nome"]; 
							echo utf8_encode(utf8_decode('AGÊNCIA:')); 
							echo $banco["agencia"]; 
						?> 
						CONTA: 
						<?php 
							echo $banco["conta"]; 
						?> 
						CARTEIRA 
						<?php 
							echo $banco["carteira"]; 
						?>
					</span>
				</div>	
			</div>
			
			<div style="width:100%; float:left; border-top:1px solid #1A1A1A; border-bottom:1px solid #1A1A1A;">
				<div style="width:9%; float:left; text-align:left; font-weight:bold;">
					<?php
						echo utf8_encode(utf8_decode('NÚMERO'));
					?>
				</div>
				<div style="width:12%; float:left; text-align:left; font-weight:bold;">
					<?php
						echo utf8_encode(utf8_decode('NOSSO NÚMERO'));
					?>
				</div>
				<div style="width:20%; float:left; text-align:left; font-weight:bold;">
					CLIENTE
				</div>
				<div style="width:8%; float:left; text-align:center; font-weight:bold;">
					VENCIMENTO
				</div>
				<div style="width:8%; float:left; text-align:center; font-weight:bold;">
					PAGAMENTO
				</div>
				<div style="width:10%; float:left; text-align:left; font-weight:bold;">
					VALOR R$
				</div>
				<div style="width:10%; float:left; text-align:left; font-weight:bold;">
					V. PAGO R$
				</div>
				<div style="width:10%; float:left; text-align:left; font-weight:bold;">
					TARIFA R$
				</div>
				<div style="width:13%; float:left; text-align:left; font-weight:bold;">
					OBS BANCO
				</div>
			</div>
			
		<?php

		$totalPago="";
		$totalTaxa="";
		$total="";
		$ant="";
		
		for ($i = 0; $i < $cntRet; $i++) {
		
			$numero = $rowdata[$i]->{'doc_numero'};
			$nossoNumero = $rowdata[$i]->{'doc_nossonumero'};
			$cliente = $rowdata[$i]->{'cliente'};
			$emissao = $rowdata[$i]->{'doc_data'};
			$vcto = $rowdata[$i]->{'doc_dtvcto'};
			$taxa = $rowdata[$i]->{'doc_taxa'};
			$valor = $rowdata[$i]->{'doc_valor'};
			$pgto = $rowdata[$i]->{'doc_dtpgto'};
			$valPagto = $rowdata[$i]->{'doc_valorpg'};
			$obs = $rowdata[$i]->{'doc_ocorrencia'};

			/*
			 * * LINHAS ZEBRADAS
			*/
			if ($i % 2 == 0) {
				$backCor = "#e7e7e7";
			} else {
				$backCor = "#FFF";
			}
			
			/*
			 * * SOMAR VALORES PARA O TOTAL, SOMENTE PARA DOCUMENTOS DIFERENTES, IGNORAR OCORRÊNCIAS IGUAIS PARA UM MESMO DOCUMENTO
			 */
			if($ant!=$numero){
				$totalPago += $valPagto;
				$total += $valor;
				$ant = $numero;
			}
			
			$totalTaxa += $taxa;
			
		    ?>
				<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>">
					<div style="width:9%; float:left; text-align:left;">
						<?php echo substr($numero, 0, 17) . "&nbsp;"; ?>
					</div>
					<div style="width:12%; float:left; text-align:left;">
						<?php echo $nossoNumero . "&nbsp;"; ?>
					</div>
					<div style="width:20%; float:left; text-align:left;">
						<?php echo substr($cliente, 0, 25) . "&nbsp;"; ?>
					</div>
					<div style="width:8%; float:left; text-align:center;">
						<?php echo substr(data($vcto), 0, 10) . "&nbsp;"; ?>
					</div>
					<div style="width:8%; float:left; text-align:center;">
						<?php echo ($valPagto > 0 && $taxa >= 0) ? substr(data($pgto), 0, 10) . "&nbsp;" : "-&nbsp;"; ?>
					</div>
					<div style="width:10%; float:left; text-align:left;">
						<?php if($valor > 0){ echo number_format($valor, 2, ',', '.'); }else{ echo "0,00"; } ?>
					</div>
					<div style="width:10%; padding-right:0.4% ; float:left; text-align:left;">
						<?php if($valPagto > 0 && $taxa >= 0){ echo number_format($valPagto, 2, ',', '.'); }else{ echo "-"; } ?>
					</div>
					<div style="width:8%; float:left; text-align:left;">
						<?php if($taxa > 0){ echo number_format($taxa, 2, ',', '.'); }else{ echo "-"; } ?>
					</div>
					<div style="width:12.8%; float:left; text-align:left;">
						<?php echo substr($obs, 0, 27) . "&nbsp;"; ?>
					</div>
				</div>
	    	<?php
		}
	
	}else{ 

		?>
			<div style="width:100%; float:left; margin:250px 0px 0px 0px; font-size: 50px; font-weight:bold; text-align:center;">
				NENHUM REGISTRO ENCONTRADO!
			</div>
		<?php 
	}
	
	if ($cntRet!= "") {

		?>
			<div style="float:left;width:46.3%;">&nbsp;</div>
		
			<div style="width:12%; margin:20px 0px 0px 0px; text-align:right; float:left;">
				<b>TOTAL R$</b>: 
				<?php
					echo ($total>0) ? number_format($total, 2, ',', '.') : "0,00";
				?>
			</div>

			<div style="width:10.2%; margin:20px 0px 0px 0px; text-align:right; float:left;">
				<b>TOTAL PAGO R$</b>: 
				<?php
					echo ($totalPago>0) ? number_format($totalPago, 2, ',', '.') : "0,00";
				?>
			</div>

			<div style="width:10.2%; margin:20px 0px 0px 0px; text-align:right; float:left;">
				<b>TOTAL TARIFAS R$</b>: 
				<?php
					echo ($totalTaxa>0) ? number_format($totalTaxa, 2, ',', '.') : "0,00";
				?>
			</div>

		<?php
	}

	include "../rel/inc/relatorioRodape.php";
?>