<?php
	error_reporting(E_ALL);

	ob_start();
	date_default_timezone_set("America/Sao_Paulo");
	setlocale(LC_ALL, 'pt_BR');
	
	include_once '../php/datapacket.php';
	include_once '../php/TParams.class.php';
	include_once '../php/funcoes.php';

	
	$Datapacket = new datapacket();
	$Datapacket->debug(true);
	$TParams = new TParams();
	
	$dados  = json_decode(base64_decode($_REQUEST['dados']));

	$grp_codigo = "";
	if(isset($dados->grupo) && !empty($dados->grupo)){
		$aux = $dados->grupo;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$grp_codigo = " and c.grp_codigo in (".$aux2.")";
	}

	$mar_codigo = "";
	if(isset($dados->marca) && !empty($dados->marca)){
		$aux = $dados->marca;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$mar_codigo = " and c.mar_codigo in (".$aux2.")";
	}

	$ref_codigo = "";
	if(isset($dados->produto) && !empty($dados->produto)){
		$aux = $dados->produto;
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$ref_codigo = " and b.ref_codigo in (".$aux2.")";
	}

	$cfo_codigo = "";
	$inclurCfop = "TODOS";
	$excluirCfop = "NENHUM";
	if(isset($dados->cfop_incluir) && !empty($dados->cfop_incluir)){
		$aux = explode(", ", $dados->cfop_incluir);
		$aux2 = "";
		for($i=0;$i<count($aux);$i++){
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$cfo_codigo = " and a.cfo_codigo in (".$aux2.")";
		$inclurCfop = $aux2;
	}else if(isset($dados->cfop_excluir) && !empty($dados->cfop_excluir)){
		$aux = explode(", ", $dados->cfop_excluir);
		$aux2 = "";
		$j=count($aux)-1;
		for($i=0;$i<count($aux);$i++){
			$cfo_codigo .= " and a.cfo_codigo != ".$aux[$i]; 
			if($i==0){
				$aux2 .= $aux[$i]; 
			}else{
				$aux2 .= ", ".$aux[$i]; 
			}
		}
		$excluirCfop = $aux2;
	}else{
		$cfo_codigo = "";
	}

	if(isset($dados->data_ini) && !empty($dados->data_ini)){
		$data_ini = implode("-", array_reverse(explode("/", substr($dados->data_ini,0,10))))." 00:00:00";
	}else{
		$data_ini  = "2000-01-01 00:00:00";
	}

	if(isset($dados->data_fim) && !empty($dados->data_fim)){
		$data_fim = implode("-", array_reverse(explode("/", substr($dados->data_fim,0,10))))." 23:59:59";
	}else {
		$data_fim = date('Y-m-d H:i:s');
	}

	$valorizar = 1;
	$filtroValorizar = utf8_decode("PREÇO VAREJO");
	if(isset($dados->{'valorizar'}) && !empty($dados->{'valorizar'})){
		if($dados->{'valorizar'} == 2){
			$valorizar = 2;
			$filtroValorizar = utf8_decode("PREÇO ATACADO");
		}else if($dados->{'valorizar'} == 3){
			$valorizar = 3;
			$filtroValorizar = utf8_decode("PREÇO MÍNIMO");
		}
	}
	
	$filtroCompany = '{"cod":"600001","params":[
		{"name":"emp_codigo","value":"'.$dados->emp_codigo.'","type":"string"}
	]}';
	$Datapacket->setHost($TParams->getHost("empresas"));
	$Datapacket->add($filtroCompany);
	$company = $Datapacket->open(true);
	$Datapacket->clear();
	
	
	$filtro='{"cod":"500570","params":[
		{"name":"database","value":"'.$company[0]->emp_db_comum.'","type":"other"},
		{"name":"emp_codigo","value":"'.$company[0]->emp_codigo.'","type":"string"},
		{"name":"grp_codigo","value":"'.$grp_codigo.'","type":"other"},
		{"name":"mar_codigo","value":"'.$mar_codigo.'","type":"other"},
		{"name":"ref_codigo","value":"'.$ref_codigo.'","type":"other"},
		{"name":"cfo_codigo","value":"'.$cfo_codigo.'","type":"other"},
		{"name":"data_ini","value":"'.$data_ini.'","type":"string"},
		{"name":"data_fim","value":"'.$data_fim.'","type":"string"}		
	]}';
	$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
	$Datapacket->add($filtro);
	$rowdata = $Datapacket->open(true);
	//echo $Datapacket->getLastQuery();
	$cnt = $Datapacket->getRecordCount();
	$Datapacket->clear();
	
	$titulo = utf8_decode("RELATÓRIO ANALÍTICO DE VENDAS POR PRODUTO");
	$logo = "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" . $TParams->getCompany()->{"emp_codigo"} . "/" . $TParams->getCompany()->{"emp_logo"};
	include("inc/relatorioCabecalho.php");
	
	$filtro1 =  base64_encode('<div style="float:left; width:375px;"><span style="font-weight:bold;">'.utf8_decode("PERÍODO: ")."</span> ".data($data_ini)." a ".data($data_fim).'</div>');
	$filtro2 =  base64_encode('<div style="float:left; width:375px;"><span style="font-weight:bold;"> INCLUIR CFOP: </span>'.$inclurCfop.' </div>');
	$filtro3 =  base64_encode('<div style="float:left; width:375px;"><span style="font-weight:bold;"> EXCLUIR CFOP: </span>'.$excluirCfop.' </div>');
	$filtro4 =  base64_encode('<div style="float:left; width:375px;"><span style="font-weight:bold;"> VALORIZADO POR: </span>'.$filtroValorizar.' </div>');
	$objFiltro = new stdClass();
	$filtros = array(
		$objFiltro->filtro = $filtro1,
		$objFiltro->filtro = $filtro2,
		$objFiltro->filtro = $filtro3,
		$objFiltro->filtro = $filtro4
	);
	
	$colunas = '';

	$arrayProd = array();
	$produto = "";

	$totalClientes = array();
	$totalItens = 0;
	$totalQtde = 0;
	$totalTotal = 0;
	$totalGeralQtde = 0;
	$totalGeralValor = 0;
	$totalGeralClientes = 0;
	$totalGeralEstoque = 0;
	$pmu = 0;

	if($cnt > 0){
		for($i=0; $i<$cnt; $i++){
			if($produto != $rowdata[$i]->{'ref_codigo'}){
				array_push($arrayProd, $rowdata[$i]->{'ref_codigo'}."%".$rowdata[$i]->{'ref_descr'}."%".$rowdata[$i]->{'ref_codbar'}."%".$rowdata[$i]->{'mar_descr'}."%".$rowdata[$i]->{'ref_propriedade'}."%".$rowdata[$i]->{'stk_total'}."%".$rowdata[$i]->{'urf_precovar'}."%".$rowdata[$i]->{'urf_precoata'}."%".$rowdata[$i]->{'urf_precomin'});
				$produto = $rowdata[$i]->{'ref_codigo'};
			}
		}

		for($j=0;$j<count($arrayProd);$j++){
			$aux = explode("%",$arrayProd[$j]);
			?>
			<div class="informacaoListagem">
				<div style="width:35%; float:left;"><?php echo $aux[1]."&nbsp";?></div>
				<div style="width:15%; float:left;">Cod. Barras: <?php echo $aux[2]."&nbsp";?></div>
				<div style="width:15%; float:left;">Estoque atual: <?php echo qtde($aux[5])."&nbsp";?></div>
				<div style="width:15%; float:left;">
					Valor do estoque: 
					<?php 
						$stkCalculado = 0;
						if($valorizar == 1){
							$stkCalculado = $aux[5] * $aux[6];
						}else if($valorizar == 2){
							$stkCalculado = $aux[5] * $aux[7];
						}else if($valorizar == 3){
							$stkCalculado = $aux[5] * $aux[8];
						} 
						if($stkCalculado > 0){
							$totalGeralEstoque += $stkCalculado;
						}
						echo valorFormat($stkCalculado);
					?>
				</div>
			</div>
			<div class="informacaoColuna">
				<div style="float:left; width:40%; text-align:right;"> NOTA </div>
				<div style="float:left; width:10%; text-align:right;"> DATA </div>
				<div style="float:left; width:10%; text-align:right;"> CFOP </div>
				<div style="float:left; width:10%; text-align:right;"> QTDE. </div>
				<div style="float:left; width:10%; text-align:right;">UNITÁRIO</div>
				<div style="float:left; width:10%; text-align:right;"> TOTAL </div>
			</div>
			<?php
			for($k=0;$k<count($rowdata);$k++){

				if($k % 2 == 0){
	                $backCor = "#EFEEED";
	            }else{
	                $backCor = "#FFF";
	            }

				if($aux[0] == $rowdata[$k]->{'ref_codigo'}){
					array_push($totalClientes, $rowdata[$k]->{'cad_codigo'});
					$totalItens++;
					$totalQtde += $rowdata[$k]->{'itn_qtde'};
					$totalTotal += $rowdata[$k]->{'itn_qtde'}*$rowdata[$k]->{'itn_valor'};
					?>
					<div style="width:100%; float:left; background-color:<?php echo $backCor; ?>; margin-bottom:7px ">
						<div style="width:30%; float:left; text-align:left;"><?php echo substr($rowdata[$k]->{'cad_nomeraz'}."&nbsp",0,36);?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo $rowdata[$k]->{'not_numero'}."&nbsp";?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo data($rowdata[$k]->{'not_data'}."&nbsp");?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo $rowdata[$k]->{'cfo_codigo'}."&nbsp";?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo qtde($rowdata[$k]->{'itn_qtde'})."&nbsp";?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($rowdata[$k]->{'itn_valor'})."&nbsp";?></div>
						<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($rowdata[$k]->{'itn_qtde'}*$rowdata[$k]->{'itn_valor'})."&nbsp";?></div>
					</div>
					<?php
				}
			}
			$pmu = $totalTotal/$totalQtde;
			?>
			<div class="informacaoRodape">
				<div style="width:20%; float:left; text-align:left; padding-right: 10% ">Total Clientes<?php echo " (".count(array_unique($totalClientes)).")";?></div>
				<div style="width:10%; float:left; text-align:right; padding-right: 20%">Notas<?php echo " (".$totalItens.")";?></div>
				<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($totalQtde)."&nbsp";?></div>
				<div style="width:10%; float:left; text-align:right;"><span style="background-color:#f7f7f7;border:1px solid #e7e7e7">PMU:<?php echo valorFormat($pmu)."&nbsp";?></span></div>
				<div style="width:10%; float:left; text-align:right;"><?php echo valorFormat($totalTotal);?></div>
			</div>
			<?php

			$totalGeralQtde += $totalQtde;
			$totalGeralValor += $totalTotal;
			$totalGeralClientes += count(array_unique($totalClientes));

			$totalClientes = array();
			$totalItens = 0;
			$totalQtde = 0;
			$totalTotal = 0;
			$pmu = 0;
		}
		?>
			<div class="informacaoRodape_outro">
				<div style="width:20%; float:left;">TOTAL GERAL: Produtos <?php echo count(array_unique($arrayProd));?></div>
				<div style="width:20%; float:left; text-align:center">Quantidade <?php echo qtde($totalGeralQtde);?></div>
				<div style="width:20%; float:left; text-align:center">Valor total R$ <?php echo valorFormat($totalGeralValor);?></div>
				<div style="width:20%; float:left; text-align:center">Clientes <?php echo qtde($totalGeralClientes);?></div>
				<div style="width:20%; float:left; text-align:center">Estoque <?php echo valorFormat($totalGeralEstoque);?></div>
			</div>
		<?php
	}else{
		?>
		<div style="width:100%; float:left; padding:1px 0px; margin: 10px 0px 20px 400px; font-weight:bold">
			Não há resultados para a pesquisa.
		</div>
		<?php
	}
	

	include "../rel/inc/relatorioRodape.php";

?>