var _wsFacil;
var _position = document.URL.indexOf('/', 10);
var _host = document.URL.substr(0, _position);
var _websocketUrl = 'ws'+_host.substr(4,_host.length)+':10001';
var _wsData = '';
function writeLog(_retorno){
	if(_retorno.received!="" && _retorno.output != null){
		_wsData = JSON.stringify(_retorno.output);
		return console.log('%cReceived: '+_retorno.received+' - %cOutput: '+JSON.stringify(_retorno.output),'color:blue','color:green');
	}else if(_retorno.received!=""){
		return console.log('%cReceived: '+_retorno.received,'color:blue');
	}else{
		return console.log('%cNão houve retorno.','color:red');
	}
}

window.onbeforeunload = function() {
	_wsFacil.send('quit');
};

window.onload = function() {
	try {
		_wsFacil = new WebSocket(_websocketUrl);
		write('Connecting... (readyState '+_wsFacil.readyState+')');
		_wsFacil.onopen = function(_msg) {
			write('Connection successfully opened (readyState ' + this.readyState+')');
		};
		_wsFacil.onmessage = function(_msg) {
			if(_msg){

				var _retorno = JSON.parse(_msg.data)

				/*
					Quando houver retorno sem acções
				*/
				if(_retorno.action==null){
					writeLog(_retorno);
				}else{
				/*
					Quando houver retorno com ações
				*/

					/*
						Ação reload
					*/
					if(_retorno.action=="reload"){
						writeLog(_retorno);
						if(_retorno.output!=null){
							var _timer = _retorno.output;
						}else{
							var _timer = 60;
						}
						MyDesktop.getModule('_modWebsocket').createWindow({action:"reload",timer:_timer}).show();
					}

					/*
						Ação popup
					*/
					if(_retorno.action=="popup"){
						writeLog(_retorno);
						MyDesktop.popup();
					}

				}

			}
		};
		_wsFacil.onclose = function(_msg) {
			if(this.readyState == 2){
				write('Closing... The connection is going throught the closing handshake (readyState '+this.readyState+')');
			}else if(this.readyState == 3){
				write('Connection closed... The connection has been closed or could not be opened (readyState '+this.readyState+')');
			}else{
				write('Connection closed... (unhandled readyState '+this.readyState+')');
			}
		};
		_wsFacil.onerror = function(event) {};
	}catch(exception) {
		write(exception);
	}
};

function write(text) {
	var date = new Date();
	var dateText = '['+date.getFullYear()+'-'+(date.getMonth()+1 > 9 ? date.getMonth()+1 : '0'+date.getMonth()+1)+'-'+(date.getDate() > 9 ? date.getDate() : '0'+date.getDate())+' '+(date.getHours() > 9 ? date.getHours() : '0'+date.getHours())+':'+(date.getMinutes() > 9 ? date.getMinutes() : '0'+date.getMinutes())+':'+(date.getSeconds() > 9 ? date.getSeconds() : '0'+date.getSeconds())+']';
}