<?php
	date_default_timezone_set('America/Sao_Paulo');

	class Client {
		private $id;
		private $socket;
		private $handshake;
		private $pid;
		private $user;
		private $ip;
		private $since;
		private $version;
		private $url;
		private $emp_codigo;
		private $emp_valid_cert;
		private $emp_db_sge;
		private $emp_db_comum;
		private $isConnected;
		public function __construct($id, $socket) {
			$this->id = $id;
			$this->socket = $socket;
			$this->handshake = false;
			$this->pid = null;
			$this->isConnected = true;
			$this->user = null;
			$this->ip = null;
			$this->since = null;
			$this->version = null;
			$this->url = null;
			$this->emp_codigo = null;
			$this->emp_valid_cert = null;
			$this->emp_db_sge = null;
			$this->emp_db_comum = null;
		}
		public function getId() {
			return $this->id;
		}
		public function getSocket() {
			return $this->socket;
		}
		public function getHandshake() {
			return $this->handshake;
		}
		public function getPid() {
			return $this->pid;
		}
		public function getUser() {
			return $this->user;
		}
		public function getIp() {
			return $this->ip;
		}
		public function getSince() {
			return $this->since;
		}
		public function getVersion() {
			return $this->version;
		}
		public function getUrl() {
			return $this->url;
		}
		public function getEmp_codigo() {
			return $this->emp_codigo;
		}
		public function getEmp_valid_cert() {
			return $this->emp_valid_cert;
		}
		public function getEmp_db_sge() {
			return $this->emp_db_sge;
		}
		public function getEmp_db_comum() {
			return $this->emp_db_comum;
		}
		public function isConnected() {
			return $this->isConnected;
		}
		public function setId($id) {
			$this->id = $id;
		}
		public function setSocket($socket) {
			$this->socket = $socket;
		}
		public function setHandshake($handshake) {
			$this->handshake = $handshake;
		}
		public function setPid($pid) {
			$this->pid = $pid;
		}
		public function setUser($user) {
			$this->user = $user;
		}
		public function setIp($ip) {
			$this->ip = $ip;
		}
		public function setSince($since) {
			$this->since = $since;
		}
		public function setVersion($version) {
			$this->version = $version;
		}
		public function setUrl($url) {
			$this->url = $url;
		}
		public function setEmp_codigo($emp_codigo) {
			$this->emp_codigo = $emp_codigo;
		}
		public function setEmp_valid_cert($emp_valid_cert) {
			$this->emp_valid_cert = $emp_valid_cert;
		}
		public function setEmp_db_sge($emp_db_sge) {
			$this->emp_db_sge = $emp_db_sge;
		}
		public function setEmp_db_comum($emp_db_comum) {
			$this->emp_db_comum = $emp_db_comum;
		}
		public function setIsConnected($isConnected) {
			$this->isConnected = $isConnected;
		}
	}

	class Server {
		/**
		 * The address of the server
		 * @var String
		 */
		private $address;
		/**
		 * The port for the master socket
		 * @var int
		 */
		private $port;
		/**
		 * The master socket
		 * @var Resource
		 */
		private $master;
		/**
		 * The array of sockets (1 socket = 1 client)
		 * @var Array of resource
		 */
		private $sockets;
		/**
		 * The array of connected clients
		 * @var Array of clients
		 */
		private $clients;
		/**
		 * If true, the server will print messages to the terminal
		 * @var Boolean
		 */
		private $verboseMode;
		/**
		 * Prevent loop at action function
		 */
		private $preventActionLoop = 0;
		/**
		 * Server constructor
		 * @param $address The address IP or hostname of the server (default: 127.0.0.1).
		 * @param $port The port for the master socket (default: 5001)
		 */
		public function __construct($address = '127.0.0.1', $port = 5001, $verboseMode = false) {
			$this->console("Server starting...");
			$this->address = $address;
			$this->port = $port;
			$this->verboseMode = $verboseMode;
			// socket creation
			$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
			socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1);
			if(!is_resource($socket)) {
				$this->console("socket_create() failed: ".socket_strerror(socket_last_error()), true);
			}
			if(!socket_bind($socket, $this->address, $this->port)) {
				$this->console("socket_bind() failed: ".socket_strerror(socket_last_error()), true);
			}
			if(!socket_listen($socket, 20)) {
				$this->console("socket_listen() failed: ".socket_strerror(socket_last_error()), true);
			}
			$this->master = $socket;
			$this->sockets = array($socket);
			$this->console("Server started on {$this->address}:{$this->port}");
		}
		/**
		 * Create a client object with its associated socket
		 * @param $socket
		 */
		private function connect($socket) {
			$this->console("Creating client...");
			$client = new Client(uniqid(), $socket);
			$this->clients[] = $client;
			$this->sockets[] = $socket;
			$this->console("Client #{$client->getId()} is successfully created!");
		}
		/**
		 * Do the handshaking between client and server
		 * @param $client
		 * @param $headers
		 */
		private function handshake($client, $headers) {
			$this->console("Getting client WebSocket version...");
			if(preg_match("/Sec-WebSocket-Version: (.*)\r\n/", $headers, $match)) {
				$version = $match[1];
			}
			else {
				$this->console("The client doesn't support WebSocket");
				return false;
			}
			$this->console("Client WebSocket version is {$version}, (required: 13)");
			if($version == 13) {
				// Extract header variables
				$this->console("Getting headers...");
				if(preg_match("/GET (.*) HTTP/", $headers, $match))
					$root = $match[1];
				if(preg_match("/Host: (.*)\r\n/", $headers, $match))
					$host = $match[1];
				if(preg_match("/Origin: (.*)\r\n/", $headers, $match))
					$origin = $match[1];
				if(preg_match("/Sec-WebSocket-Key: (.*)\r\n/", $headers, $match))
					$key = $match[1];
				$this->console("Client headers are:");
				$this->console("\t- Root: ".$root);
				$this->console("\t- Host: ".$host);
				$this->console("\t- Origin: ".$origin);
				$this->console("\t- Sec-WebSocket-Key: ".$key);
				$this->console("Generating Sec-WebSocket-Accept key...");
				$acceptKey = $key.'258EAFA5-E914-47DA-95CA-C5AB0DC85B11';
				$acceptKey = base64_encode(sha1($acceptKey, true));
				$upgrade = "HTTP/1.1 101 Switching Protocols\r\n".
						   "Upgrade: websocket\r\n".
						   "Connection: Upgrade\r\n".
						   "Sec-WebSocket-Accept: $acceptKey".
						   "\r\n\r\n";
				$this->console("Sending this response to the client #{$client->getId()}:\r\n".$upgrade);
				socket_write($client->getSocket(), $upgrade);
				$client->setHandshake(true);
				$this->console("Handshake is successfully done!");
				return true;
			}
			else {
				$this->console("WebSocket version 13 required (the client supports version {$version})");
				return false;
			}
		}
		/**
		 * Disconnect a client and close the connection
		 * @param $socket
		 */
		private function disconnect($client) {
			$this->console("Disconnecting client #{$client->getId()}");
			$client->setIsConnected(false);
			$i = array_search($client, $this->clients);
			$j = array_search($client->getSocket(), $this->sockets);
			if($j >= 0) {
				if($client->getSocket()) {
					array_splice($this->sockets, $j, 1);
					socket_shutdown($client->getSocket(), 2);
					socket_close($client->getSocket());
					$this->console("Socket closed");
				}
			}
			if($i >= 0) {
				array_splice($this->clients, $i, 1);
			}
			$this->console("Client #{$client->getId()} disconnected");
		}
		/**
		 * Get the client associated with the socket
		 * @param $socket
		 * @return A client object if found, if not false
		 */
		private function getClientBySocket($socket) {
			foreach($this->clients as $client)
				if($client->getSocket() == $socket) {
					$this->console("Client found");
					return $client;
				}
			return false;
		}
		/**
		 * Do an action
		 * @param $client
		 * @param $action
		 */

		private function action($client, $action) {

			$action = $this->unmask($action);

			$this->console("Performing action: ".$action);
			
			$receiveObj = json_decode($action);
			
			$this->console($receiveObj->{'action'});
			
			/*
				Action exit or quit
				Encerra/sai do websocket
			*/
			if($receiveObj->{'action'} == "exit" || $receiveObj->{'action'} == "quit") {

				$this->console("Killing a child process");
				if($client->getPid()){
					posix_kill($client->getPid(), SIGTERM);
					$this->console("Process {$client->getPid()} is killed!");
				}else{
					$this->console("Process ".$client->getPid()." not found!");
				}
			}
			/*
				Action Register
				Registra a entrada do usuário.
			*/
			elseif($receiveObj->{'action'} == 'register'){

				$data = $receiveObj->{'data'}[0];
							
				$newClients = array();
				foreach($this->clients as $cli){

					if($client->getSocket() == $cli->getSocket()){
						$cli->setUser(strtoupper($data->{'user'}));
						$cli->setIp($data->{'ip'});
						$cli->setSince(date('Y-m-d h:i:s'));
						$cli->setVersion($data->{'version'});
						$cli->setUrl($data->{'url'});
						$cli->setEmp_codigo($data->{'emp_codigo'});
						$cli->setEmp_valid_cert($data->{'emp_valid_cert'});
						$cli->setEmp_db_sge($data->{'emp_db_sge'});
						$cli->setEmp_db_comum($data->{'emp_db_comum'});
					}
					array_push($newClients,$cli);

				}
				$this->clients = $newClients;

				$ret 			= new StdClass();
				$ret->received 	= $receiveObj->{'action'};
				$ret->output 	= null;
				$ret->action 	= null;
				
				$this->send($client, json_encode($ret));

			}
			/*
				Action getUser
				Resgata as informações de um usuário
			*/
			elseif($receiveObj->{'action'} == 'getUser'){
		
				$data = $receiveObj->{'data'};
			
				foreach($this->clients as $cli){
					if($cli->getUser() == strtoupper($data)){
						$this->console("User: ".$cli->getUser());

						$user 					= new StdClass();
						$user->user 			= $cli->getUser();
						$user->ip 				= $cli->getIp();
						$user->since 			= $cli->getSince();
						$user->url 				= $cli->getUrl();
						$user->version 			= $cli->getVersion();
						$user->emp_valid_cert 	= $cli->getEmp_valid_cert();
						$user->emp_codigo 		= $cli->getEmp_codigo();
						$user->emp_db_sge 		= $cli->getEmp_db_sge();
						$user->emp_db_comum 	= $cli->getEmp_db_comum();
						
						$ret 			= new StdClass();
						$ret->received 	= $receiveObj->{'action'};
						$ret->output 	= $user;
						$ret->action 	= null;

						$this->send($client,json_encode($ret));
					}
				}
			}
			/*
				Action reload
				Atualiza a página de todos os clientes conectados
			*/
			elseif($receiveObj->{'action'} == "reload"){

				if($receiveObj->{'data'}){
					$timer = $receiveObj->{'data'};
				}else{
					$timer = 60;
				}
			
				foreach($this->clients as $client){
					
					$ret 			= new StdClass();
					$ret->received 	= $receiveObj->{'action'};
					$ret->output 	= $timer;
					$ret->action	= 'reload';

					$this->send($client,json_encode($ret));
				}

			}
			/*
				Action list
				Lista todos os clientes conectados
			*/
			elseif($receiveObj->{'action'} == "list"){

				$clientes = array();
				foreach($this->clients as $cli){
					array_push($clientes,$cli->getUser());
				}
				
				$ret 			= new StdClass();
				$ret->received 	= $receiveObj->{'action'};
				$ret->output 	= $clientes;
				$ret->action 	= null;
				
				$this->send($client, json_encode($ret));

			}
			/*
				Action popup
				Abre a janela de mensagens não lidas para os clientes conectados
			*/
			elseif($receiveObj->{'action'} == "popup"){

				foreach($this->clients as $cli){
					$ret 			= new StdClass();
					$ret->received 	= $receiveObj->{'action'};
					$ret->output 	= $null;
					$ret->action 	= 'popup';
					
					$this->send($client, json_encode($ret));
				}

			}
			/*
				Proteção para obrigatoriedade de ação
			*/
			else{
				$this->console("No action: ".var_dump($action));
			}
		}
		/**
		 * Run the server
		 */
		public function run() {
			$this->console("Start running...");
			$this->console("Open in a browser: websocket_client.html (http)");
			while(true) {
				$changed_sockets = $this->sockets;
				if($changed_sockets) {
					@socket_select($changed_sockets, $write = NULL, $except = NULL, 1);
					foreach($changed_sockets as $socket) {
						if($socket == $this->master) {
							if(($acceptedSocket = socket_accept($this->master)) < 0) {
								$this->console("Socket error: ".socket_strerror(socket_last_error($acceptedSocket)));
							}
							else {
								$this->connect($acceptedSocket);
							}
						}
						else {
							$this->console("Finding the socket that associated to the client...");
							$client = $this->getClientBySocket($socket);
							if($client) {
								$this->console("Receiving data from the client");
								$data = null;
								while($bytes = @socket_recv($socket, $r_data, 2048, MSG_DONTWAIT)) {
									$data .= $r_data;
								}
								if(!$client->getHandshake()) {
									$this->console("Doing the handshake");
									if($this->handshake($client, $data)) {
										$this->startProcess($client);
									}
									else {
										$this->disconnect($client);
									}
								}
								elseif($bytes === 0) {
									$this->disconnect($client);
								}else {
									// When received data from client
									$this->action($client, $data);
								}
							}
						}
					}
				}
			}
		}
		/**
		 * Start a child process for pushing data
		 * @param unknown_type $client
		 */
		private function startProcess($client) {
			$this->console("Start a client process");
			$pid = pcntl_fork();
			if($pid == -1) {
				die('could not fork');
			}
			elseif($pid) { // process
				$client->setPid($pid);
			}
			else {
				// we are the child
				while(true) {
					// check if the client is connected
					if(!$client->isConnected()){
						break;
					}
					// push something to the client
					/*$seconds = rand(2, 5);
					$this->send($client, "I am waiting {$seconds} seconds");*/
					sleep(5);
				}
			}
		}
		/**
		 * Send a text to client
		 * @param $client
		 * @param $text
		 */
		private function send($client, $text) {
			$this->console("Send '".$text."' to client #{$client->getId()}");
			$text = $this->encode($text);
			if(socket_write($client->getSocket(), $text, strlen($text)) === false) {
				$this->console("Unable to write to client #{$client->getId()}'s socket");
				$this->disconnect($client);
			}
		}
		/**
		 * Encode a text for sending to clients via ws://
		 * @param $text
		 * @param $messageType
		 */
		function encode($message, $messageType='text') {
			switch ($messageType) {
				case 'continuous':
					$b1 = 0;
					break;
				case 'text':
					$b1 = 1;
					break;
				case 'binary':
					$b1 = 2;
					break;
				case 'close':
					$b1 = 8;
					break;
				case 'ping':
					$b1 = 9;
					break;
				case 'pong':
					$b1 = 10;
					break;
			}
				$b1 += 128;
			$length = strlen($message);
			$lengthField = "";
			if($length < 126) {
				$b2 = $length;
			} elseif($length <= 65536) {
				$b2 = 126;
				$hexLength = dechex($length);
				//$this->stdout("Hex Length: $hexLength");
				if(strlen($hexLength)%2 == 1) {
					$hexLength = '0' . $hexLength;
				}
				$n = strlen($hexLength) - 2;
				for($i = $n; $i >= 0; $i=$i-2) {
					$lengthField = chr(hexdec(substr($hexLength, $i, 2))) . $lengthField;
				}
				while(strlen($lengthField) < 2) {
					$lengthField = chr(0) . $lengthField;
				}
			} else {
				$b2 = 127;
				$hexLength = dechex($length);
				if(strlen($hexLength) % 2 == 1) {
					$hexLength = '0' . $hexLength;
				}
				$n = strlen($hexLength) - 2;
				for($i = $n; $i >= 0; $i = $i - 2) {
					$lengthField = chr(hexdec(substr($hexLength, $i, 2))) . $lengthField;
				}
				while(strlen($lengthField) < 8) {
					$lengthField = chr(0) . $lengthField;
				}
			}
			return chr($b1) . chr($b2) . $lengthField . $message;
		}
		/**
		 * Unmask a received payload
		 * @param $buffer
		 */
		private function unmask($payload) {
			$length = ord($payload[1]) & 127;
			if($length == 126) {
				$masks = substr($payload, 4, 4);
				$data = substr($payload, 8);
			}
			elseif($length == 127) {
				$masks = substr($payload, 10, 4);
				$data = substr($payload, 14);
			}
			else {
				$masks = substr($payload, 2, 4);
				$data = substr($payload, 6);
			}
			$text = '';
			for($i = 0; $i < strlen($data); ++$i) {
				$text .= $data[$i] ^ $masks[$i%4];
			}
			return $text;
		}
		/**
		 * Print a text to the terminal
		 * @param $text the text to display
		 * @param $exit if true, the process will exit
		 */
		private function console($text, $exit = false) {
			$text = date('[Y-m-d H:i:s] ').$text."\r\n";
			if($exit) {
				die($text);
			}
			if($this->verboseMode) {
				echo $text;
			}
		}
	}

	set_time_limit(0);
	// variables
	$address = '127.0.0.1';
	$port = 10001;
	$verboseMode = true;
	$server = new Server($address, $port, $verboseMode);
	$server->run();
?>