<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	$company = $TParams->getCompany();
	
	function diffDate($d1, $d2, $tipo='mes', $sep='-'){
		$d1 = explode($sep, $d1);
		$d2 = explode($sep, $d2);
		if($tipo=='mes') $X = 2592000;
		elseif($tipo=='dia') $X = 86400;
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}
	
	function mes($mes){
		switch($mes){
			case "01":
				return "janeiro";
			case "02":
				return "fevereiro";
			case "03":
				return "março";
			case "04":
				return "abril";
			case "05":
				return "maio";
			case "06":
				return "junho";
			case "07":
				return "julho";
			case "08":
				return "agosto";
			case "09":
				return "setembro";
			case "10":
				return "outubro";
			case "11":
				return "novembro";
			case "12":
				return "dezembro";
		}
	}
	
	function extenso($valor=0, $complemento=true) {
		$rt="";
		$singular = array("centavo", "real", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
		$plural = array("centavos", "reais", "mil", "milhões", "bilhões", "trilhões","quatrilhões");
	 
		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos","quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta","sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze","dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "três", "quatro", "cinco", "seis","sete", "oito", "nove");
	 
		$z=0;
	 
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
	 
		// $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;) 
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
		
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd && $ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			if ($complemento == true) {
				$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
				if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t]; 
			}
			
			if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
	 
		return($rt ? $rt : "zero");
	}
	
	$uploaddir = $TParams->uploads.$TParams->getCodigo()."/contratos/modelos/";
	$contratosdir = $TParams->uploads.$TParams->getCodigo()."/contratos/";
	
	
	
	//excluir arquivo modelo
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" ){
		
		$cfg_contratos="";
		if( isset($_POST["cfg_contratos"]) && $_POST["cfg_contratos"]!="" ){
			$cfg_contratos = json_decode($_POST["cfg_contratos"], true);
			$cont=0;
			foreach($cfg_contratos as $con){
				if($con["arquivo"]==$_REQUEST["arq"]){
					unset($cfg_contratos[$cont]);
				}
				$cont++;
			}			
			$datapacket->setHost("empresas");
			$cfg_contratos = base64_encode(json_encode($cfg_contratos));
			$filtro = '{"cod":"600194","params":[
				{"name":"emp_codigo","value":"'.$_POST["emp_codigo"].'","type":"string"},
				{"name":"cfg_contratos","value":"'.$cfg_contratos.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
		}
		
		if( unlink($uploaddir.$_REQUEST["arq"]) ) echo "ok";
	
	//impressão
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="imprimir" ){
		
		include_once "../class/PHPWord.php";
		$PHPWord = new PHPWord();
		
		$ctt_codigo = $_REQUEST["ctt_codigo"];
		
		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		
		$filtro = '{"cod":"700718","params":[
			{"name":"ctt_codigo","value":"'.$ctt_codigo.'","type":"integer"},
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"}
		]}';
		$datapacket->add($filtro);
		$contrato = $datapacket->open();
		$contrato = $contrato[0];
		

		if($contrato && ($contrato["ctt_autentiqueid"]==NULL || $contrato["ctt_autentiqueid"]=="") ){
			
			//tratamento de dados
			$cad_cnpjcpf = ( strlen($contrato["cad_cnpjcpf"])==11 ) ? substr($contrato["cad_cnpjcpf"], 0, 3).".".substr($contrato["cad_cnpjcpf"], 3, 3).".".substr($contrato["cad_cnpjcpf"], 6, 3)."-".substr($contrato["cad_cnpjcpf"], 9, 11) : substr($contrato["cad_cnpjcpf"], 0, 2).".".substr($contrato["cad_cnpjcpf"], 2, 3).".".substr($contrato["cad_cnpjcpf"], 5, 3)."/".substr($contrato["cad_cnpjcpf"], 8, 4)."-".substr($contrato["cad_cnpjcpf"], 12, 2);
			if( strlen($contrato["cad_cnpjcpf"])==11 ){
				$rg = $contrato["cad_inscrg"];
			}else{
				$ie = $contrato["cad_inscrg"];
			}
			$ctt_valor = number_format(($contrato["ctt_valor"]-$contrato["ctt_desconto"]+$contrato["ctt_acrescimo"]), 2, ",", ".");
			$ctt_valor2 = number_format(($contrato["ctt_valor"]-$contrato["ctt_desconto"]+$contrato["ctt_acrescimo"]), 2, ".", "");
			$vencimento = (isset($contrato["frq_codigo"])) ? $contrato["ctt_datavcto"] : substr($contrato["ctt_datacobr"], 8, 2);
			$cep = substr($contrato["end_cep"], 0, 5)."-".substr($contrato["end_cep"], 5, 3);
			$vigencia = diffDate($contrato["ctt_dataini"], $contrato["ctt_datafim"]);
			$vigenciaDias = diffDate($contrato["ctt_dataini"], $contrato["ctt_datafim"], 'dia');
			$ctt_obs = str_replace(";", '</w:t><w:br/><w:t xml:space="preserve">', base64_decode($contrato["ctt_obs"]));
			
			if( isset($_REQUEST["arq"]) && $_REQUEST["arq"]!="" ){
				$doc = $PHPWord->loadTemplate($uploaddir.$_REQUEST["arq"]);
			}else{
				$arq = json_decode(base64_decode($company->cfg_contratos), true);
				if(is_array($arq) && count($arq)>0){
					$doc = $PHPWord->loadTemplate($uploaddir.$arq[0]["arquivo"]);
				}else{
					exit("Nao foi encontrado modelo de impressao do contrato!");
				}
			}
			
			//remover e comercial
			$contrato["cad_nomeraz"] = str_replace("&", "E", $contrato["cad_nomeraz"]);
			
			//substituição dos campos fixos por dados reais
			$doc->setValue('NUMERO', $contrato["ctt_numero"]);
			$doc->setValue('CLIENTE', $contrato["cad_nomeraz"]);
			$doc->setValue('VENDEDOR', $contrato["vendedor"]);
			$doc->setValue('FANTASIA', $contrato["cad_snomefant"]);
			$doc->setValue('CPF', $cad_cnpjcpf);
			$doc->setValue('RESPONSAVEL', utf8_decode($contrato["con_nome"]));
			if(isset($rg) && $rg!=""){
				$doc->setValue('RG', $rg);
			}elseif(isset($ie) && $ie!=""){
				$doc->setValue('RG', 'IE: '.$ie);
			}
			$doc->setValue('ENDERECO', utf8_decode($contrato["end_nome"].", ".$contrato["end_num"]));
			$doc->setValue('BAIRRO', substr(utf8_decode($contrato["end_bairro"]),0,40));
			$doc->setValue('CIDADE', utf8_decode($contrato["end_cidade"]));
			$doc->setValue('UF', utf8_decode($contrato["end_uf"]));
			$doc->setValue('CEP', utf8_decode($cep));
			$doc->setValue('RAMO', utf8_decode($contrato["rat_descr"]));
			$doc->setValue('TELEFONE', "(".$contrato["tel_ddd"].") ".$contrato["tel_prefixo"]."-".$contrato["tel_numero"]);
			$doc->setValue('EMAIL', strtolower($contrato["eml_ender"]));
			$doc->setValue('DATA', substr($contrato["ctt_data"], 8, 2)." de ".utf8_decode(mes(substr($contrato["ctt_data"], 5, 2)))." de ".substr($contrato["ctt_data"], 0, 4));
			$doc->setValue('INICIO', implode("/", array_reverse(explode("-", $contrato["ctt_dataini"]))));
			$doc->setValue('TERMINO', implode("/", array_reverse(explode("-", $contrato["ctt_datafim"]))));
			$doc->setValue('VIGENCIA', $vigencia." meses");
			$doc->setValue('DIASVIGENCIA', $vigenciaDias." dias");
			$doc->setValue('SERVICO', $contrato["svc_descr"]);
			$doc->setValue('DESCRICAO', base64_decode($contrato["ctt_svc_obs"]));
			$doc->setValue('LOCALDATA1', implode("/", array_reverse(explode("-", substr($contrato["eve_inicio"], 0, 10)))));
			$doc->setValue('LOCALSEMANA1', utf8_decode($contrato["eve_inicio_semana"]));
			$doc->setValue('LOCALHORA1', substr($contrato["eve_inicio"], 11, 5));
			$doc->setValue('LOCALDATA2', implode("/", array_reverse(explode("-", substr($contrato["eve_termino"], 0, 10)))));
			$doc->setValue('LOCALSEMANA2', utf8_decode($contrato["eve_termino_semana"]));
			$doc->setValue('LOCALHORA2', substr($contrato["eve_termino"], 11, 5));
			$doc->setValue('LOCAL', utf8_decode($contrato["eve_descricao"]));
			$doc->setValue('VALOREXTENSO', trim(extenso($ctt_valor2)));
			$doc->setValue('TOTALEXTENSO', trim(extenso(($vigencia*$ctt_valor))));
			$doc->setValue('TOTAL', ($vigencia*$ctt_valor));
			$doc->setValue('VALOR', $ctt_valor);
			$doc->setValue('FREQUENCIA', $contrato["frq_descricao"]);
			$doc->setValue('VENCIMENTO', $vencimento);
			$doc->setValue('PAGAMENTO', utf8_decode($contrato["cdp_descr"]));
			$doc->setValue('OBS', $ctt_obs);
			$doc->setValue('TESTEMUNHA1', $contrato["ctt_testemunha1"]);
			$doc->setValue('TESTEMUNHACPF1', $contrato["ctt_testemunha1cpf"]);
			$doc->setValue('TESTEMUNHA2', $contrato["ctt_testemunha2"]);
			$doc->setValue('TESTEMUNHACPF2', $contrato["ctt_testemunha2cpf"]);
			
			if (!is_dir($contratosdir.$ctt_codigo)) mkdir($contratosdir.$ctt_codigo, 0777, true);
			
			
			
			//requisicao vinda de outro modulo diferente do contrato
			if( isset($_POST["ipj_codigo"]) && $_POST["ipj_codigo"]!="" ){
				$doc->save($TParams->uploads.$TParams->getCodigo()."/projetos/".$_POST["ipj_codigo"]."/CONTRATO-".$ctt_codigo.".docx");
				exit(strtolower($contrato["eml_ender"]));
			}
			
			$doc->save($contratosdir.$ctt_codigo."/".$ctt_codigo.".docx");
			
			sleep(2);
			
			$curl = curl_init();
			// ATENCAO: para Posicionar campos de assinatura, incluir os dados abaixo dentro de variables, dentro de cada item signers. z representa o numero da pagina comecando de 1
			//"positions": [{"x": "5.0", "y": "90.0", "z": 1, "element": "SIGNATURE"}]
			//em caso de duvidas consultar : https://docs.autentique.com.br/api/mutations/criando-um-documento
			
			//criar documento no autentique para poder ser assinado digitalmente
			
			//com e-mail
			if( isset($contrato["eml_ender"]) && $contrato["eml_ender"]!=""){
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.autentique.com.br/v2/graphql',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  //CURLOPT_SSL_VERIFYPEER => false,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => array('operations' => '{"query":"mutation CreateDocumentMutation($document: DocumentInput!, $signers: [SignerInput!]!, $file: Upload!) {createDocument(document: $document, signers: $signers, file: $file) {id name refusable sortable created_at signatures { public_id name email created_at action { name } link { short_link } user { id name email }}}}", "variables":{"document": {"name": "Contrato de '.$contrato["cad_nomeraz"].'"},"signers": [{"email": "'.strtolower($company->emp_email).'","action": "SIGN"},{"email": "'.strtolower($contrato["eml_ender"]).'","action": "SIGN"}],"file":null}}','map' => '{"file": ["variables.file"]}','file'=> new CURLFILE($contratosdir.$ctt_codigo."/".$ctt_codigo.".docx")),
				  CURLOPT_HTTPHEADER => array(
					'Authorization: Bearer 4f72c696f1cf387712fac4298ea9d0d09944f1f0141ac59d0dfe52f3149d9c3b'
				  ),
				));
			//sem e-mail
			}else{
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.autentique.com.br/v2/graphql',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  //CURLOPT_SSL_VERIFYPEER => false,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => array('operations' => '{"query":"mutation CreateDocumentMutation($document: DocumentInput!, $signers: [SignerInput!]!, $file: Upload!) {createDocument(document: $document, signers: $signers, file: $file) {id name refusable sortable created_at signatures { public_id name email created_at action { name } link { short_link } user { id name email }}}}", "variables":{"document": {"name": "Contrato de '.$contrato["cad_nomeraz"].'"},"signers": [{"email": "'.strtolower($company->emp_email).'","action": "SIGN"},{"name": "'.$contrato["cad_nomeraz"].'","action": "SIGN"}],"file":null}}','map' => '{"file": ["variables.file"]}','file'=> new CURLFILE($contratosdir.$ctt_codigo."/".$ctt_codigo.".docx")),
				  CURLOPT_HTTPHEADER => array(
					'Authorization: Bearer 4f72c696f1cf387712fac4298ea9d0d09944f1f0141ac59d0dfe52f3149d9c3b'
				  ),
				));
			}
			$response = curl_exec($curl);
			curl_close($curl);
			sleep(6);
			
			
			if( isset($response) && $response!="" ){
				$arrC = json_decode($response, true);
				if(is_array($arrC) && isset($arrC["data"]) && isset($arrC["data"]["createDocument"])){
					//atualizar id autentique
					$filtro = '{"cod":"700802","params":[
						{"name":"ctt_codigo","value":"'.$ctt_codigo.'","type":"integer"},
						{"name":"ctt_autentiqueid","value":"'.$arrC["data"]["createDocument"]["id"].'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
					
					//buscar documento para imprimir em formato PDF
					$curl = curl_init();
					curl_setopt_array($curl, array(
					  CURLOPT_URL => 'https://api.autentique.com.br/v2/graphql',
					  CURLOPT_RETURNTRANSFER => true,
					  CURLOPT_ENCODING => '',
					  CURLOPT_MAXREDIRS => 10,
					  CURLOPT_TIMEOUT => 0,
					  CURLOPT_FOLLOWLOCATION => true,
					  //CURLOPT_SSL_VERIFYPEER => false,
					  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					  CURLOPT_CUSTOMREQUEST => 'POST',
					  CURLOPT_POSTFIELDS =>'{
						"query": "query { document(id: \\"'.$arrC["data"]["createDocument"]["id"].'\\") { id name refusable sortable created_at files { original signed } signatures { public_id name email created_at action { name } link { short_link } user { id name email } email_events { sent opened delivered refused reason } viewed { ...event } signed { ...event } rejected { ...event } } } } fragment event on Event { ip port reason created_at geolocation { country countryISO state stateISO city zipcode latitude longitude } }",
						"variables": {}
					}',
					  CURLOPT_HTTPHEADER => array(
						'Authorization: Bearer 4f72c696f1cf387712fac4298ea9d0d09944f1f0141ac59d0dfe52f3149d9c3b',
						'Content-Type: application/json'
					  ),
					));

					$resposta = curl_exec($curl);
					curl_close($curl);
					if( isset($resposta) && $resposta!="" ){
						$arrImp = json_decode($resposta, true);
						if(is_array($arrImp) && isset($arrImp["data"]) && isset($arrImp["data"]["document"])){
							copy($arrImp["data"]["document"]["files"]["original"], $contratosdir.$ctt_codigo."/".$ctt_codigo.".pdf");
							sleep(2);
							exit($TParams->uploads2.$TParams->getCodigo()."/contratos/".$ctt_codigo."/".$ctt_codigo.".pdf");
						}
					}
					
				}else{
					echo "Nao foi possivel imprimir o contrato! Verifique se o cliente possui e-mail cadastrado!";
				}
			}else{
				echo "Nao foi possivel imprimir o contrato!";
			}
			
		//caso ja exista um id no autentique apenas busca o documento e o imprime	
		}else{
			//verifica se existe versao assinada, se existir copia e exibe
			$assinado = "https://api.autentique.com.br/documentos/".$contrato["ctt_autentiqueid"]."/assinado.pdf";
			$ass = @get_headers($assinado);
			if( $ass[0]== 'HTTP/1.1 200 OK' ){
				
				copy($assinado, $contratosdir.$ctt_codigo."/".$ctt_codigo.".pdf");
				sleep(2);
				exit($TParams->uploads2.$TParams->getCodigo()."/contratos/".$ctt_codigo."/".$ctt_codigo.".pdf");
				
			//verifica se existe versao local
			}elseif( is_file($contratosdir.$ctt_codigo."/".$ctt_codigo.".pdf") && file_exists($contratosdir.$ctt_codigo."/".$ctt_codigo.".pdf") ){
				exit($TParams->uploads2.$TParams->getCodigo()."/contratos/".$ctt_codigo."/".$ctt_codigo.".pdf");
			}else{
				//buscar documento para imprimir em formato PDF
				$curl = curl_init();
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.autentique.com.br/v2/graphql',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  //CURLOPT_SSL_VERIFYPEER => false,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS =>'{
					"query": "query { document(id: \\"'.$contrato["ctt_autentiqueid"].'\\") { id name refusable sortable created_at files { original signed } signatures { public_id name email created_at action { name } link { short_link } user { id name email } email_events { sent opened delivered refused reason } viewed { ...event } signed { ...event } rejected { ...event } } } } fragment event on Event { ip port reason created_at geolocation { country countryISO state stateISO city zipcode latitude longitude } }",
					"variables": {}
				}',
				  CURLOPT_HTTPHEADER => array(
					'Authorization: Bearer 4f72c696f1cf387712fac4298ea9d0d09944f1f0141ac59d0dfe52f3149d9c3b',
					'Content-Type: application/json'
				  ),
				));

				$resposta = curl_exec($curl);
				curl_close($curl);
				if( isset($resposta) && $resposta!="" ){
					$arrImp = json_decode($resposta, true);
					if(is_array($arrImp) && isset($arrImp["data"]) && isset($arrImp["data"]["document"])){
						copy($arrImp["data"]["document"]["files"]["original"], $contratosdir.$ctt_codigo."/".$ctt_codigo.".pdf");
						sleep(2);
						exit($TParams->uploads2.$TParams->getCodigo()."/contratos/".$ctt_codigo."/".$ctt_codigo.".pdf");
					}
				}
			
			}
			
		}
	
	//upload de modelo
	}elseif( isset($_FILES['photo']['tmp_name']) ){
		
		$extensao = array_reverse(explode(".", $_FILES['photo']['name']));
		$extensao = strtolower($extensao[0]);
		
		if($extensao!="docx") exit("Somente são aceitos arquivos com extensão .docx");
		
		$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
		$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
		
		$arq = str_replace($array1, $array2, $_FILES['photo']['name']);

		if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
			
		if(move_uploaded_file($_FILES['photo']['tmp_name'], $uploaddir.$arq)){
			
			$datapacket->setHost("empresas");
			
			$cfg_contratos="";
			if( isset($_POST["cfg_contratos"]) && $_POST["cfg_contratos"]!="" ){
				$cfg_contratos = json_decode($_POST["cfg_contratos"], true);
				$cod = (count($cfg_contratos)>0) ? count($cfg_contratos)+1 : 1;
				array_push($cfg_contratos, array("codigo"=>$cod, "nome"=>$_POST["nome"], "arquivo"=>$arq));
			}else{
				$cfg_contratos = array();
				array_push($cfg_contratos, array("codigo"=>$cod, "nome"=>$_POST["nome"], "arquivo"=>$arq));
			}
			$cfg_contratos = base64_encode(json_encode($cfg_contratos));
		
			$filtro = '{"cod":"600194","params":[
				{"name":"emp_codigo","value":"'.$_POST["emp_codigo"].'","type":"string"},
				{"name":"cfg_contratos","value":"'.$cfg_contratos.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			
			echo "ok";
			
		}else{
			
			echo "Erro ao tentar efetuar upload!";
			
		}
	
	//listar arquivos de modelo
	}else{
		
		$datapacket->setHost("empresas");
	
		$filtro = '{"cod":"600195","params":[
			{"name":"emp_codigo","value":"'.$_REQUEST["emp_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$contratos = $datapacket->open();
		if( $contratos[0] && $contratos[0]['cfg_contratos'] && $contratos[0]['cfg_contratos']!='' ){
			print_r(base64_decode($contratos[0]['cfg_contratos']));
		}

	}

?>