<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	$uploaddir = $TParams->uploads.$TParams->getCodigo()."/retorno/";
	
	//servidor de homologação
	if($_SERVER['HTTP_HOST']=="192.168.1.251"){
		$url = "http://131.161.72.52/php/retorno_novo.php";
	}else{
		$url = 'http://b.grupouds.com.br/php/retorno_novo.php';
	}
	
	$fields_string = "";
	$cont=0;
	
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="incluir" && isset($_FILES["arquivo_ret"]["tmp_name"]) ){
		
		foreach($_FILES['arquivo_ret']['name'] as $nomeArq){
			
			$erro = false;
			
			$extensao = array_reverse(explode(".", $nomeArq));
			$nomeArq = $extensao[1];
			$extensao = strtolower($extensao[0]);
			
			if($extensao!="ret" && $extensao!="crt" && $extensao!="txt"){
				$erro = true;
				echo "Arquivo ".$nomeArq." inválido, somente são aceitos arquivos com extensão .ret ou .crt<br>   ";
			}
			$arq = $nomeArq.".".$extensao;
			
			/*busca por já cadastrados*/
			$filtroB = '{"cod":"700752","params":[
				{"name":"ret_arquivo","value":"'.$arq.'","type":"string"}
			]}';
			$datapacket->add($filtroB);
			$ret = $datapacket->open();
			$datapacket->clear();
			
			if( is_array($ret) && isset($ret[0]["ret_arquivo"]) && $ret[0]["ret_arquivo"]==$arq ){
				$erro = true;
				echo "O arquivo ".$arq." já foi enviado!<br>   ";
			}
			
			if($erro ==false){
				//se nao existir diretoria, cria
				if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
				
				//upload local
				if(move_uploaded_file($_FILES['arquivo_ret']['tmp_name'][$cont], $uploaddir.$arq)){
					
					$company = $TParams->getCompany();
					
					//salvando no banco
					$filtro = '{"cod":"700743","params":[
						{"name":"ret_arquivo","value":"'.$arq.'","type":"string"}
					]}';
					$datapacket->add($filtro);
					if($datapacket->open()){
						
						//pegando dados do arquivo para salvá-lo remotamente
						$conteudo = file_get_contents($uploaddir.$arq);
						
						$fields = array(
							'acao' => 'incluir',
							'emp_cpfcnpj' => $company->emp_cpfcnpj,
							'arq' => urlencode($arq),
							'conteudo' => urlencode($conteudo)
						);

						//url-ify os dados para o POST
						foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
						rtrim($fields_string, '&');

						//abrir conexao
						$ch = curl_init();

						//define url, numero de variaveis POST e dados POST
						curl_setopt($ch,CURLOPT_URL, $url);
						curl_setopt($ch,CURLOPT_POST, count($fields));
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

						//executa POST
						$result = curl_exec($ch);

						//fechar conexao
						curl_close($ch);				
						$datapacket->clear();
						
					}else{
						echo "Não foi possível inserir o registro do Arquivo ".$arq."<br>";
					}
					
				}else{
					echo "Erro ao tentar efetuar upload do arquivo ".$arq."<br>";
				}
				$cont++;
			}
		}

	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="excluir" && isset($_REQUEST["arq"]) ){
		
		$company = $TParams->getCompany();
		$codigos = "";
		$_REQUEST["ret_codigo"] = json_decode($_REQUEST["ret_codigo"]);
		if( strstr($_REQUEST["arq"], "[") && strstr($_REQUEST["arq"], "]") ) $_REQUEST["arq"] = json_decode($_REQUEST["arq"]);

		if( is_array($_REQUEST["ret_codigo"]) ){
			foreach($_REQUEST["ret_codigo"] as $codigo){
				$codigos.= $codigo.", ";
			}
			$codigos = substr($codigos, 0, -2);
			foreach($_REQUEST["arq"] as $arquivo){
				if( is_file($uploaddir.$arquivo) ) @unlink($uploaddir.$arquivo);	
			}
		}else{
			$codigos = $_REQUEST["ret_codigo"];
			if( is_file($uploaddir.$_REQUEST["arq"]) ) @unlink($uploaddir.$_REQUEST["arq"]);	
		}
		
		//excluindo no banco
		$filtro = '{"cod":"700745","params":[
			{"name":"ret_codigo","value":"'.$codigos.'","type":"other"}
		]}';
		
		$datapacket->add($filtro);
		if($datapacket->open()){
			
			$fields = array(
				'acao' => 'excluir',
				'emp_cpfcnpj' => $company->emp_cpfcnpj,
				'arq' => urlencode(json_encode($_REQUEST["arq"]))
			);

			//url-ify os dados para o POST
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//abrir conexao
			$ch = curl_init();

			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url);
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

			//executa POST
			$result = curl_exec($ch);

			//fechar conexao
			curl_close($ch);
			echo "ok";
		}
		
	}elseif( isset($_POST["acao"]) && $_POST["acao"]=="executar" && isset($_POST["arq"]) ){
		
		include_once "remessaPHP/Retorno.class.php";
		include_once "remessaPHP/Documento.class.php";
		
		$Retorno = new Retorno($uploaddir.$_POST["arq"]);
		
		$company = $TParams->getCompany();
		
		if( isset($Retorno->banco) && isset($Retorno->layout) && ($Retorno->banco=="756" || $Retorno->banco=="104" || (($Retorno->banco=="033" || $Retorno->banco=="001") && $Retorno->layout=="FEBRABAN240") || (($Retorno->banco=="341" || $Retorno->banco=="748" || $Retorno->banco=="237") && $Retorno->layout=="CNAB400") ) ){
			
			if($Retorno->inscricaoNumero==$company->emp_cpfcnpj || $Retorno->banco=="341"){
				
				if($Retorno->banco==$_POST["banco_numero"]){
					
					if($Retorno->layout==$_POST["layout"]){
					
						//dados do retorno
						$certo=0;
						$errado=0;
						
						$banco = $Retorno->banco;
						$agencia = $Retorno->agenciaCodigo."-".$Retorno->agenciaDv;
						$convenio = $Retorno->convenio;
						$layout = $Retorno->layout;
						$inscricao = $Retorno->inscricaoNumero;
						$conta = $Retorno->contaNumero."-".$Retorno->contaDv;
						
						//dados dos documentos (ocorrencias)
						$Documento = new Documento($Retorno->layout, $Retorno->banco);
						
						//total de titulos confoirme layout
						if($Retorno->layout=="CNAB400"){
							$inicio=1;
							$total = (count($Retorno->arquivo)-2);
							$incremento=1;
						}elseif($Retorno->layout=="FEBRABAN240"){
							$inicio=2;
							$total = (count($Retorno->arquivo)-2);
							$incremento=2;
						}elseif($Retorno->layout=="SIGCB240"){
							$inicio=2;
							$total = (count($Retorno->arquivo)-4);
							$incremento=1;
						}

						for($i = $inicio; $i <= $total; $i = $i + $incremento){
							
							$nossoNumero = $Documento->_get('nossoNumero', $Retorno->arquivo[$i]);
							// echo "Nosso Número ".$nossoNumero."<br>";
							$parcela = $Documento->_get('parcela', $Retorno->arquivo[$i]);
							$codigoBaixaDevolucao = $Documento->_get('codigoBaixaDevolucao', $Retorno->arquivo[$i]);
							$codigoMovimento = $Documento->_get('codigoMovimento', $Retorno->arquivo[$i]);
							$motivo = $Documento->_get('motivo', $Retorno->arquivo[$i]);
							// echo "Movimento ".$codigoMovimento."<br>";
							// echo "Motivo ".$motivo."<br>";
							$dataRegistroLiquidacao = $Documento->_get('dataEmissaoTitulo', $Retorno->arquivo[$i]);
							// echo "Data Emissão ".$dataRegistroLiquidacao."<br>";
							$numeroDocumento = $Documento->_get('numeroDocumento', $Retorno->arquivo[$i]);
							// echo "Número ".$numeroDocumento."<br>";
							$vencimento = $Documento->_get('vencimento', $Retorno->arquivo[$i]);
							// echo "Vencimento ".$vencimento."<br>";
							$valorTitulo = $Documento->_get('valorTitulo', $Retorno->arquivo[$i]);
							// echo "Valor ".$valorTitulo."<br>";
							$especieTitulo = $Documento->_get('especieTitulo', $Retorno->arquivo[$i]);
							$dataCredito = ($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") ? $Documento->_get('dataCredito', $Retorno->arquivo[$i+1]) : $Documento->_get('dataCredito', $Retorno->arquivo[$i]);
							// echo "Data ".$dataCredito."<br>";
							$valorTarifa = $Documento->_get('valorTarifa', $Retorno->arquivo[$i]);
							// echo "Tarifa ".$valorTarifa."<br>";
							$valorRecebido = ($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") ? $Documento->_get('valorRecebido', $Retorno->arquivo[$i+1]) : $Documento->_get('valorRecebido', $Retorno->arquivo[$i]);
							// echo "Recebido ".$valorRecebido."<br>";
							$valorLancamento = ($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") ? $Documento->_get('valorLancamento', $Retorno->arquivo[$i+1]) : $Documento->_get('valorLancamento', $Retorno->arquivo[$i]);
							// echo "Lancto ".$valorLancamento."<br>";
							$desconto = ($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") ? $Documento->_get('desconto1', $Retorno->arquivo[$i+1]) : $Documento->_get('desconto1', $Retorno->arquivo[$i]);
							$juros = ($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") ? $Documento->_get('jurosMora', $Retorno->arquivo[$i+1]) : $Documento->_get('jurosMora', $Retorno->arquivo[$i]);
							$multa = $Documento->_get('multa', $Retorno->arquivo[$i]);
							$descr = "";
							// exit();
							if( $nossoNumero!="" && (int) $nossoNumero!=0 ){
								
								//motivo da ocorrencia
								if(isset($motivo) && $motivo!="" && $motivo!="00" && $codigoMovimento=="03"){
									switch($motivo){
										case '04':
											$descrmotivo = "Código de Movimento não permitido";
											break;
										case '06':
											$descrmotivo = "Tipo/número de inscrição beneficiário inválido";
											break;
										case '07':
											$descrmotivo = "Agência/ Conta/ DV inválido";
											break;
										case '08':
											$descrmotivo = "Nosso número inválido";
											break;
										case '09':
											$descrmotivo = "Nosso número duplicado";
											break;
										case '10':
											$descrmotivo = "Carteira inválida";
											break;
										case '16':
											$descrmotivo = "Data vencimento inválida";
											break;
										case '17':
											$descrmotivo = "Vencimento anterior a emissão";
											break;
										case '20':
											$descrmotivo = "Valor do título inválido";
											break;
										case '26':
											$descrmotivo = "Código de juros inválido";
											break;
										case '27':
											$descrmotivo = "Valor de juros inválido";
											break;
										case '37':
											$descrmotivo = "Código de protesto inválido";
											break;
										case '38':
											$descrmotivo = "Prazo de protesto inválido";
											break;
										case '46':
											$descrmotivo = "Tipo/ inscrição do pagador inválido";
											break;
										case '47':
											$descrmotivo = "Endereço pagador não informado";
											break;
										case '48':
											$descrmotivo = "CEP pagador inválido";
											break;
										case '59':
											$descrmotivo = "Valor de multa inválido";
											break;
										case '60':
											$descrmotivo = "Alteração de titulo não cadastrado";
											break;
										case '63':
											$descrmotivo = "Entrada para título ja cadastrado";
											break;
									}
								}
								
								//descrição da ocorrencia de acordo com o layout/banco
								switch($codigoMovimento){
									case '02':
										$descr = "Título registrado pelo Banco";
										break;
									case '03':
										$descr = ( isset($descrmotivo) && $descrmotivo!="" ) ? "Rejeitado: ".$descrmotivo : "Entrada rejeitada";
										break;
									case '04':
										$descr = "Transferência de carteira/ entrada";
										break;
									case '05':
										$descr = "Transferência de carteira/ baixa";
										break;
									case '06':
										$descr = "Liquidação Normal";
										break;
									case '07':
										$descr = "Intenção de Pagamento";
										break;
									case '09':
										$descr = "Baixa Manual";
										break;
									case '10':
										$descr = "Baixa Solicitada";
										break;
									case '11':
										$descr = "Em Ser (em aberto)";
										break;
									case '12':
										$descr = "Abatimento Concedido";
										break;
									case '13':
										$descr = "Abatimento Cancelado";
										break;
									case '14':
										$descr = "Alteração de Vencimento";
										break;
									case '15':
										$descr = "Liquidação em Cartório";
										break;
									case '17':
										$descr = "Liquidação Sem Registro";
										break;
									case '19':
										$descr = "Entrada em Protesto";
										break;
									case '20':
										$descr = "Cancelamento de Protesto";
										break;
									case '23':
										$descr = "Encaminhado p/ protesto";
										break;
									case '27':
										$descr = "Alteração de dados";
										break;
									case '28':
										$descr = "Débito de Tarifas/ Custas";
										break;
									case '48':
										$descr = "Transferência de carteira/ modalidade";
										break;
								}
								
								$datapacket->clear();
								$datapacket->add('{"cod":"700747", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //buscar o boleto
								$ret = $datapacket->open();
								$datapacket->clear();
								
								//boletos de e-commerce
								if( $valorRecebido>0 && isset($ret[0]["ser_codigo"]) && $ret[0]["ser_codigo"]=="ECM" ){
									
									$datapacket->add('{"cod":"700765", "params":[{"name":"doc_codigo", "value":"'.$ret[0]["doc_codigo"].'", "type":"string"}]}'); //buscar o pedido (e-commerce)
									$ped = $datapacket->open();
									$datapacket->clear();
									
									if( isset($ped[0]) && count($ped)>0 ){
										
										//atualizar pedido
										$filtro = '{"cod":"700756","params":[
											{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
										]}';
										$datapacket->add($filtro);
										$datapacket->open();
										$datapacket->clear();
										
										// Enviando o email para o FACIL através de uma requisição POST
										$fields = array(
											'p' => $_REQUEST['p'],
											'acao' => 'email',
											'not_codigo' => $ped[0]["not_codigo"]
										);

										$fields_string = ''; //url-ify the data for the POST
										foreach($fields as $key => $value) $fields_string .= $key.'='.$value.'&';
										rtrim($fields_string, '&');

										if(!empty($fields_string)){
											$ch = curl_init(); //Abre conexão
											curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/ecommerce.php"); //Seta URL
											curl_setopt($ch,CURLOPT_POST, count($fields)); //Seta quantidade de campos
											curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string); //Seta valores dos mesmos
											curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // ativa o retorno do curl
											$codigoSalvo = curl_exec($ch); //Executa o post
											curl_close($ch); //Fecha conexão
										}
										
									}
									
								}
								
								//boletos de contrato, desbloquear contrato (somente uds)
								if( $valorRecebido>0 && isset($ret[0]["ser_codigo"]) && $ret[0]["ser_codigo"]=="CTT" && isset($ret[0]["doc_origem"]) && $ret[0]["doc_origem"]==2 && ($company->emp_codigo=="UDS" || $company->emp_codigo=="MODELO") ){
									//buscar dominio para desbloqueio (cancelar suspensão pelo cpanel)
									$filtro = '{"cod":"700514","params":[
										{"name":"doc_origem_codigo","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"}
									]}';
									$datapacket->add($filtro);
									$user = $datapacket->open();
									$datapacket->clear();
									if(is_array($user) && count($user)>0){
										$usu="";
										if(strstr(base64_decode($user[0]["ctt_obs"]), "www.")){
											$usu = explode("www.", base64_decode($user[0]["ctt_obs"]));
											$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
											if(is_array($usu)) $usu=$usu[1];
										}elseif(strstr(base64_decode($user[0]["ctt_svc_obs"]), "www.")){
											$usu = explode("www.", base64_decode($user[0]["ctt_svc_obs"]));
											$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
											if(is_array($usu)) $usu=$usu[1];
										}
										$usu = strtolower($usu);
										
										if($usu!=""){
											//autenticação cpanel
											$whmusername = "rsrv12gr";
											$hash = "8cd0728cc093b222a6131c39194583b7f1c671326bfca5a190906249eb7d518e41ca51bc77a47bf3da4e37d6c8b6828cf6cd1957a8f5877c93e3dac961560579eff476cbe32b7fd18db4087f87a1d2309a43ef076232aca9087c6c7d19549749eecfcf6fb0075e74cbc7348ab1ef9dc6813221779cffc93df31d765d68f1847ee5e3655f63266e7066646b6f6328aa3a6dabb2b07b1ce8cd920da04df2f8b48b8cfb778a4f4452a34cf24b5bbe335b8d58502e7593eb152e5ff72aa8343f496ffce0e4e86a7c69557c621c04ab75d626600a5c0fa3a76602fb624cd78fd51c16464161b3c16ea9e9a9336aa281ef18d1f31312e49beefc490e3eccb5091ab80fab7f3f2a2a4a02fbef8eddccc273390ee5b3f9e2431b42c7149299b5e9230d9389b345b1978a8dce489ab6c06a920d51df7f9117d939d7990760a623a17ff0dc18c19d79dff0185310902a5d0fbfa2a9d5863f264d5c27c8e2032161e976389da8f3333fa46fde935fcb3f5d6b3004a6daf00b4fb28607ebbd888f67113210c3113381231ad0c34a7b0e4a6baaa8a297c271973df880342f5c30bc959309549b8bc4ea0013fb814a6cbcf2aa2d7b46d87a12fd6ad12cb8f435c9a7c45b67acc20846c2394b5ac1c9f0302b921c4de7291b17c24b4d1d3cbba75335e37c43daee";
											$query = "https://srv14.grupouds.com.br:2087/json-api/listaccts?api.version=1"; 
											$curl = curl_init();
											curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
											curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
											curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
											$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
											curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
											curl_setopt($curl, CURLOPT_URL, $query);
											$result = curl_exec($curl);
											curl_close($curl);
											$res = json_decode($result);
											//verificacao usuarios
											for($count=0;$count<count($res->data->acct); $count++){
												//comparacao com dominio da obs
												if($usu==$res->data->acct[$count]->domain){
													//cancelar suspensão da conta
													$query = "https://srv14.grupouds.com.br:2087/json-api/unsuspendacct?api.version=1&user=".$res->data->acct[$count]->user; 
													$curl = curl_init();
													curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
													curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
													curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
													$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
													curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
													curl_setopt($curl, CURLOPT_URL, $query);
													$result = curl_exec($curl);
													curl_close($curl);										
												}
											}
										}
									}
									//desbloquear contrato
									$filtro = '{"cod":"700509","params":[
										{"name":"doc_origem_codigo","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"}
									]}';
									$datapacket->add($filtro);
									$filtrolog = '{"cod":"700103","params":[
										{"name":"log_tipo","value":"4","type":"integer"},
										{"name":"log_nro","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"},
										{"name":"log_serie","value":"CTT","type":"string"},
										{"name":"log_usu_login","value":"","type":"string"},
										{"name":"log_acao_cod","value":"11","type":"integer"},
										{"name":"log_acao_descr","value":"desbloqueio","type":"string"},
										{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
										{"name":"log_protocolo","value":"NULL","type":"other"},
										{"name":"log_ret","value":"NULL","type":"other"},
										{"name":"log_outro","value":"'.base64_encode("Contrato desbloqueado, debito quitado").'","type":"string"}
									]}';
									$datapacket->add($filtrolog);
									//desbloquear Facil
									$filtro = '{"cod":"700538","params":[
										{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"},
										{"name":"doc_origem_codigo","value":"'.$ret[0]["doc_origem_codigo"].'","type":"string"}
									]}';
									$datapacket->add($filtro);
									$datapacket->open();
									$datapacket->clear();
								}
								
								if( is_array($ret) && count($ret)>0 ){
									
									$datapacket->clear();
									
									if( $valorRecebido>0 && $codigoMovimento=="06" ){
										//tratando exceções de solicitação de baixa de banco/ layout/ movimento
										if( $banco=="756" && $layout=="CNAB400" && ($codigoMovimento=="09" || $codigoMovimento=="10") ){
											
											$datapacket->add('{"cod":"700759", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //resetar remessa
											
										}else{
										
											// $status = ( $valorRecebido < $ret[0]["doc_valor"] ) ? 1 : 2;
											$status = 2;
											
											//atualizando boletos
											$filtro = '{"cod":"700758","params":[
												{"name":"doc_dtpgto","value":"'.implode("-", array_reverse(explode("/", $dataCredito))).' 00:00:00","type":"string"},
												{"name":"doc_valorpg","value":"'.$valorRecebido.'","type":"float"},
												{"name":"doc_multapg","value":"'.$multa.'","type":"float"},
												{"name":"doc_jurospg","value":"'.$juros.'","type":"float"},
												{"name":"doc_desconto","value":"'.$desconto.'","type":"float"},
												{"name":"doc_status","value":"'.$status.'","type":"integer"},
												{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
											]}';
											$datapacket->add($filtro);
											
											//efetuando lançamento (tipo e tarifa)
											$filtrolancto = '{"cod":"700279","params":[
												{"name":"lan_historico","value":"Docto Cód. '.$ret[0]["doc_codigo"].' - LANCAMENTO CRIADO A PARTIR DE BAIXA AUTOMÁTICA DE BOLETO (RETORNO)","type":"string"},
												{"name":"lan_data","value":"'.implode("-", array_reverse(explode("/", $dataCredito))).' 00:00:00","type":"string"},
												{"name":"lan_valor","value":"'.$valorRecebido.'","type":"float"},
												{"name":"lan_conc","value":"0","type":"integer"},
												{"name":"lan_dc","value":"2","type":"integer"},
												{"name":"ser_codigo","value":"1","type":"string"},';
											$filtrolancto.= (isset($ret[0]["cta_codigo"]) && $ret[0]["cta_codigo"]!='') ? '{"name":"cta_codigo","value":"'.$ret[0]["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!='') ? '{"name":"plc_codigo","value":"'.$ret[0]["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= '{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},';
											$filtrolancto.= (isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!='') ? '{"name":"ccu_codigo","value":"'.$ret[0]["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= '{"name":"lan_dtmov","value":"'.implode("-", array_reverse(explode("/", $dataCredito))).' 00:00:00","type":"string"},
												{"name":"lan_tipo","value":"2","type":"integer"},
												{"name":"lan_tarifa","value":"'.$valorTarifa.'","type":"float"},
												{"name":"lan_forpag","value":"8","type":"integer"}
											]}';
											$datapacket->add($filtrolancto);
											
											//atualizando o historico do documento com a baixa automatica
											$usu_login = ( isset($_POST["usu_login"]) ) ? $_POST["usu_login"] : "";
											$filtro = '{"cod":"501240","params":[
												{"name":"lgd_tipo","value":"5","type":"integer"},
												{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
												{"name":"usu_login","value":"'.$usu_login.'","type":"string"},
												{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
												{"name":"lgd_descr","value":"Baixa automática no valor de R$ '.$valorRecebido.'","type":"string"}
											]}';
											$datapacket->add($filtro);
											
										}
											
									}elseif( $codigoMovimento=="03" && $motivo!="09" && $motivo!="63" ){
										$datapacket->add('{"cod":"700767", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //titulo rejeitado
									}elseif( $codigoMovimento=="02" ){
										$datapacket->add('{"cod":"700766", "params":[{"name":"doc_nossonumero", "value":"'.$nossoNumero.'", "type":"string"}]}'); //titulo registrado no banco
									}
									
									//atualizando retorno
									$filtro = '{"cod":"700748","params":[
										{"name":"ret_codigo","value":"'.$_POST["ret_codigo"].'","type":"integer"},
										{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
										{"name":"doc_movimento","value":"'.$codigoMovimento.'","type":"integer"},
										{"name":"doc_taxa","value":"'.$valorTarifa.'","type":"float"},
										{"name":"doc_ocorrencia","value":"'.$descr.'","type":"string"}
									]}';
									$datapacket->add($filtro);
									
									$datapacket->open();
									$certo++;
									
								}else{
									
									$errado++;
									
								}
							
							}
							
						}

						$datapacket->clear();
						
						if($Retorno->layout=="FEBRABAN240" || $Retorno->layout=="SIGCB240") $total = round($total/3);
						echo "Foram encontradas ".($total)." ocorrências no arquivo de retorno.<br>";
						// $erro = $i- count($ret);
							
						if($certo>0){
							echo "Das quais, ".$certo." documentos correspondentes foram encontrados e atualizados.<br>";
						}
						
						if($errado>0){
							echo "Não foram encontrados documentos correspondentes para ".$errado." ocorrências!";
						}
						
						$filtro = '{"cod":"700746","params":[
							{"name":"ret_codigo","value":"'.$_POST["ret_codigo"].'","type":"integer"},
							{"name":"ret_total","value":"'.$certo.'","type":"integer"},
							{"name":"ret_carteira","value":"'.$_POST["carteira"].'","type":"string"}
						]}';
						$datapacket->add($filtro);
						$datapacket->open();
						
						exit();
						
					}else{
						exit("O layout do arquivo difere do layout selecionado no sistema. Layout do aquivo: ".$Retorno->layout." - layout do sistema: ".$_POST["layout"]);
					}
					
				}else{
					exit("O Banco do arquivo difere do Banco selecionado no sistema. Favor selecionar o mesmo banco correspondente ao arquivo.");
				}
			
			}else{
				exit("Número de inscrição (CNPJ) do arquivo de retorno diverge do cadastrado no sistema");
			}
			
		//demais casos usar cobrebemx
		}else{
			
			$fields = array(
				'p' => $_REQUEST["p"],
				'acao' => 'executar',
				'servidor' => $_SERVER['HTTP_HOST'],
				'emp_cpfcnpj' => $company->emp_cpfcnpj,
				'emp_db_sge' => urlencode($company->emp_db_sge),
				'emp_db_comum' => urlencode($company->emp_db_comum),
				'emp_codigo' => urlencode($company->emp_codigo),
				'arq' => urlencode($_POST["arq"]),
				'carteira' => urlencode($_POST["carteira"]),
				'banco_numero' => urlencode($_POST["banco_numero"]),
				'banco_nome' => urlencode($_POST["banco_nome"]),
				'banco_numero' => urlencode($_POST["banco_numero"]),
				'layout' => urlencode($_POST["layout"]),
				'ret_codigo' => urlencode($_POST["ret_codigo"])
			);
			
			if($_SERVER['HTTP_HOST']=="192.168.1.251" || $_SERVER['HTTP_HOST']=="hom.grupouds.com.br"){
				$fields["sis"]="251";
			}elseif($_SERVER['HTTP_HOST']=="dev.uds.com.br"){
				$fields["sis"]="110";
			}elseif($_SERVER['HTTP_HOST']=="facil.uds.com.br"){
				$fields["sis"]="248";
			}elseif($_SERVER['HTTP_HOST']=="facil.grupouds.com.br"){
				$fields["sis"]="247";
			}

			//url-ify os dados para o POST
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//abrir conexao
			$ch = curl_init();

			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $url);
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

			//executa POST
			$result = curl_exec($ch);
			
			//fechar conexao
			curl_close($ch);
			
		}
	//retornos automaticos
	}elseif( isset($_POST["acao"]) && $_POST["acao"]=="automatico" ){
		
		//banco inter
		$company = $TParams->getCompany();
		
		$bancos = json_decode(base64_decode($company->emp_bancos));
		
		if( is_array($bancos) && count($bancos)>0 ){
			
			foreach($bancos as $banco){
				if( $banco->banco_numero=="077" && $banco->carteira=="112" ){
					
					$dircert = $TParams->uploads.$company->emp_codigo.'/certificados/'.$company->emp_cpfcnpj.'.';
					
					if( isset($banco->conta2) && $banco->conta2!="" && isset($banco->contrato) && $banco->contrato!="" ){
						//método por token (versao 2.0)
						$dircert = $TParams->uploads.$company->emp_codigo.'/inter/'.$company->emp_cpfcnpj.'.';
						if( is_file($dircert."crt") && file_exists($dircert."crt") ){
							//gerar token
							$curl = curl_init();
							curl_setopt_array($curl, array(
							  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/oauth/v2/token',
							  CURLOPT_RETURNTRANSFER => true,
							  CURLOPT_SSLCERT => $dircert."crt",
							  CURLOPT_SSLKEY => $dircert."key",
							  CURLOPT_SSL_VERIFYHOST => false,
							  CURLOPT_SSL_VERIFYPEER => false,
							  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							  CURLOPT_CUSTOMREQUEST => 'POST',
							  CURLOPT_POSTFIELDS => 'client_id='.$banco->contrato.'&client_secret='.$banco->conta2.'&scope=boleto-cobranca.read&grant_type=client_credentials',
							  CURLOPT_HTTPHEADER => array(
								'Content-Type: application/x-www-form-urlencoded'
							  ),
							));
							$response = curl_exec($curl);
							curl_close($curl);
							$response = json_decode($response, true);										
							$token = $response["access_token"];
							//echo $token."<br>";
							$curl = curl_init();
							curl_setopt_array($curl, array(
							  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas?filtrarDataPor=PAGAMENTO&situacao=RECEBIDO&dataInicial='.date("Y-m-d", strtotime(date("Y-m-d")."- 7 days")).'&dataFinal='.date("Y-m-d"),
							  CURLOPT_RETURNTRANSFER => true,
							  CURLOPT_SSLCERT => $dircert."crt",
							  CURLOPT_SSLKEY => $dircert."key",
							  CURLOPT_SSL_VERIFYHOST => false,
							  CURLOPT_SSL_VERIFYPEER => false,
							  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							  CURLOPT_CUSTOMREQUEST => 'GET',
							  CURLOPT_HTTPHEADER => array(
								'Accept: application/json',
								'Authorization: Bearer '.$token
							  ),
							));
							$response = curl_exec($curl);
							curl_close($curl);
							$response = json_decode($response, true);
							
							if( is_array($response) && isset($response["totalElementos"]) && $response["totalElementos"]>0 ){
								$total = $response["totalPaginas"];
								$contador=1;
								$datapacket->clear();
								foreach($response["cobrancas"] as $bol){
									
									if($bol["cobranca"]["situacao"]=="RECEBIDO"){
										$datapacket->add('{"cod":"700747", "params":[{"name":"doc_nossonumero", "value":"'.$bol["boleto"]["nossoNumero"].'", "type":"string"}]}'); //buscar o boleto
										$ret = $datapacket->open();
										$datapacket->clear();
										if( $ret && $ret[0] && $ret[0]["doc_codigo"] ){
											
										
											$status = ( $bol["cobranca"]["valorTotalRecebido"] < $ret[0]["doc_valor"] ) ? 1 : 2;
											$lan_forpag = ( $bol["cobranca"]["origemRecebimento"]=="BOLETO" ) ? 8 : 10;
											
											//atualizando boletos
											$filtro = '{"cod":"700758","params":[
												{"name":"doc_dtpgto","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
												{"name":"doc_valorpg","value":"'.$bol["cobranca"]["valorTotalRecebido"].'","type":"float"},
												{"name":"doc_multapg","value":"0","type":"float"},
												{"name":"doc_jurospg","value":"0","type":"float"},
												{"name":"doc_desconto","value":"0","type":"float"},
												{"name":"doc_status","value":"'.$status.'","type":"integer"},
												{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
											]}';
											$datapacket->add($filtro);
											echo $filtro."<br>";
											
											//efetuando lançamento (tipo e tarifa)
											$filtrolancto = '{"cod":"700279","params":[
												{"name":"lan_historico","value":"Docto Cód. '.$ret[0]["doc_codigo"].' - LANCAMENTO CRIADO A PARTIR DE BAIXA AUTOMÁTICA DE BOLETO (RETORNO)","type":"string"},
												{"name":"lan_data","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
												{"name":"lan_valor","value":"'.$bol["cobranca"]["valorTotalRecebido"].'","type":"float"},
												{"name":"lan_conc","value":"0","type":"integer"},
												{"name":"lan_dc","value":"2","type":"integer"},
												{"name":"ser_codigo","value":"1","type":"string"},';
											$filtrolancto.= (isset($ret[0]["cta_codigo"]) && $ret[0]["cta_codigo"]!='') ? '{"name":"cta_codigo","value":"'.$ret[0]["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!='') ? '{"name":"plc_codigo","value":"'.$ret[0]["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= '{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},';
											$filtrolancto.= (isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!='') ? '{"name":"ccu_codigo","value":"'.$ret[0]["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
											$filtrolancto.= '{"name":"lan_dtmov","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
												{"name":"lan_tipo","value":"2","type":"integer"},
												{"name":"lan_tarifa","value":"0.00","type":"float"},
												{"name":"lan_forpag","value":"'.$lan_forpag.'","type":"integer"}
											]}';
											$datapacket->add($filtrolancto);
											echo $filtrolancto."<br>";
											
											//atualizando o historico do documento com a baixa automatica
											$usu_login = ( isset($_POST["usu_login"]) ) ? $_POST["usu_login"] : "";
											$filtro = '{"cod":"501240","params":[
												{"name":"lgd_tipo","value":"5","type":"integer"},
												{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
												{"name":"usu_login","value":"'.$usu_login.'","type":"string"},
												{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
												{"name":"lgd_descr","value":"Baixa automática no valor de R$ '.$bol["cobranca"]["valorTotalRecebido"].'","type":"string"}
											]}';
											$datapacket->add($filtro);
											echo $filtro."<br>";
											$datapacket->open();
											$datapacket->clear();
											
										}
										
										//boletos de ecommerce
										
										if( $status==2 && isset($ret[0]["ser_codigo"]) && $ret[0]["ser_codigo"]=="ECM" ){
											
											$datapacket->add('{"cod":"700765", "params":[{"name":"doc_codigo", "value":"'.$ret[0]["doc_codigo"].'", "type":"string"}]}'); //buscar o pedido (e-commerce)
											$ped = $datapacket->open();
											$datapacket->clear();
											
											if( isset($ped[0]) && count($ped)>0 ){
												
												//atualizar pedido
												$filtro = '{"cod":"700756","params":[
													{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
												]}';
												$datapacket->add($filtro);
												$datapacket->open();
												$datapacket->clear();
												
												// Enviando o email para o FACIL através de uma requisição POST
												$fields = array(
													'p' => $_REQUEST['p'],
													'acao' => 'email',
													'not_codigo' => $ped[0]["not_codigo"]
												);

												$fields_string = ''; //url-ify the data for the POST
												foreach($fields as $key => $value) $fields_string .= $key.'='.$value.'&';
												rtrim($fields_string, '&');

												if(!empty($fields_string)){
													$ch = curl_init(); //Abre conexão
													curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/ecommerce.php"); //Seta URL
													curl_setopt($ch,CURLOPT_POST, count($fields)); //Seta quantidade de campos
													curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string); //Seta valores dos mesmos
													curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // ativa o retorno do curl
													$codigoSalvo = curl_exec($ch); //Executa o post
													curl_close($ch); //Fecha conexão
												}
												
											}
											
										}
									}
								}
								//demais pg
								if( $total>1 ){
									while($contador<=$total){
										$curl = curl_init();
										curl_setopt_array($curl, array(
										  CURLOPT_URL => 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas?filtrarDataPor=PAGAMENTO&situacao=RECEBIDO&dataInicial='.date("Y-m-d", strtotime(date("Y-m-d")."- 7 days")).'&dataFinal='.date("Y-m-d").'&paginacao.paginaAtual='.$contador,
										  CURLOPT_RETURNTRANSFER => true,
										  CURLOPT_SSLCERT => $dircert."crt",
										  CURLOPT_SSLKEY => $dircert."key",
										  CURLOPT_SSL_VERIFYHOST => false,
										  CURLOPT_SSL_VERIFYPEER => false,
										  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
										  CURLOPT_CUSTOMREQUEST => 'GET',
										  CURLOPT_HTTPHEADER => array(
											'Accept: application/json',
											'Authorization: Bearer '.$token
										  ),
										));
										$response = curl_exec($curl);
										curl_close($curl);
										$response = json_decode($response, true);

										
										if( is_array($response) && isset($response["totalElementos"]) && $response["totalElementos"]>0 ){

											foreach($response["cobrancas"] as $bol){
												
												if($bol["cobranca"]["situacao"]=="RECEBIDO"){
													$datapacket->add('{"cod":"700747", "params":[{"name":"doc_nossonumero", "value":"'.$bol["boleto"]["nossoNumero"].'", "type":"string"}]}'); //buscar o boleto
													$ret = $datapacket->open();
													$datapacket->clear();
													if( $ret && $ret[0] && $ret[0]["doc_codigo"] ){
														
													
														$status = ( $bol["cobranca"]["valorTotalRecebido"] < $ret[0]["doc_valor"] ) ? 1 : 2;
														$lan_forpag = ( $bol["cobranca"]["origemRecebimento"]=="BOLETO" ) ? 8 : 10;
														
														//atualizando boletos
														$filtro = '{"cod":"700758","params":[
															{"name":"doc_dtpgto","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
															{"name":"doc_valorpg","value":"'.$bol["cobranca"]["valorTotalRecebido"].'","type":"float"},
															{"name":"doc_multapg","value":"0","type":"float"},
															{"name":"doc_jurospg","value":"0","type":"float"},
															{"name":"doc_desconto","value":"0","type":"float"},
															{"name":"doc_status","value":"'.$status.'","type":"integer"},
															{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"}
														]}';
														$datapacket->add($filtro);
														echo $filtro."<br>";
														
														//efetuando lançamento (tipo e tarifa)
														$filtrolancto = '{"cod":"700279","params":[
															{"name":"lan_historico","value":"Docto Cód. '.$ret[0]["doc_codigo"].' - LANCAMENTO CRIADO A PARTIR DE BAIXA AUTOMÁTICA DE BOLETO (RETORNO)","type":"string"},
															{"name":"lan_data","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
															{"name":"lan_valor","value":"'.$bol["cobranca"]["valorTotalRecebido"].'","type":"float"},
															{"name":"lan_conc","value":"0","type":"integer"},
															{"name":"lan_dc","value":"2","type":"integer"},
															{"name":"ser_codigo","value":"1","type":"string"},';
														$filtrolancto.= (isset($ret[0]["cta_codigo"]) && $ret[0]["cta_codigo"]!='') ? '{"name":"cta_codigo","value":"'.$ret[0]["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
														$filtrolancto.= (isset($ret[0]["plc_codigo"]) && $ret[0]["plc_codigo"]!='') ? '{"name":"plc_codigo","value":"'.$ret[0]["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
														$filtrolancto.= '{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},';
														$filtrolancto.= (isset($ret[0]["ccu_codigo"]) && $ret[0]["ccu_codigo"]!='') ? '{"name":"ccu_codigo","value":"'.$ret[0]["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
														$filtrolancto.= '{"name":"lan_dtmov","value":"'.$bol["cobranca"]["dataSituacao"].' 00:00:00","type":"string"},
															{"name":"lan_tipo","value":"2","type":"integer"},
															{"name":"lan_tarifa","value":"0.00","type":"float"},
															{"name":"lan_forpag","value":"'.$lan_forpag.'","type":"integer"}
														]}';
														$datapacket->add($filtrolancto);
														echo $filtrolancto."<br>";
														
														//atualizando o historico do documento com a baixa automatica
														$usu_login = ( isset($_POST["usu_login"]) ) ? $_POST["usu_login"] : "";
														$filtro = '{"cod":"501240","params":[
															{"name":"lgd_tipo","value":"5","type":"integer"},
															{"name":"doc_codigo","value":"'.$ret[0]["doc_codigo"].'","type":"string"},
															{"name":"usu_login","value":"'.$usu_login.'","type":"string"},
															{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
															{"name":"lgd_descr","value":"Baixa automática no valor de R$ '.$bol["cobranca"]["valorTotalRecebimento"].'","type":"string"}
														]}';
														$datapacket->add($filtro);
														echo $filtro."<br>";
														
														$datapacket->open();
														$datapacket->clear();
													}
												}
											}
										}
										$contador++;
									}
								}
								exit('retorno inter!');
							}else{
								//echo 'https://cdpj.partners.bancointer.com.br/cobranca/v3/cobrancas?filtrarDataPor=PAGAMENTO&situacao=RECEBIDO&dataInicial='.date("Y-m-d", strtotime(date("Y-m-d")."- 7 days")).'&dataFinal='.date("Y-m-d");
							}
						}
					}
				}
			}
		}
	}else{
		
		$filtro = '{"cod":"700744","params":[]}';
		
		$datapacket->add($filtro);
		
		$ret = $datapacket->open();
		
		print_r(json_encode($ret));
		
	}

?>