<?php
	include_once 'datapacket.php';
	include_once 'TParams.class.php';
	
	$datapacket = new datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	
	$company = $TParams->getCompany();
	$datapacket->setHost($TParams->getHost($company->emp_db_sge));
	$p = base64_encode($company->emp_codigo);
	$p = substr($p, 0, 1)."2".substr($p, 1);

	header('Content-Description: File Transfer');
	header('Content-Type: application/octet-stream');
	header('Content-Transfer-Encoding: binary');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');
	header('Expires: 0');
	include_once("../class/PHPMailer_v5.1/class.phpmailer.php");

	$TParams = new TParams();
	$json = json_decode(base64_decode($_REQUEST['dados']));
	$emp_codigo = $json->{'emp_codigo'};
	$mes = $json->{"mes"};
	$ano = $json->{"ano"};

	$ambNfse = 'homologacao';
	if(isset($company->{'emp_amb_nfse'}) && $company->{'emp_amb_nfse'} == 1){
		$ambNfse = 'producao';
	}
	
	$email_destinatario = "";
	if(isset($json->{"email"})&&!empty($json->{'email'})){
		$email_destinatario = $json->{'email'};
	}
	
	$data_ini = $ano.'-'.$mes.'-01 00:00:00';
	$data_fim = $ano.'-'.$mes.'-'.date('t', strtotime($ano.'/'.$mes.'/01')) . " 23:59:59";
	
	$dirNfse = $TParams->getUploads().$company->emp_codigo.'/nfse/'.$ambNfse.'/autorizadas/'.$ano.$mes."/";
	if( is_dir($dirNfse) ){
		$diretorio = dir($dirNfse);
	}
	
	//criar zip
	$zip = new ZipArchive();
	$zipDir = '../tmp';
	if(!is_dir($zipDir)) mkdir($zipDir,0777);
	$zipName = 'MAGNETICOS NFSE '.$mes.'-'.$ano.'.zip';
	if(is_file($zipDir.'/'.$zipName)) unlink($zipDir.'/'.$zipName);
	
	if ($zip->open($zipDir.'/'.$zipName, ZipArchive::CREATE)!==TRUE){
		exit("cannot open <$zipname>\n");
	}
	
	$contador=0;
	if(isset($diretorio)){
		while($arq = $diretorio->read()){
			if($arq!="" && $arq!="../" && $arq!=".." && $arq!="."){
				$extensao = array_reverse(explode(".", $arq));
				$nome = $extensao[1];
				$extensao = strtolower($extensao[0]);
				//PDFs
				if(isset($json->{'pdf'}) && $json->{'pdf'}=='s'){
					if($extensao=="xml" || $extensao=="pdf"){
						$zip->addFile($dirNfse.$arq, $arq);
					}
				}else{
					if($extensao=="xml"){
						$zip->addFile($dirNfse.$arq, $arq);
					}
				}
				$contador++;
			}
		}
		$diretorio->close();
	}
	
	if($contador==0){
		$fp = fopen('/var/www/desktop/tmp/aviso.txt','w+');
		fwrite($fp, "Nenhuma nota encontrada!");
		fclose($fp);
		$zip->addFile('/var/www/desktop/tmp/aviso.txt', 'aviso.txt');
	}

	//relatorio anexo
	if( isset($json->relatorio) && $json->relatorio=="sim" ){
		
		$dados = array( 'data_ini'=>$data_ini, 'data_fim'=>$data_fim, 'status'=>1, 'ordenar'=>1, 'ordem'=>'asc', 'emp_codigo'=>$company->emp_codigo);
		$fields = array(
			'p' => $_REQUEST["p"],
			'dados' => base64_encode(json_encode($dados))
		);
		//abrir conexao
		$ch = curl_init();
		//define url, numero de variaveis POST e dados POST
		curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/rel/relNfse.php");
		curl_setopt($ch,CURLOPT_POST, true);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
		//executa POST
		$result = curl_exec($ch);
		$anexo1 = array_reverse(explode("/", $result));  //relatorio anexo
		$anexo1 = $anexo1[0];
		//fechar conexao
		curl_close($ch);
		if( isset($anexo1) && is_file( $TParams->getHostRoot() . "tmp/".$anexo1)){
			$zip->addFile( $TParams->getHostRoot() . "tmp/" . $anexo1,'relatorio.pdf');
		}
	
	}
	
	$zip->close();
	
	if ( $email_destinatario != "" && is_file($zipDir."/".$zipName) ) {
			
		//modelo de e-mail (envio de XML automático)
		$filtro = '{"cod":"700268","params":[
			{"name":"dbcomum","value":"'.$company->emp_db_comum.'","type":"other"},
			{"name":"men_codigo","value":"6","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open(true);
		$datapacket->clear();				
			
		$filtro = '{"cod":"700599","params":[
			{"name":"db","value":"'.$company->emp_db_sge.'","type":"other"},
			{"name":"msg_codigo","value":"","type":"string"},
			{"name":"msg_tipo","value":"1","type":"integer"},
			{"name":"men_codigo","value":"6","type":"integer"},
			{"name":"msg_remetente","value":"'.$ret[0]->men_remetente.'","type":"string"},
			{"name":"msg_destinatario","value":"'.$email_destinatario.'","type":"string"},
			{"name":"cad_codigo","value":"","type":"string"},
			{"name":"msg_assunto","value":"'.$ret[0]->men_assunto.'","type":"string"},
			{"name":"msg_conteudo","value":"'.utf8_decode($ret[0]->men_conteudo).'","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"","type":"string"}
		]}';
		$datapacket->add($filtro);
		$ret = $datapacket->open(false, true);
		$datapacket->clear();
	
		//enviar mensagem de e-mail
		if($ret){
	
			//requisição para anexos
			$fields = array(
				'p' => $p,
				'acao' => 'anexar',
				'msg_codigo' => $ret,
				'ane_descricao' => base64_encode("Magneticos NFS-e referentes ao mes ".$mes),
				'msg_anexo' => new CURLFile($zipDir."/".$zipName)
			);
			//abrir conexao
			$ch = curl_init();
			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
			curl_setopt($ch,CURLOPT_POST, true);
			curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			//executa POST
			$result = curl_exec($ch);
			//fechar conexao
			curl_close($ch);
			
			//requisição para envio da mensagem
			$fields = array(
				'p' => $p,
				'acao' => 'enviar',
				'msg_codigo' => $ret
			);
			//url-ify os dados para o POST
			$fields_string="";
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');
			//abrir conexao
			$ch = curl_init();
			//define url, numero de variaveis POST e dados POST
			curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
			//executa POST
			$result = curl_exec($ch);
			//fechar conexao
			curl_close($ch);
			echo "ok";
			
		}
		
	}
	
	if (!isset($_REQUEST['btn_email'])) {
		header('Content-Disposition: attachment; filename="'.$zipName.'"');
		header('Content-Length: '.filesize($zipDir."/".$zipName));
		while (ob_get_level()) ob_end_clean();
		@readfile($zipDir."/".$zipName);
	}
	
?>