<?php

	setlocale (LC_ALL, 'pt_BR.UTF-8');
	set_time_limit(1500);
	error_reporting(E_ALL ^ E_NOTICE);
	
	function unicode_convert($string_to_decode = ""){
		if(empty($string_to_decode)) return "";
		$before = array("\u00c0", "\u00c1", "\u00c2", "\u00c3", "\u00c4", "\u00c5", "\u00c6", "\u00c7", "\u00c8", "\u00c9", "\u00ca", "\u00cb", "\u00cc", "\u00cd", "\u00ce", "\u00cf", "\u00d1", "\u00d2", "\u00d3", "\u00d4", "\u00d5", "\u00d6", "\u00d8", "\u00d9", "\u00da", "\u00db", "\u00dc", "\u00dd", "\u00df", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e6", "\u00e7", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f1", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc", "\u00fd", "\u00ff", "\u200b");
		$after = array("À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "Ø", "Ù", "Ú", "Û", "Ü", "Ý", "ß", "à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï", "ð", "ñ", "ò", "ó", "ô", "õ", "ö", "ø", "ù", "ú", "û", "ü", "ý", "ÿ", "");      
		return str_replace($before, $after, $string_to_decode);
	}
	
	include_once '../php/TParams.class.php';

	$datapacket=new TParams();
	
	$datapacket->setHost($datapacket->getHost("e0250_comum"));
	
	
	$filtro = '{"cod":"900103","params":[]}';
	$datapacket->add($filtro);
	$ref = $datapacket->open(true);
	$datapacket->clear();
	$i=0;
	foreach($ref as $r){
		$ref_detalhes = utf8_decode(unicode_convert(base64_decode($r->ref_detalhes)));
		if($r->ref_codigo!=190 && $r->ref_codigo!=355){
			$filtro = '{"cod":"900104","params":[
				{"name":"ref_detalhes","value":"'.base64_encode($ref_detalhes).'","type":"string"},
				{"name":"ref_codigo","value":"'.$r->ref_codigo.'","type":"integer"}
			]}';
			$datapacket->add($filtro);
			echo $filtro."<br><br>";
		}
		$i++;
	}
	$datapacket->open(true);
	// echo $datapacket->getLastQuery();
	$datapacket->clear();	
	
?>