<?php 
/*
					____
				 _.' :  `._
			 .-.'`.  ;   .'`.-.
	__      / : ___\ ;  /___ ; \      __
  ,'_ ""--.:__;".-.";: :".-.":__;.--"" _`,
  :' `.t""--.. '<@.`;_  ',@>` ..--""j.' `;
	   `:-.._J '-.-'L__ `-- ' L_..-;'
		 "-.__ ;  .-"  "-.  : __.-"
			 L ' /.------.\ ' J
			  "-.   "--"   .-"
			 __.l"-:_JL_;-";.__
		  .-j/'.;  ;""""  / .'\"-.
		.' /:`. "-.:     .-" .';  `.
	 .-"  / ;  "-. "-..-" .-"  :    "-.
  .+"-.  : :      "-.__.-"      ;-._   \
  ; \  `.; ;                    : : "+. ;
  :  ;   ; ;                    : ;  : \:
 : `."-; ;  ;                  :  ;   ,/;
  ;    -: ;  :                ;  : .-"'  :
  :\     \  : ;             : \.-"      :
   ;`.    \  ; :            ;.'_..--  / ;
   :  "-.  "-:  ;          :/."      .'  :
	 \       .-`.\        /t-""  ":-+.   :
	  `.  .-"    `l    __/ /`. :  ; ; \  ;
		\   .-" .-"-.-"  .' .'j \  /   ;/
		 \ / .-"   /.     .'.' ;_:'    ;
		  :-""-.`./-.'     /    `.___.'
				\ `t  ._  /
				 "-.t-._:'
*/
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	class Datapacket {

		private static $instance = null;
		private static $dbType 	 = "mysql";
		public $dbSys 	 		 = "empresas";
		public $templateTable 	 = "template";

		public $debug  		= false;
		public $force  		= false;
		public $filtro 		= array();
		public $database  	= "";
		
		private $host 		= "";
		private $user 		= "";
		private $senha 		= "";
		public $db 			= "";
		private $filSel		= array();
		private $ret		= array();
		private $historic	= array();
		private $query		= '';
		private $dbObj;
		private $lastInsertId;
		private $utf8 = false;
		
		protected static $persistent = false;
		
		private static function ordenaParams($a,$b){

			if(strlen($a->name)==strlen($b->name)){
				return 0;
			}

			if(strlen($a->name)>strlen($b->name)){
				return -1;
			}else{
				return 1;
			}

		}

		private function cleanValue($value){
			$val = $value;
			$trocar = array(
				"drop ",
				"DROP ",
				"insert ",
				"INSERT ",
				"delete ",
				"DELETE ",
				"create ",
				"CREATE ",
				" update ",
				" UPDATE ",
				" replace ",
				" REPLACE ",
				"--",
				"';",
				");"
			);
			$val = str_replace($trocar,"",$val);

			return $val;
		}

		private function queryRise($query){

			if(gettype($this->filSel->params)!="array"){
			
				echo "O params deve ser um array, mesmo que vazio.<br>";
				
			} else {
			
				if(count($this->filSel->params)>0){
				
					usort($this->filSel->params,'self::ordenaParams');

					foreach($this->filSel->params as $params){

						if($params->type=='string'){
							$query = str_replace('-}'.$params->name,"'".$this->cleanValue($params->value)."'",$query);
						}elseif($params->type=='integer'){
							$query = str_replace('-}'.$params->name,(int)$this->cleanValue($params->value),$query,$cnt);
						}elseif($params->type=='other'){
							$query = str_replace('-}'.$params->name,$this->cleanValue($params->value),$query);
						}elseif($params->type=='float'){
							$floatval = floatval($this->cleanValue($params->value));
							$floatval = str_replace(',','.',$floatval);
							$query = str_replace('-}'.$params->name,$floatval,$query);
						}

					}
					
				}			

			}
	
			if($this->force===true){
				if($this->database!=""){
					$this->dbObj->query("use ".$this->database.";");
				}else{
					exit('O parâmetro database não foi configurado.');
				}
			}
			
			if($this->utf8===true){
				$this->dbObj->query('set names utf8');
			}
			
			if($execQuery = $this->dbObj->query($query)){

				if(strtolower(substr(str_replace(" ", "", $query),0,6))!='select'){
					$retorno = 'Template '.$this->filSel->cod.': OK';
				}else{

					$retorno = $execQuery->fetchAll(PDO::FETCH_ASSOC);
				}
				
				array_unshift($this->ret,$retorno);

			}else{
				if($this->debug===true){
					echo "Erro: A query não foi executada com sucesso.<br>.".json_encode(self::$instance->errorInfo())."<br>".$query."<br>TP: ".$this->filSel->cod."<br><br>";
				}else{
					echo $this->getError(json_encode(self::$instance->errorInfo()).$query)."<br>";
				}
			}

			$this->lastInsertId = $this->dbObj->lastInsertId();
			$this->dbObj->connection = null;
			$this->query = $query;
			
			$this->utf8 = false;
			
			return $query;
			
		}

		private function getError($str){
			$isFk = strpos($str,'FOREIGN KEY');

			if($isFk>0){
				$isDeleteUpdate = strpos($str,'Cannot delete or update');
				$campo = strpos($str,'FOREIGN KEY');
				$campoFim = strpos($str,'`) REF');
				$references = strpos($str,'REFERENCES');
				$referencesFim = strpos($str,'` (`');

				$tabela = substr($str,$references+12,$referencesFim-($references+12));
				$nomeCampo = substr($str,$campo+14,$campoFim-($campo+14));

				$tabelas = array(
					'agenda'=>'Agenda',
					'agenda_categoria'=>'Agenda categoria',
					'atendimento'=>'Atendimento',
					'aviso'=>'Aviso',
					'baixa_parcial'=>'Baixa parcial',
					'cad_equipam_os'=>'Cadasro de equipamento da os',
					'ccusto'=>'Centro de custo',
					'cfo'=>'Cfop',
					'cheque'=>'Cheque',
					'condpagto'=>'Condição de pagamento',
					'conta'=>'Conta',
					'contrato'=>'Contrato',
					'credor'=>'Credor',
					'custo'=>'Custo',
					'docto'=>'Docto',
					'etapaprod'=>'Etapaprod',
					'etapaprod_nota'=>'Etapaprod nota',
					'faixa_atraso'=>'Faixa de atraso',
					'faixa_atraso_cad'=>'Faixa de atraso cad',
					'header_cte'=>'Cte',
					'header_inv'=>'Inventário',
					'header_nfse'=>'Nota fiscal de serviço',
					'header_nota'=>'Nota fiscal',
					'header_os'=>'Ordem de serviço',
					'item_inv'=>'Item do inventário',
					'item_nota'=>'Item da nota',
					'item_oc'=>'',
					'item_os'=>'Item da ordem de serviço',
					'item_ped_esp'=>'Item do pedido especial',
					'lancto'=>'Lançamento',
					'layout'=>'Layout',
					'licitacao'=>'Licitação',
					'licitacao_equip'=>'Equipamento da licitação',
					'licitacao_hist'=>'Histórico da licitação',
					'log'=>'Log',
					'log_facil'=>'Log fácil',
					'magnetico'=>'Magnético',
					'mag_log'=>'log do magnético',
					'nfse_servico'=>'Serviço da NFSe',
					'nossonumero'=>'Nosso número',
					'nota_docto'=>'Relação nota/documento',
					'nota_inutilizada'=>'Nota inutilizada',
					'ordem_compra'=>'Ordem de compra',
					'ors_ceq'=>'Equipamento da OS',
					'os_grupo'=>'Grupo da OS',
					'os_historico'=>'Historico da OS',
					'os_marca'=>'Marca da OS',
					'os_produto'=>'Produto da OS',
					'os_servico'=>'Serviço da OS',
					'os_subgrupo'=>'Subgrupo da OS',
					'os_tipo'=>'Tipo da OS',
					'os_tpcobr'=>'Tipo de cobrança da OS',
					'os_tpequipam'=>'Tipo de equipamento da OS',
					'pdv'=>'Pdv',
					'pdv_cad'=>'Cadastro PDV',
					'ped_esp'=>'Pedido especial',
					'ped_esp_status'=>'Status do pedido especial',
					'plano_conta'=>'Plano de conta',
					'proddif'=>'Proddif',
					'proddif_nota'=>'Proddif nota',
					'proddif_referencia'=>'Proddif referencia',
					'rateio_debito'=>'Rateio de débito',
					'referencia_docto'=>'Referencia documento',
					'referencia_hist'=>'Referencia_histórico',
					'retorno_arquivo'=>'Retorno arquivo',
					'retorno_remessa'=>'Retorno remessa',
					'serie'=>'Série',
					'servico'=>'Serviço',
					'tabpreco'=>'Tabela de preço',
					//comum
					'agrupamento'=>'Agrupamento',
					'cad_cad'=>'Relacionamento de Cadastro',
					'cadastro'=>'Cadastro',
					'categoria'=>'Categoria',
					'composicao'=>'Composição',
					'contato'=>'Contato',
					'cor'=>'Cor',
					'email'=>'Email',
					'endereco'=>'Endereco',
					'etapa_prod'=>'Etapa de produção',
					'etp_orp'=>'Etp_orp',
					'etqtermic'=>'Etiqueta térmica',
					'evento'=>'Evento',
					'formula'=>'Fórmula',
					'fornecedor'=>'Fornecedor',
					'frequencia'=>'Frequência',
					'frequencia_servico'=>'Frequência do serviço',
					'grade'=>'Grade',
					'grupo'=>'Grupo',
					'kit'=>'Kit',
					'local'=>'Local',
					'lote'=>'Lote',
					'lote_fabr'=>'Lote fabricante',
					'lote_fabr_item'=>'Item do lote fabricante',
					'marca'=>'Marca',
					'ocorrencia'=>'Ocorrência',
					'ordem_prod'=>'Ordem de produção',
					'ordem_prod_almox'=>'Almoxarifado da ordem de produção',
					'ordem_prod_item'=>'Item da ordem de produção',
					'ordem_vetor'=>'Ordem vetor',
					'ramo_atividade'=>'Ramo de atividade',
					'referencia'=>'Produto',
					'referencia_correspondente'=>'Produto correspondente',
					'saldostk'=>'Saldo de estoque',
					'servico'=>'Serviço',
					'setor'=>'Setor',
					'setor_atividade'=>'Setor atividade',
					'site'=>'Site',
					'subcategoria'=>'Subcategoria',
					'subgrupo'=>'Subgrupo',
					'tamanho'=>'Tamanho',
					'telefone'=>'Telefone',
					'tipo_atendimento'=>'Tipo de atendimento',
					'tributacao'=>'Tributação',
					'unidade'=>'Unidade',
					'unidade_referencia'=>'Unidade referencia',
					'veiculo'=>'Veículo'
				);

				$str = strstr($str, '"]',false);

				$ponteiroUm = strpos($str,'(');
				$posteiroDois = strpos($str,')');

				$strUm = substr($str,$ponteiroUm+1,$posteiroDois-($ponteiroUm+1));
				$strUm = str_replace(" ","",$strUm);
				$arrayUm = explode(",",$strUm);

				$strDois = strstr($str, 's (',false);
				$strDois = substr($strDois,3,-1);
				$strDois = str_replace(", ",",",$strDois);
				$arrayDois = explode(",",$strDois);

				$cntArrayUm = count($arrayUm);
				$cntArrayDois = count($arrayDois);
				
				if($cntArrayUm == $arrayDois){
					$array = array_combine($arrayUm,$arrayDois);
					if(isset($array[$nomeCampo]) && isset($tabelas[$tabela])){
						if($isDeleteUpdate){
							return "<span style='color:#ff0000;'>O valor ".$array[$nomeCampo]." não está cadastrado no módulo: ".$tabelas[$tabela]."</span>";
						}else{
							return "<span style='color:#ff0000;'>O valor ".$array[$nomeCampo]." não está cadastrado no módulo: ".$tabelas[$tabela]."</span>";
						}
					}else{
						return "<span style='color:#ff0000;'>Este registro é uma chave estrangeira e não pode ser excluído.</span>";
					}
				}else{
					return "<span style='color:#ff0000;'>Este registro é uma chave estrangeira e não pode ser excluído.</span>";
				}


			}else{
				return $str;
			}

		}
		
		private function getTemplate(){
			foreach($this->filtro as $filtro){

				if($filtro = json_decode($filtro)){

					$this->filSel = $filtro;
					$template 	  = $filtro->cod;

					try{
						$this->dbObj = Datapacket::getInstance();
						$tpQueryStr	 = "select * from ".$this->dbSys.".".$this->templateTable." where query_cod='".$template."'";

						if($tpQuery = $this->dbObj->query($tpQueryStr)){

							$tpRet 		= $tpQuery->fetchAll(PDO::FETCH_ASSOC);
							$qryMontada	= $tpQuery->queryString;
							// $qrySel	= $tpRet[0]['tpl_query'];
							if(count($tpRet)>0){
								$qrySel	= $tpRet[0]['query_sql'];
								$this->queryRise($qrySel);
							}else{
								echo "Erro: A template não foi encontrada.<br>".$template."<br>";
							}
						}else{
							echo "Erro: A query para selecionar a template não foi executada com sucesso. Database:".$this->dbSys." - Table:".$this->templateTable."<br>Query:".$tpQueryStr;
						}

					}catch(PDOException $e){
						echo "Erro: ".$e->getMessage();
					}
				}else{
					echo "A classe não conseguiu decodificar o JSON.<br><br>";
				}
			}		
		}
		
		public static function close(){
			
			if (self::$instance!=null){
				self::$instance = null;
			}

		}

		public function setHost($params){
			
			$params = explode(":",$params);
			
			if($params[3]!=$this->db){
				$this->host	 = $params[0];
				$this->user	 = $params[1];
				$this->senha = $params[2];
				$this->db	 = $params[3];
				
				self::$instance = null;
				$this->getInstance();
			}
		
		}
		
		public function debug($param){
			$this->debug=$param;
		}
		 
		private function getInstance(){

			if(self::$persistent != false){
				self::$persistent = true;
			}
			
			if(!isset(self::$instance)){
				if($this->force==false){
					try {

						self::$instance = new PDO(self::$dbType.':host='.$this->host.';dbname='.$this->db,$this->user,$this->senha,array(PDO::ATTR_PERSISTENT=>self::$persistent));

					}catch(PDOException $ex) {
						exit ("Erro ao tentar se conectar com o banco de dados: " . $ex->getMessage());
					}
				}else{
					try {
						self::$instance = new PDO(self::$dbType.':host='.$this->host.';dbname=empresas',$this->user,$this->senha,array(PDO::ATTR_PERSISTENT=>self::$persistent));
					}catch(PDOException $ex) {
						self::$instance = null;
						exit ("Erro ao tentar se conectar com o banco de dados: " . $ex->getMessage());
					}
				}
			}

			if(self::$instance){
				return self::$instance;
			}
		}

		public function add($filtro){
			array_unshift($this->filtro,$filtro);
		}

		public function open($json=false, $lastInsertId=false, $antiLoop=false){

			if(self::$instance!=null){
				self::getTemplate();

				if(isset($this->ret) && count($this->ret)>0){
					$this->ret = $this->ret[0];
				}

				if(gettype($json)=="string"){
					$strRet = '{"'.$json.'":'.json_encode($this->ret).'}';
					$strRet = preg_replace('/\x03/', '', $strRet);
					$this->ret = json_decode($strRet, false);
				}else if($json==true){
					$strRet = json_encode($this->ret);
					$strRet = preg_replace('/\x03/', '', $strRet);
					$this->ret = json_decode($strRet, false);
				}else if($lastInsertId==true){
					$this->ret = $this->lastInsertId;
				}else{
					$strRet = json_encode($this->ret);
					$strRet = preg_replace('/\x03/', '', $strRet);
					$this->ret = json_decode($strRet, true);
				}

				if(gettype($this->ret)=='NULL' && $antiLoop===false){
					$this->utf8 = true;
					$this->ret = array();
					$antiLoop = true;
					return $this->open($json,$lastInsertId);
				}else{
					return $this->ret;
				}
			}

		}

		public function getJson($json=false){
			
			self::getTemplate();

			$this->ret = $this->ret[0];

			$strRet = json_encode($this->ret);
			$strRet = preg_replace('/\x03/', '', $strRet);
			$this->ret = json_decode($strRet, FALSE);

			$jsonRet = new stdClass();
			$jsonRet->success = 'true';
			/*$jsonRet->message = 'A consulta foi executada com sucesso';*/
			$jsonRet->data	  = $this->ret;
			$jsonRet->total	  = count($this->ret);
			
			if($json==false){
				$jsonRet = json_encode($jsonRet);
			}
			
			return $jsonRet;
			
		}
		
		public function getRecordCount(){
			return count($this->ret);
		}
		
		public function clear(){
		
			if($this->db!=""){
				$pdoObjt = array(
					"query" => $this->query,
					"rowdata" => $this->ret,
					"filtro"	=> $this->filtro
				);
				array_unshift($this->historic,$pdoObjt);
			}

			$this->ret		 = array();
			$this->filtro	 = array();
			$this->filSel 	 = array();
			$this->database  = '';
			$this->query 	 = '';
			$this->utf8 	 = false;
		}
		
		public function setForce($value){
			$this->force = $value;
		}
		
		public function setUtf8($value){
			$this->utf8 = $value;
		}
		
		public function setDatabase($value){
			$this->database = $value;
		}
		
		public function getLastQuery(){
			return "getLastQuery = ".$this->query;
		}
		
		public function getHistoric(){
			return $this->historic;
		}
		
		public function getFilter(){
			return $this->filtro;
		}
		
		public function changeEngine($engine){
			$eng 				 = explode('.',$engine);
			$this->dbSys 		 = $eng[0];
			$this->templateTable = $eng[1];
		}
		
	}
	
	/*
		Utilização:
		1 - declarar a classe Datapacket
		2 - inserir o host de conexao
		3 - inserir um ou mais filtros
		4 - abrir a conexao (isto abrirá a conexão e percorrerá os filtros adicionados retornando um array ou um objeto
			4.1 - o método open aceita um parametro que controla o tipo do retorno. Default false = retorna um array, true = retorna um objeto.

		//1
		$datapacket = new Datapacket();	
		//2
		$datapacket->setHost('192.168.1.246:adm:adm@123:fausto');
		//3
		$datapacket->add('{"cod":"000001","params":[{"name":"usu_codigo","value":"1","type":"integer"},{"name":"usu_codigob","value":"2","type":"integer"}]}');
		//4
		$ret = $datapacket->open(true); ou open(propriedade [string]) para retornar um json com uma propriedade 
	*/
?>