<?php 
	header('Access-Control-Allow-Origin: *'); 
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');

	include 'TParams.class.php';
	include 'funcoes.php';
	
	$datapacket = new TParams();
	$company = $datapacket->getCompany();
	
	if(!isset($_REQUEST['not_codigo']) || empty($_REQUEST['not_codigo'])) exit("Nenhum código de nota informado ");
	$not_codigo = $_REQUEST['not_codigo'];

	$filtro = '{"cod":"501190","params":[
		{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$retorno = $datapacket->open(true);
	$datapacket->clear();
	$pedido = $retorno[0];

	$filtro = '{"cod":"501191","params":[
		{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
		{"name":"database","value":"'.$datapacket->getDb().'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$produtos = $datapacket->open(true);
	$datapacket->clear();

	$filtro = '{"cod":"501192","params":[
		{"name":"not_codigo","value":"'.$pedido->{'not_codigo'}.'","type":"string"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$parcelas = $datapacket->open(true);
	$datapacket->clear();

	$dataHora = explode(" ", $pedido->{'not_data'});
	define("__UPLOADS__", "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" .  $company->{"emp_codigo"} . "/");
	define("__HOSTROOT__", "http://" . $_SERVER["SERVER_NAME"] . "/" . str_replace($_SERVER['DOCUMENT_ROOT'], "", substr($_SERVER['SCRIPT_FILENAME'], 0, strrpos($_SERVER['SCRIPT_FILENAME'], "php/"))));
	define("__CURLMSG__", __HOSTROOT__ . "php/mensagem.php");
	define("__EMPLOGO__", "http://" . $_SERVER["SERVER_NAME"] . "/uploads/" .  $company->{"emp_codigo"} . "/" . $company->{"emp_logo"});
	
	define("__COREMAIL__", "#107FC4");
	define("__IDPEDIDO__", $pedido->{"id"});
	define("__CLINOME__", $pedido->{"cad_nomeraz"});
	define("__TOTALPEDIDO__", $pedido->{'not_totalnota'});
	define("__STATUSPEDIDO__", $pedido->{"ecm_status"});
	define("__DATAPEDIDO__", date("d/m/Y", strtotime($dataHora[0])));
	define("__HORAPEDIDO__", $dataHora[1]);
	define("__PAGTOPEDIDO__", $pedido->{'cdp_descr'});
	define("__CODTRANSCART__", $pedido->{"ecm_cart_cod_trans"});
	define("__TPFRETE__", $pedido->{"ecm_tpfrete"});
	define("__VALORFRETE__", $pedido->{"ecm_valor_frete"});
	define("__PRAZOFRETE__", $pedido->{"ecm_prazo_frete"});
	define("__ENDCLI__", $pedido->{"end_nome"} . ', ' . $pedido->{"end_num"} .' '. $pedido->{"end_compl"});
	define("__BAIRROCLI__", $pedido->{"end_bairro"});
	define("__CEPCLI__", $pedido->{"end_cep"});
	define("__EMAILCLI__", $pedido->{'cad_email'});
	define("__CODBOLETO__ ", $parcelas[0]->{'doc_codigo'});
	define("__CLICOD__", $pedido->{'cad_codigo'});
	define("__TOTALPARCELAS__", $parcelas[0]->{"doc_tparc"});

	$arrIndicesAcompanhamento = array(
		array('titulo' => 'Aguardando Pagamento', 'codigo' => 1), 
		array('titulo' => 'Pagamento Confirmado', 'codigo' => 3), 
		array('titulo' => 'Em Expedição', 'codigo' => 4),
		array('titulo' => 'Enviado', 'codigo' => 5)
	);

	ob_start();

?>
	<table cellpadding="0" cellspacing="0" width="100%" bgcolor="#FFF" style=" font-family: sans-serif;">
		
		<!-- CABECALHO -->
		<tr>
			<td align="center">
				<table cellpadding="0" cellspacing="0" width="600" height="80">
					<tr>
						<td width="200" align="center" height="80" bgcolor="#ccc">
							<img src="<?php echo __EMPLOGO__; ?>" alt="HGArts - Pintura Hidrográfica" width="130">
						</td>
						<td width="400" align="center" height="80" bgcolor="<?php echo __COREMAIL__; ?>" style="color: #fff; font-size: 18px;">
							Recebemos seu pedido! <span style="font-weight: bold;">#<?php echo __IDPEDIDO__; ?></span>
						</td>
					</tr>
				</table>	
			</td>
		</tr>
		<!--/CABECALHO -->

		<!-- STATUS -->
		<tr>
			<td align="center">
				<table bgcolor="#f6f6f6" width="600" style="color: #989898; padding: 12px;">
					<tr>
						<td height="64">
							Olá <?php echo __CLINOME__; ?>,							
						</td>
					</tr>
					<tr>
						<td>
							Recebemos seu pedido com sucesso. 
							Caso exista alguma divergência nas informações abaixo entre em contato imediatamente no seguinte e-mail:
						</td>
					</tr>
					<tr>
						<td height="64" align="center" style="font-size: 18px;">							
							<a href="mailto:<?php echo $company->{'emp_emailremetente'}; ?>" style="color: <?php echo __COREMAIL__; ?>; text-decoration: none;"><?php echo $company->{'emp_emailremetente'}; ?></a>
						</td>
					</tr>
					<tr>
						<td>							
							Acompanhe seu pedido
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<!--/STATUS -->

		<!-- ACOMPANHAMENTO -->
		<tr>
			<td align="center">
				<table bgcolor="<?php echo __COREMAIL__; ?>" width="600" style="color: #0d4f77; font-weight: 600; padding: 12px;">
					<tr>
						<?php 
							foreach($arrIndicesAcompanhamento as $acompanhamento):
								?>
									<td height="50">
										<table style="text-align: center">
											<tr>
												<td style="color: <?php echo (__STATUSPEDIDO__ >= $acompanhamento['codigo']) ? '#fff' : '#0d4f77' ?>;"><?php echo (__STATUSPEDIDO__ >= $acompanhamento['codigo']) ? '&#x2713;' : '&#9658' ?></td>
												<td style="color: <?php echo (__STATUSPEDIDO__ >= $acompanhamento['codigo']) ? '#fff' : '#0d4f77' ?>;"><?php echo $acompanhamento['titulo'] ?></td>
											</tr>
										</table>
									</td>
								<?php 
							endforeach; 
						?>						
					</tr>					
				</table>
			</td>			
		</tr>	
		<!--/ACOMPANHAMENTO -->

		<!-- DADOS PAGAMENTO/DADOS ENTREGA -->
		<tr>
			<td align="center">
				<table bgcolor="#f6f6f6" width="600">
					<tr>
						<td align="center" style="color: <?php echo __COREMAIL__; ?>;" height="32">
							Data e hora do pedido: <?php echo data($dataHora[0]); ?> às <?php echo $dataHora[1]; ?>
						</td>
					</tr>					
				</table>
			</td>
		</tr>	

		<tr>
			<td align="center">
				<table bgcolor="#fff" width="600">
					<tr>
						<td align="center" style="color: #6d6d6d;" height="32">
							Valor total do pedido: <span style="font-weight: bold; color: <?php echo __COREMAIL__; ?>"><?php echo valorFormat(__TOTALPEDIDO__); ?></span>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td align="center">
				<table width="600" style=" color: #474747; padding-bottom: 12px; padding-top: 12px;">					
					<tr>
						<td width="300" style="border-right: 2px solid #bbb;">
							<table style="font-size: 13px;padding: 12px;">
								
								<tr>
									<td colspan="2" height="32" style="font-weight: bold;">Dados do pagamento</td>									
								</tr>
								
								<tr>
									<td style="font-weight: bold;">Pago com:</td>
									<td><?php echo __PAGTOPEDIDO__; ?></td>
								</tr>
								
								<?php 
									if(__PAGTOPEDIDO__ != "deposito") {
										?>
											<tr>
												<td style="font-weight: bold;">Nº transação:</td>
												<td><?php echo __CODTRANSCART__; ?></td>
											</tr>
											<tr>
												<td style="font-weight: bold;">Parcelas:</td>
												<td><?php echo __TOTALPARCELAS__; ?></td>
											</tr>
										<?php 
									} 
								?>
								
								<tr>
									<td style="font-weight: bold;">Status do pedido:</td>
									<td><?php echo utf8_encode(__STATUSPEDIDO__); ?></td>
								</tr>									
								
								<?php 
									if(__PAGTOPEDIDO__ == "boleto"){
										?>
											<tr>
												<td style="font-weight: bold;">Imprimir boleto:</td>
												<td><a href="http://facil.uds.com.br/desktop/rel/relboleto.php?doc_codigo=<?php echo __CODBOLETO__; ?>&p=<?php echo substr(base64_encode($company->{'emp_codigo'}), 0, 1)?>4<?php echo substr(	base64_encode($company->{'emp_codigo'}), 1, strlen(base64_encode($company->{'emp_codigo'}))) ?>" target="_blank" style="	color: #107fc4; text-decoration: none;"><?php echo __CODTRANSCART__; ?></a></td	>
											</tr>
										<?php 
									} 
								?>

							</table>
						</td>
						
						<td width="300">
							<table style="font-size: 13px;padding: 12px;">
								<tr>
									<td colspan="2" height="32" style="font-weight: bold;">Dados de entrega</td>							
								</tr>
								<tr>
									<td style="font-weight: bold;">Tipo de envio:</td>
									<td><?php echo (__TPFRETE__ == 1) ? "PAC" : "SEDEX"; ?></td>
								</tr>
								<tr>
									<td style="font-weight: bold;">Valor:</td>
									<td><?php echo valorFormat(__VALORFRETE__); ?></td>
								</tr>
								<tr>
									<td style="font-weight: bold;">Prazo:</td>
									<td><?php echo (__PRAZOFRETE__ == 1) ? __PRAZOFRETE__ . "dia útil" : __PRAZOFRETE__ . " dias úteis"; ?></td>
								</tr>
								<tr>
									<td style="font-weight: bold;">Endereço:</td>
									<td><?php echo __ENDCLI__ ?></td>
								</tr>
								<tr>
									<td style="font-weight: bold;">Bairro:</td>
									<td><?php echo __BAIRROCLI__; ?></td>
								</tr>
								<tr>
									<td style="font-weight: bold;">CEP:</td>
									<td><?php echo cep(__CEPCLI__); ?></td>
								</tr>
							</table>
						</td>

					</tr>

				</table>

			</td>

		</tr>
		<!-- DADOS PAGAMENTO/DADOS ENTREGA -->

		<!-- LISTAGEM PRODUTO -->		
		<tr>
			<td align="center">
				<table width="600" bgcolor="#107fc4">
					<tr>
						<td height="32" align="center" style="font-size: 18px; color: #fff;">
							Seus produtos
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td align="center" height="80">
				<table width="600" style="padding: 12px; color: #474747;">

					<thead>
						<tr>
							<th>Foto</th>
							<th>Produto</th>
							<th>Quantidade</th>
							<th>Preço</th>
						</tr>
					</thead>
			
					<tbody>

						<!-- FOR EACH AQUI -->
						<?php 

							if(!empty($produtos)) {

								foreach($produtos as $produto){	

									if(!empty($produto->{'ref_codbase'})){

										$titulo = isset($produto->{'base_descr'}) ? $produto->{'base_descr'} . "<br>" : "";
										$imagem = "&nbsp";
										if(!empty($produto->{"base_img"})){
											$imagens = json_decode(base64_decode($produto->{"base_img"}));
											@usort($imagens, "verificador");
											$imagem = '<img src="'. __UPLOADS__ . '/produtos/' . $produto->{'base_codigo'} .'/thumbs/'. $imagens[0]->{'imagem'} .'"  height="100" alt="'. $titulo .'">';
										}

									} else {

										$titulo = isset($produto->{'ref_descr'}) ? $produto->{'ref_descr'} . "<br>" : "";
										$imagem = "&nbsp";
										if(!empty($produto->{"ref_img"})){
											$imagens = json_decode(base64_decode($produto->{"ref_img"}));
											@usort($imagens, "verificador");
											$imagem = '<img src="'. __UPLOADS__ . '/produtos/' . $produto->{'ref_codigo'} .'/thumbs/'. $imagens[0]->{'imagem'} .'"  height="100" alt="'. $titulo .'">';
										}
									}
									
									?>

										<tr>
											<td height="80"> <?php echo $imagem; ?></td>
											<td height="80"><?php echo  $titulo; ?></td>
											<td height="80" style="text-align: center;"><?php echo qtde($produto->{'itn_qtde'}); ?></td>
											<td height="80" style="text-align: center;"><?php echo  valorFormat($produto->{"itn_subtotal"}); ?></td>
										</tr>
									<?php
								}
							}
						?>					
						<!--.FOR EACH AQUI -->						

					</tbody>
				</table>
			</td>
		</tr>
		<!-- LISTAGEM PRODUTO -->
		
		<tr>
			<td align="center">
				<table width="600" bgcolor="#107fc4">
					<tr>
						<td height="32" align="center" style="font-size: 18px; color: #fff;">
							<?php echo $company->{"emp_fantasia"} . " | " . tele($company->{"emp_fone"}) ;?>
							<?php echo (isset($company->{"emp_cel"}) && $company->{"emp_cel"}!="") ? " | ".tele($company->{"emp_cel"}) : ""; ?>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>

<?php
	
	if(isset($_REQUEST['email'])){

		$texto = ob_get_contents();
		ob_end_clean();

		/* REGISTRO DE E-MAIL PARA O FÁCIL */

			// Enviando o email para o FACIL através de uma requisição POST
			$fields = array(
				'p' => $_REQUEST['p'],
				'acao' => urlencode('salvar'),
				'msg_codigo' => urlencode(''),
				'msg_tipo' => urlencode(1),
				'men_codigo' => urlencode(null),
				'msg_remetente' => urlencode($company->{'emp_emailremetente'}),
				'msg_destinatario' => urlencode(__EMAILCLI__),
				'cad_codigo' => urlencode(__CLICOD__),
				'msg_assunto' => urlencode($company->{'emp_fantasia'} . ' - Pedido Recebido!'),
				'msg_conteudo' => urlencode($texto),
				'msg_dtenvio' => urlencode(date('d/m/Y H:i:s', time())),
				'msg_anexo' => urlencode('')
			);

			$fields_string = ''; //url-ify the data for the POST
			foreach($fields as $key => $value) $fields_string .= $key.'='.$value.'&';
			rtrim($fields_string, '&');

			if(!empty($fields_string)){
				$ch = curl_init(); //Abre conexão
				curl_setopt($ch,CURLOPT_URL, __CURLMSG__); //Seta URL
				curl_setopt($ch,CURLOPT_POST, count($fields)); //Seta quantidade de campos
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string); //Seta valores dos mesmos
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // ativa o retorno do curl
				$codigoSalvo = curl_exec($ch); //Executa o post
				curl_close($ch); //Fecha conexão
			}

		/**************************************************/


		/* ENVIO DE E-MAIL NO FÁCIL */

			// Enviando o email para o FACIL através de uma requisição POST
			$fields = array(
				'p' => $_REQUEST['p'],
				'acao' => urlencode('enviar'),
				'msg_codigo' => urlencode(str_replace('ok', '', $codigoSalvo)),	
			);

			$fields_string = ''; //url-ify the data for the POST
			foreach($fields as $key => $value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			if(!empty($fields_string)){
				$ch = curl_init(); //Abre conexão
				curl_setopt($ch,CURLOPT_URL, __CURLMSG__); //Seta URL
				curl_setopt($ch,CURLOPT_POST, count($fields)); //Seta quantidade de campos
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string); //Seta valores dos mesmos
				$resultadoEnvio = curl_exec($ch); //Executa o post
				curl_close($ch); //Fecha conexão
			}

		/**************************************/
	}

?>