<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	date_default_timezone_set("America/Sao_Paulo");
	
	include 'TParams.class.php';
	$datapacket = new TParams();
	
	$company = $datapacket->getCompany();
		
	$filtro = '{"cod":"700547","params":[
		{"name":"db","value":"'.$datapacket->getDbSge().'","type":"other"},
		{"name":"emp_codigo","value":"'.$datapacket->getCodigo().'","type":"string"}
	]}';

	$datapacket->setHost($datapacket->getHost($datapacket->getDb()));
	$datapacket->add($filtro);
	$ret = $datapacket->open(true);
	$datapacket->clear();
	
	if(is_array($ret)){
		$arq = fopen($datapacket->uploads."AFABRICA/prod.txt", "w");
		foreach($ret as $r){
			$r->uni_codigo = ($r->uni_codigo && $r->uni_codigo!='null') ? $r->uni_codigo : 'UN';
			$r->saldo = ($r->saldo_stk>0) ? number_format($r->saldo_stk, 2, '.', '') : '0.00';
			$r->custo = ($r->custo>0) ? number_format($r->custo, 2, '.', '') : '0.00';
			$barra = ($r->ref_codbar && $r->ref_codbar!='') ? 'S' : 'N';
			$r->ref_ncm = ($r->ref_ncm && $r->ref_ncm!='' && $r->ref_ncm!='null') ? $r->ref_ncm : '00000000';
			$r->ref_cest = ($r->ref_cest && $r->ref_cest!='' && $r->ref_cest!='null') ? $r->ref_cest : '0000000';
			$aliqicms = ( isset($r->tri_aliqicms) && $r->tri_aliqicms>0 ) ? number_format($r->tri_aliqicms,2,'','') : '0000';
			$csosn = ( isset($r->tri_csosn) && $r->tri_csosn!='' ) ? $r->tri_csosn : '102';
			
			$texto = str_pad($r->ref_codigo,14,'0', STR_PAD_LEFT).str_pad(substr(trim($r->ref_descr),0,45),45,' ', STR_PAD_RIGHT).str_pad(number_format($r->ref_preco,2,'.',''),13,'0', STR_PAD_LEFT).str_pad($r->saldo,10,'0', STR_PAD_LEFT)."T".str_pad($aliqicms, 4, '0', STR_PAD_LEFT).str_pad($r->uni_codigo,3,' ', STR_PAD_LEFT)."00.00N".$barra.$csosn.$r->ref_ncm.str_pad($r->custo,13,'0', STR_PAD_LEFT).str_pad($r->ref_cest,8,'0', STR_PAD_LEFT)."\r\n";
			
			fwrite($arq, $texto);
		}
		fclose($arq);
	}
	
		
?>