<?php 

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
include 'datapacket.php';
include 'TParams.class.php';

$datapacket = new Datapacket();
$TParams = new TParams();
$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
$company = $TParams->getCompany();

if (isset($_POST["acao"]) && $_POST["acao"] == "salvar") {
	
	//LOG / HISTORICO
	if( $_POST["ipj_codigo"]!="" ){
				//dados para comparar
		$filtro = '{"cod":"700728","params":[
			{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$comp = $datapacket->open();
		$datapacket->clear();
		
		$pjh_historico = "";
		if( isset($comp) && isset($comp[0]) && isset($comp[0]["ipj_titulo"])){
			
			if($comp[0]["ipj_titulo"]!=$_POST["ipj_titulo"]){
				$pjh_historico .= "Alterou o título de '".$comp[0]["ipj_titulo"]."' para '".$_POST["ipj_titulo"]."'<br>";
			}
			if(base64_decode($comp[0]["ipj_descr"])!=utf8_decode($_POST["ipj_descr"])){
				$pjh_historico .= "Alterou a descrição do projeto<br>";
			}
			if(isset($_POST['ipj_data']) && $_POST['ipj_data']!="" && $comp[0]["ipj_data"]!=implode("-", array_reverse(explode("/", substr($_POST['ipj_data'],0,10))))){
				$pjh_historico .= "Alterou a data do Projeto para ".substr($_POST['ipj_data'],0,10)."<br>";
			}
			if($comp[0]["cad_codigo"]!=$_POST["cad_codigo"]){
				$pjh_historico .= "Alterou o cliente do Projeto<br>";
			}
			if($comp[0]["cad_responsavel"]!=$_POST["cad_responsavel"]){
				$pjh_historico .= "Alterou o responsável pelo Projeto<br>";
			}
			if($comp[0]["svc_codigo"]!=$_POST["svc_codigo"]){
				$pjh_historico .= "Alterou o serviço do Projeto<br>";
			}
			if($comp[0]["cdp_codigo"]!=$_POST["cdp_codigo"]){
				$pjh_historico .= "Alterou a condição de pagamento do Projeto<br>";
			}
			if($comp[0]["ipj_valor"]!=$_POST["ipj_valor"]){
				$pjh_historico .= "Alterou o valor do Projeto para ".number_format($_POST["ipj_valor"],2,",",".")."<br>";
			}
			
			if($pjh_historico!=""){
				$filtro = '{"cod":"700727","params":[
					{"name":"pjh_tipo","value":"0","type":"integer"},
					{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
					{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
					{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
					{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
					{"name":"pjh_historico","value":"' . base64_encode(utf8_decode($pjh_historico)) . '","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
			}
			
		}
		
		$_POST['etp_codigo'] = $comp[0]["etp_codigo"];
	}
	
	//SALVAR
	$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'");
	$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "");

    $filtro = '{"cod":"700708","params":[
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"etp_codigo","value":"' . $_POST['etp_codigo'] . '","type":"integer"},
		{"name":"prj_codigo","value":"' . $_POST['prj_codigo'] . '","type":"integer"},
		{"name":"ipj_titulo","value":"' . str_replace($arr1, $arr2, $_POST['ipj_titulo']) . '","type":"string"},
		{"name":"ipj_descr","value":"' . base64_encode(utf8_decode($_POST['ipj_descr'])) . '","type":"string"},
		{"name":"ipj_data","value":"' .  implode("-", array_reverse(explode("/", substr($_POST['ipj_data'],0,10)))) . '","type":"string"},
		{"name":"ipj_hora","value":"' .  $_POST['ipj_hora'] . '","type":"string"},
		{"name":"cad_codigo","value":"' .  $_POST['cad_codigo'] . '","type":"string"},
		{"name":"cad_responsavel","value":"' .  $_POST['cad_responsavel'] . '","type":"string"},';
	$filtro.= ($_POST['svc_codigo']!="") ? '{"name":"svc_codigo","value":"' .  $_POST['svc_codigo'] . '","type":"integer"},' : '{"name":"svc_codigo","value":"NULL","type":"other"},';
	$filtro.= '{"name":"ipj_valor","value":"' .  $_POST['ipj_valor'] . '","type":"float"},';
	$filtro.= ($_POST['cdp_codigo']!="") ? '{"name":"cdp_codigo","value":"' .  $_POST['cdp_codigo'] . '","type":"integer"},' : '{"name":"cdp_codigo","value":"NULL","type":"other"},';
	$filtro.= ($_POST['cta_codigo']!="") ? '{"name":"cta_codigo","value":"' .  $_POST['cta_codigo'] . '","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
	$filtro.= '{"name":"ccu_codigo","value":"' .  $_POST['ccu_codigo'] . '","type":"string"},
		{"name":"plc_codigo","value":"' .  $_POST['plc_codigo'] . '","type":"string"},
		{"name":"ipj_status","value":"0","type":"integer"},
		{"name":"usu_login","value":"' .  $_POST['usu_login'] . '","type":"string"},
		{"name":"ctt_codigo","value":"' .  $_POST['ctt_codigo'] . '","type":"integer"},
		{"name":"ctt_modelo","value":"' .  $_POST['ctt_modelo'] . '","type":"integer"},
		{"name":"ipj_obs","value":"' .  base64_encode(utf8_decode($_POST['ipj_obs'])) . '","type":"string"}
	]}';
    $datapacket->add($filtro);
    $retInsert = $datapacket->open(false, true);
	echo "ok-".$retInsert;
	$datapacket->clear();
	
	if( $_POST["ipj_codigo"]=="" ){
		
		//historico de inclusão
		$filtro = '{"cod":"700727","params":[
			{"name":"pjh_tipo","value":"0","type":"integer"},
			{"name":"ipj_codigo","value":"' . $retInsert . '","type":"integer"},
			{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
			{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
			{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
			{"name":"pjh_historico","value":"' . base64_encode("Criou este Projeto") . '","type":"string"}
		]}';
		$datapacket->add($filtro);
		$datapacket->open();
		$datapacket->clear();
		
		/*
		membros agora nao estao no item e sim no projeto pai
		$_POST["membros"] = json_decode($_POST["membros"], true);
		if( isset($_POST["membros"]) && is_array($_POST["membros"]) ){
			foreach($_POST["membros"] as $membro){
				$filtro = '{"cod":"700721","params":[
					{"name":"ipj_codigo","value":"' . $retInsert . '","type":"integer"},
					{"name":"cad_codigo","value":"' . $membro[0] . '","type":"integer"},
					{"name":"cad_nomeraz","value":"' . $membro[1] . '","type":"string"},
					{"name":"usu_login","value":"' . $membro[2] . '","type":"string"}
				]}';
				$datapacket->add($filtro);
				print_r($filtro);
			}
			$datapacket->open();
			$datapacket->clear();
		}
		*/
		
		$_POST["tags"] = json_decode($_POST["tags"], true);
		if( isset($_POST["tags"]) && is_array($_POST["tags"]) ){
			foreach($_POST["tags"] as $tag){
				$filtro = '{"cod":"700722","params":[
					{"name":"ipj_codigo","value":"' . $retInsert . '","type":"integer"},
					{"name":"tag_codigo","value":"' . $tag[0] . '","type":"integer"},
					{"name":"tag_descr","value":"' . $tag[1] . '","type":"string"},
					{"name":"tag_cor","value":"' . $tag[2] . '","type":"string"}
				]}';
				$datapacket->add($filtro);
				print_r($filtro);
			}
			$datapacket->open();
			$datapacket->clear();
		}
		
	}
	
	$ipj_codigo = ( isset($_POST["ipj_codigo"]) && $_POST["ipj_codigo"]!="" ) ? $_POST["ipj_codigo"] : $retInsert;
	//remover parcelas anteriores
	$filtro = '{"cod":"700785","params":[
		{"name":"doc_origem","value":"12","type":"integer"},
		{"name":"doc_origem_codigo","value":"' . $ipj_codigo . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	//PARCELAS
	if( isset($_POST["parcelas"]) && $_POST["parcelas"]!="" && isset($_POST["cad_codigo"]) ){

		$parcelas = json_decode($_POST["parcelas"], true);
		$doc_codigo  = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(1000,9999);
		if(is_array($parcelas)){
			for($i = 0; $i<count($parcelas); $i++){

				$doc_codigo2 = $doc_codigo + $i;
				$descritivo = "Projeto nro ".$ipj_codigo;
				$descritivo.= (count($parcelas)>1) ? ' - parcela '.($i+1) : "";
				$doc_numero = "PRJ".$ipj_codigo;
				
				//PARCELA
				$filtroParc  = '{"cod":"500133", "params":[
					{"name":"doc_codigo", "value":"'.$doc_codigo2.'", "type":"string"},
					{"name":"doc_numero", "value":"'.$doc_numero.'-'.($i+1).'", "type":"string"},
					{"name":"doc_tipo", "value":"'.$parcelas[$i]['doc_tipo'].'", "type":"integer"},
					{"name":"doc_pagrec", "value":"2", "type":"integer"},
					{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
					{"name":"doc_valor", "value":"'.$parcelas[$i]['doc_valor'].'", "type":"float"},
					{"name":"doc_dtvcto", "value":"'.$parcelas[$i]['doc_dtvcto'].'", "type":"string"},
					{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
					{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
					{"name":"doc_descr", "value":"'.$descritivo.'", "type":"string"},
					{"name":"doc_status", "value":"0", "type":"integer"},
					{"name":"doc_codbar", "value":" ", "type":"string"},
					{"name":"doc_linhadig", "value":"NULL", "type":"other"},
					{"name":"doc_banco", "value":"NULL", "type":"other"},
					{"name":"doc_agencia", "value":"NULL", "type":"other"},
					{"name":"doc_conta", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($company->emp_multa) && $company->emp_multa>0 ) ? '{"name":"doc_multa", "value":"'.$company->emp_multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
				$filtroParc.= ( isset($company->emp_jurosdiario) && $company->emp_jurosdiario>0 ) ? '{"name":"doc_juros", "value":"'.$company->emp_jurosdiario.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
				$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},
					{"name":"doc_dias_envio", "value":"0", "type":"integer"},
					{"name":"doc_nparc", "value":"'.($i+1).'", "type":"integer"},
					{"name":"doc_tparc", "value":"'.(count($parcelas)).'", "type":"integer"},
					{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
					{"name":"doc_obs", "value":"'.$descritivo.'", "type":"string"},
					{"name":"cad_codigo", "value":"'.$_POST["cad_codigo"].'", "type":"string"},
					{"name":"ser_codigo", "value":"1", "type":"string"},';
				$filtroParc.= ($_POST['ccu_codigo'] && $_POST['ccu_codigo']!="" && $_POST['ccu_codigo']!="Novo Registro") ? '{"name":"ccu_codigo","value":"'.$_POST['ccu_codigo'].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
				$filtroParc.='{"name":"doc_cod_pai", "value":"NULL", "type":"other"},';
				$filtroParc.= ($_POST['plc_codigo'] && $_POST['plc_codigo']!="" && $_POST['plc_codigo']!="Novo Registro") ? '{"name":"plc_codigo","value":"'.$_POST['plc_codigo'].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
				$filtroParc.= '{"name":"cad_codatend", "value":"NULL", "type":"other"},
					{"name":"doc_carteira", "value":"", "type":"string"},
					{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
					{"name":"svc_codigo", "value":"NULL", "type":"other"},
					{"name":"doc_sacador", "value":"NULL", "type":"other"},';
				$filtroParc.= (isset($_POST['cta_codigo']) && $_POST['cta_codigo']!='') ? '{"name":"cta_codigo","value":"'.$_POST['cta_codigo'].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
				$filtroParc.= '{"name":"doc_dias_protesto", "value":"10", "type":"integer"},
					{"name":"doc_protesto", "value":"0", "type":"integer"},
					{"name":"doc_previsao", "value":"1", "type":"integer"},
					{"name":"doc_origem", "value":"12", "type":"integer"},
					{"name":"doc_origem_codigo", "value":"'.$ipj_codigo.'", "type":"string"}';
				$filtroParc.= ']}';
				
				$datapacket->add($filtroParc);				
				
				//log inclusao docto
				$filtrolog = '{"cod":"501240","params":[
					{"name":"lgd_tipo","value":"1","type":"integer"},
					{"name":"doc_codigo","value":"'.$doc_codigo2.'","type":"string"},
					{"name":"usu_login","value":"'.$_POST["usu_login"].'","type":"string"},
					{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
					{"name":"lgd_descr","value":"Documento cadastrado e vinculado ao Projeto nro '.$retInsert.'","type":"string"}
				]}';
				$datapacket->add($filtrolog);
				
			}
			$datapacket->open();
			$datapacket->clear();
		}
		
	}

} elseif (isset($_POST["acao"]) && $_POST["acao"] == "deletar") {

    $filtro = '{"cod":"700709","params":[
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"}
	]}';
    $datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	echo "ok";
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode('Excluiu este Projeto') . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();

} elseif (isset($_POST["acao"]) && $_POST["acao"] == "atualizar") {
	
	$filtro = '{"cod":"700783","params":[
		{"name":"etp_codigo","value":"' . $_POST['etp_codigo'] . '","type":"integer"}
	]}';
    $datapacket->add($filtro);
	$etapa = $datapacket->open();
	$datapacket->clear();
	
	if( isset($etapa) && isset($etapa[0]) && isset($etapa[0]["etp_tipo"]) ){
		//recursos
		if($etapa[0]["etp_tipo"]==1){
			
			$filtro = '{"cod":"700784","params":[
				{"name":"doc_origem","value":"12","type":"integer"},
				{"name":"doc_origem_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			$datapacket->clear();
		
		//cronograma		
		}elseif($etapa[0]["etp_tipo"]==2){
			
			if( isset($_POST['age_data']) && $_POST['age_data']!="" && substr($_POST['age_data'],0,10)!="00/00/0000" && isset($_POST['age_hora']) && $_POST['age_hora']!="" && isset($_POST['age_titulo']) && $_POST['age_titulo']!="" ){
				$filtro = '{"cod":"701230", "params":[
					{"name":"age_codigo","value":"","type":"string"},
					{"name":"age_data","value":"'.implode("-", array_reverse(explode("/",substr($_POST["age_data"],0,10)))).'","type":"string"},
					{"name":"age_semana","value":"","type":"string"},
					{"name":"age_hora","value":"'.$_POST['age_hora'].'","type":"string"},
					{"name":"age_titulo","value":"'.$_POST['age_titulo'].'","type":"string"},
					{"name":"age_descr","value":"","type":"string"},
					{"name":"age_notificar","value":"0","type":"integer"},
					{"name":"age_sms","value":"0","type":"integer"},
					{"name":"age_email","value":"0","type":"integer"},
					{"name":"age_status","value":"0","type":"integer"},
					{"name":"usu_login","value":"","type":"string"},
					{"name":"agc_codigo","value":"NULL","type":"other"},
					{"name":"cad_codigo","value":"NULL","type":"other"},
					{"name":"cad_responsavel","value":"NULL","type":"other"},
					{"name":"svc_codigo","value":"NULL","type":"other"},
					{"name":"age_valor","value":"0","type":"float"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
			}
		
		//custos
		}elseif($etapa[0]["etp_tipo"]==3){
		
		
		//CONTRATO
		}elseif($etapa[0]["etp_tipo"]==4){
			
			$filtro = '{"cod":"700728","params":[
				{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"}
			]}';
			$datapacket->add($filtro);
			$proj = $datapacket->open();
			$datapacket->clear();
			
			if( $proj && $proj[0] && $proj[0]["svc_codigo"] && $proj[0]["svc_codigo"]!="" && $proj[0]["cad_codigo"] && $proj[0]["cad_codigo"]!="" && !$proj[0]["ctt_codigo"]  ){
				//ultimo contrato cadastrado
				
				$filtro2 = '{"cod":"700172","params":[
					{"name":"db","value":"'.$TParams->getDbSge().'","type":"string"}
				]}';
				$datapacket->add($filtro2);
				$ret = $datapacket->open();
				$datapacket->clear();
				$ctt_codigo = $ret[0]["ctt_codigo"];
			
				$filtro = '{"cod":"700127","params":[';
				$filtro.= ( isset($ctt_codigo ) && $ctt_codigo!="" ) ? '{"name":"ctt_codigo","value":"'.$ctt_codigo.'","type":"integer"},' : '{"name":"ctt_codigo","value":"","type":"string"},';
				$filtro.= ( isset($ctt_codigo) && $ctt_codigo!="" ) ? '{"name":"ctt_numero","value":"'.$ctt_codigo.'","type":"string"},' : '{"name":"ctt_numero","value":"","type":"string"},';
				$filtro.= '{"name":"ctg_codigo","value":"NULL","type":"other"},
					{"name":"sub_codigo","value":"NULL","type":"other"},
					{"name":"cad_codigo","value":"'.$proj[0]['cad_codigo'].'","type":"string"},
					{"name":"cad_codvend","value":"NULL","type":"other"},
					{"name":"svc_codigo","value":"'.$proj[0]['svc_codigo'].'","type":"integer"},
					{"name":"eve_codigo","value":"NULL","type":"other"},
					{"name":"ctt_svc_obs","value":"'.$proj[0]['ipj_obs'].'","type":"string"},
					{"name":"ctt_valor","value":"'.$proj[0]['ipj_valor'].'","type":"float"},
					{"name":"ctt_desconto","value":"0.00","type":"float"},
					{"name":"ctt_acrescimo","value":"0.00","type":"float"},
					{"name":"frq_codigo","value":"NULL","type":"other"},';
				$filtro.= ($proj[0]['ipj_data'] && $proj[0]['ipj_data']!="" && $proj[0]['ipj_data']!=0) ? '{"name":"ctt_data","value":"'.$proj[0]['ipj_data'].' 00:00:00","type":"string"},' : '{"name":"ctt_data","value":"'.date('Y-m-d H:i:s').'","type":"string"},';
				$filtro.= ($proj[0]['ipj_data'] && $proj[0]['ipj_data']!="" && $proj[0]['ipj_data']!=0) ? '{"name":"ctt_dataini","value":"'.$proj[0]['ipj_data'].' 00:00:00","type":"string"},' : '{"name":"ctt_dataini","value":"'.date('Y-m-d H:i:s').'","type":"string"},';
				$filtro.= '{"name":"ctt_datafim","value":"NULL","type":"other"},
					{"name":"ctt_datavcto","value":"NULL","type":"other"},
					{"name":"doc_tipo","value":"NULL","type":"other"},';
				$filtro.= ( $proj[0]['ipj_data'] && $proj[0]['ipj_data']!="" && $proj[0]['ipj_data']!=0 ) ? '{"name":"ctt_datacobr","value":"'.$proj[0]['ipj_data'].' 00:00:00","type":"string"},' : '{"name":"ctt_datacobr","value":"NULL","type":"other"},';
				$filtro.= '{"name":"ctt_obs","value":"'.$proj[0]['ipj_descr'].'","type":"string"},
					{"name":"ctt_status","value":"1","type":"integer"},';
				$filtro.= ( isset($proj[0]['cdp_codigo']) && $proj[0]['cdp_codigo']!="" ) ? '{"name":"cdp_codigo","value":"'.$proj[0]['cdp_codigo'].'","type":"integer"},' : '{"name":"cdp_codigo","value":"999","type":"integer"},';
				$filtro.= '{"name":"ctt_anexo","value":"NULL","type":"other"},
					{"name":"ctt_testemunha1","value":"NULL","type":"other"},
					{"name":"ctt_testemunha1cpf","value":"NULL","type":"other"},
					{"name":"ctt_testemunha2","value":"NULL","type":"other"},
					{"name":"ctt_testemunha2cpf","value":"NULL","type":"other"},
					{"name":"ctt_previsao","value":"NULL","type":"other"},
					{"name":"ctt_carteira","value":"NULL","type":"other"},
					{"name":"ctt_proporcional","value":"0","type":"integer"},
					{"name":"ctt_periodo","value":"0","type":"integer"},
					{"name":"ctt_nfse","value":"0","type":"integer"},';
				$filtro.= (isset($proj[0]["cta_codigo"]) && $proj[0]["cta_codigo"]!="Novo Registro" && $proj[0]["cta_codigo"]!="") ? '{"name":"cta_codigo","value":"'.$proj[0]["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
				$filtro.= (isset($proj[0]["plc_codigo"]) && $proj[0]["plc_codigo"]!="Novo Registro" && $proj[0]["plc_codigo"]!="") ? '{"name":"plc_codigo","value":"'.$proj[0]["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
				$filtro.= (isset($proj[0]["ccu_codigo"]) && $proj[0]["ccu_codigo"]!="Novo Registro" && $proj[0]["ccu_codigo"]!="") ? '{"name":"ccu_codigo","value":"'.$proj[0]["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
				$filtro.= (isset($proj[0]["ctt_modelo"]) && $proj[0]["ctt_modelo"]!="Novo Registro" && $proj[0]["ctt_modelo"]!="") ? '{"name":"ctt_modelo","value":"'.$proj[0]["ctt_modelo"].'","type":"integer"},' : '{"name":"ctt_modelo","value":"NULL","type":"other"},';
				$filtro.= '{"name":"ctt_autentiqueid","value":"NULL","type":"other"}';
				$filtro.= ']}';

				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
				//atualizar o projeto com codigo do contrato
				$filtro = '{"cod":"700803","params":[
					{"name":"ctt_codigo","value":"' . $ctt_codigo . '","type":"integer"},
					{"name":"ipj_codigo","value":"' . $proj[0]['ipj_codigo'] . '","type":"integer"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();				
				
				//registrar contrato no log do projeto
				$filtro = '{"cod":"700727","params":[
					{"name":"pjh_tipo","value":"3","type":"integer"},
					{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
					{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
					{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
					{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
					{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Anexou: CONTRATO-'.$ctt_codigo.'.pdf')) . '","type":"string"}
				]}';
				$datapacket->add($filtro);
				$datapacket->open();
				$datapacket->clear();
				
			}
			
		}
	}

    $filtro = '{"cod":"700726","params":[
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"etp_codigo","value":"' . $_POST['etp_codigo'] . '","type":"integer"}
	]}';
    $datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Alterou este Projeto para a etapa '.$_POST["etp_descr"])) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
				
	echo "ok";

} 
/*
elseif ( isset($_POST["acao"]) && $_POST["acao"] == "membros" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700724","params":[
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"}
	]}';
	$datapacket->add($filtro);
	$ret = $datapacket->open();
	$i=0;
	foreach($ret as $r){
		$ret[$i]["_id"] = $r["cad_codigo"];
		$ret[$i]["_value"] = $r["cad_nomeraz"];
		$ret[$i]["_value2"] = $r["usu_login"];
		$i++;
	}
	print_r(json_encode($ret));
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "addmembro" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700721","params":[
		{"name":"ipj_codigo","value":"' . $_POST["ipj_codigo"] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST["cad_codigo"] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . $_POST["cad_nomeraz"] . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST["usu_login2"] . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Adicionou o membro '.$_POST["cad_nomeraz"].' a este Projeto')) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "delmembro" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700729","params":[
		{"name":"ipj_codigo","value":"' . $_POST["ipj_codigo"] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST["cad_codigo"] . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Removeu o membro '.$_POST["cad_nomeraz"].' deste Projeto')) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
} 
*/
elseif ( isset($_POST["acao"]) && $_POST["acao"] == "tags" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700725","params":[
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"}
	]}';
	$datapacket->add($filtro);
	$ret = $datapacket->open();
	$i=0;
	foreach($ret as $r){
		$ret[$i]["_id"] = $r["tag_codigo"];
		$ret[$i]["_value"] = $r["tag_descr"];
		$ret[$i]["_value2"] = $r["tag_cor"];
		$i++;
	}
	print_r(json_encode($ret));
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "addtag" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700722","params":[
		{"name":"ipj_codigo","value":"' . $_POST["ipj_codigo"] . '","type":"integer"},
		{"name":"tag_codigo","value":"' . $_POST["tag_codigo"] . '","type":"integer"},
		{"name":"tag_descr","value":"' . $_POST["tag_descr"] . '","type":"string"},
		{"name":"tag_cor","value":"' . $_POST["tag_cor"] . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Adicionou a tag '.$_POST["tag_descr"].' a este Projeto')) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "deltag" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700781","params":[
		{"name":"ipj_codigo","value":"' . $_POST["ipj_codigo"] . '","type":"integer"},
		{"name":"tag_codigo","value":"' . $_POST["tag_codigo"] . '","type":"integer"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"0","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Removeu a tag '.$_POST["tag_descr"].' deste Projeto')) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();
	$datapacket->clear();

}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "comentar" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"1","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Comentou: '.$_POST["ipj_comentario"])) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
	$datapacket->open();

}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "anexar" && isset($_POST['ipj_codigo']) ) {
	
	if( isset($_FILES['anexo_arq']['tmp_name']) ){
			
		$uploaddir = $TParams->uploads.$TParams->getCodigo()."/projetos/";
		if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
		$uploaddir.= $_POST["ipj_codigo"]."/";
		if (!is_dir($uploaddir))   mkdir($uploaddir, 0777, true);
		$extensao = array_reverse(explode(".", $_FILES['anexo_arq']['name']));
		$nome = $extensao[1];
		$extensao = strtolower($extensao[0]);
		
		//exit("Limite de Armazenamento excedido para seu plano (3GB), altere seu plano para continuar enviando arquivos.");
		
		if($extensao!="php" && $extensao!="exe" && $extensao!="js" && $extensao!="html" && $_FILES['anexo_arq']['error']==0){
			
			if( $_FILES['anexo_arq']['size'] <= 15000000 ){
		
				$array1 = array(" ", "á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç");
				$array2 = array("_", "a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C");
				$arq = str_replace($array1, $array2, $_FILES['anexo_arq']['name']);
				
				if( is_file($uploaddir.$arq) && file_exists($uploaddir.$arq) ){
					exit("Já existe um anexo com este nome para o mesmo projeto, favor escolha outro arquivo ou renomeie.");
				}
				
				if(@move_uploaded_file($_FILES['anexo_arq']['tmp_name'], $uploaddir.$arq)){
					
					$filtro = '{"cod":"700727","params":[
						{"name":"pjh_tipo","value":"2","type":"integer"},
						{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
						{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
						{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
						{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
						{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Anexou: '.$arq)) . '","type":"string"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
					
					//transferir os anexos do projeto para outro servidor
					$remote_file = '/public_html/'.$TParams->getCodigo().'/projetos/'.$_POST["ipj_codigo"].'/'.$arq;
					$ftp_host = 'jcmantovan.com.br'; /* host */
					$ftp_user_name = 'jcman@jcmantovan.com.br'; /* username */
					$ftp_user_pass = 'og7an65'; /* password */
					$local_file = $uploaddir.$arq;
					if (!file_exists($local_file)) {
						echo "Arquivo local não encontrado";
					}
					if (!is_readable($local_file)) {
						echo "Arquivo local não tem permissão de leitura";
					}
					$connect_it = ftp_connect( $ftp_host );
					if (!$connect_it) {
						echo "Não foi possível conectar ao servidor FTP";
					}
					$login_result = ftp_login( $connect_it, $ftp_user_name, $ftp_user_pass );
					if (!$login_result) {
						echo "Não foi logar no servidor FTP";
					}
					if (!ftp_pasv($connect_it, true)) {
						echo "não foi possivel ativar o modo passivo";
					}
					ftp_mkdir( $connect_it, '/public_html/'.$TParams->getCodigo().'/projetos/'.$_POST["ipj_codigo"].'/');
					if ( ftp_put( $connect_it, $remote_file, $local_file, FTP_BINARY ) ) {
						echo '{"success":"true", "arquivo":"'.$uploaddir.$arq.'"}';
					}else {
						echo "Erro ao efetuar upload.";
					}
					ftp_close( $connect_it );
					unlink($uploaddir.$arq);

					
				}else{
					exit("Erro ao efetuar upload.");
				}
				
			}else{
				exit("Arquivo muito grande, somente permitido arquivo com menos de 15MB");
			}
			
		}else{
			echo "Erro! extensão de arquivo inválida";
		}
	
	}else{
		echo "arquivo não encontrado";
	}
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "desanexar" && isset($_POST['pjh_codigo']) && isset($_POST['ipj_codigo']) ) {
	
	$uploaddir = $TParams->uploads.$TParams->getCodigo()."/projetos/".$_POST["ipj_codigo"]."/";
	
	$filtro = '{"cod":"700795","params":[
		{"name":"pjh_codigo","value":"' . $_POST['pjh_codigo'] . '","type":"integer"}
	]}';
	$datapacket->add($filtro);
	
	$anexo = str_replace("Anexou: ", "", base64_decode($_POST["pjh_historico"]));
	$filtro = '{"cod":"700727","params":[
		{"name":"pjh_tipo","value":"1","type":"integer"},
		{"name":"ipj_codigo","value":"' . $_POST['ipj_codigo'] . '","type":"integer"},
		{"name":"cad_codigo","value":"' . $_POST['usu_codigo'] . '","type":"string"},
		{"name":"cad_nomeraz","value":"' . ucwords(strtolower($_POST['usu_nome'])) . '","type":"string"},
		{"name":"usu_login","value":"' . $_POST['usu_login'] . '","type":"string"},
		{"name":"pjh_historico","value":"' . base64_encode(utf8_decode('Removeu o anexo: '.$anexo)) . '","type":"string"}
	]}';
	$datapacket->add($filtro);
				
	$datapacket->open();
	
	//deletar os anexos do projeto de outro servidor
	$remote_file = '/public_html/'.$TParams->getCodigo().'/projetos/'.$_POST["ipj_codigo"].'/'.$anexo;
	$ftp_host = 'jcmantovan.com.br'; /* host */
	$ftp_user_name = 'jcman@jcmantovan.com.br'; /* username */
	$ftp_user_pass = 'og7an65'; /* password */
	$local_file = $uploaddir.$arq;
	$connect_it = ftp_connect( $ftp_host );
	$login_result = ftp_login( $connect_it, $ftp_user_name, $ftp_user_pass );
	if ( ftp_delete( $connect_it, $remote_file ) ) {
		echo '{"success":"true", "arquivo":"'.$uploaddir.$arq.'"}';			
	}else {
		echo "Erro ao efetuar upload.";
	}
	ftp_close( $connect_it );
	
	unlink($uploaddir.$anexo);
	
}elseif ( isset($_POST["acao"]) && $_POST["acao"] == "historico" && isset($_POST['ipj_codigo']) ) {
	
	$filtro = '{"cod":"700782","params":[
		{"name":"ipj_codigo","value":"' . $_POST["ipj_codigo"] . '","type":"integer"}
	]}';
	$datapacket->add($filtro);
	$ret = $datapacket->open();
	print_r(json_encode($ret));
	
} else {
	
	if( isset($_POST["busca"]) && $_POST["busca"]!="" ){
		$busca = " and pi.ipj_titulo like '%".$_POST["busca"]."%' ";
	}else{
		$busca = "";
	}
	
	$filtro = "";
	if( isset($_POST["tag"]) && $_POST["tag"]!="" ){
		$filtro .= " and pt.tag_codigo = '".$_POST["tag"]."' ";
	}
	if( isset($_POST["responsavel"]) && $_POST["responsavel"]!="" ){
		$filtro .= " and pi.cad_responsavel = '".$_POST["responsavel"]."' ";
	}
	if( isset($_POST["data1"]) && $_POST["data1"]!="" ){
		$filtro .= " and pi.ipj_data >= '".implode("-",array_reverse(explode("/", $_POST["data1"])))."' ";
	}
	if( isset($_POST["data2"]) && $_POST["data2"]!="" ){
		$filtro .= " and pi.ipj_data <= '".implode("-",array_reverse(explode("/", $_POST["data2"])))."' ";
	}
	
	$filtro = '{"cod":"700723","params":[
		{"name":"busca","value":"' . $busca . '","type":"other"},
		{"name":"filtro","value":"' . $filtro . '","type":"other"},
		{"name":"prj_codigo","value":"' . $_REQUEST['prj_codigo'] . '","type":"integer"},
		{"name":"etp_codigo","value":"' . $_REQUEST['etp_codigo'] . '","type":"integer"},
		{"name":"usu_login","value":"' . $_REQUEST['usu_login'] . '","type":"string"}
	]}';
    $datapacket->add($filtro);
	$ret = $datapacket->open();
	$datapacket->clear();
	
	$i=0;
	foreach($ret as $r){
		
		$ret[$i]["ipj_titulo2"] = strtoupper(substr($ret[$i]["ipj_titulo"], 0, 11)."<br>".substr($ret[$i]["ipj_titulo"], 11, 11)."<br>".substr($ret[$i]["ipj_titulo"], 22, 11)."<br>".substr($ret[$i]["ipj_titulo"], 33));
		
		if( isset($r['cad_responsavel']) && $r['cad_responsavel']!="" ){
			$filtro = '{"cod":"700786","params":[
				{"name":"db","value":"' . $TParams->getDb() . '","type":"other"},
				{"name":"cad_codigo","value":"' . $r['cad_responsavel'] . '","type":"string"}
			]}';
			$datapacket->add($filtro);
			$ret2 = $datapacket->open();
			$datapacket->clear();
			foreach($ret2 as $r2){
				$ret[$i]["cad_nomeraz"] .= '<strong>'.ucwords(strtolower($r2["cad_nomeraz"])).'</strong><br>';
			}
		}
		
		$filtro = '{"cod":"700725","params":[
			{"name":"ipj_codigo","value":"' . $r['ipj_codigo'] . '","type":"integer"}
		]}';
		$datapacket->add($filtro);
		$ret3 = $datapacket->open();
		$datapacket->clear();
		foreach($ret3 as $r3){
			$ret[$i]["tag_cor"] .= $r3["tag_cor"].'{';
			$ret[$i]["tag_descr"] .= $r3["tag_descr"].'{';
		}
		
		$i++;
	}

    print_r(json_encode($ret));

}

?>
